# Contributing to ML Notebooks 101

We love your input! We want to make contributing to this project as easy and transparent as possible, whether it's:

- Reporting a bug
- Discussing the current state of the code
- Submitting a fix
- Proposing new features


## Steps to contribute

* Comment on the issue you want to work on. Make sure it's not assigned to someone else.

## What to contribute

* Any really useful implementation of ML algorithms in any framework. 
* Should add README.md with a bried explanation about usage, required environment and datasets link.
* Compatible old implementations with new fixes.
* Add REQUIREMENTS.md with the your Jupyter notebook.

### Making a PR

> - Make sure you have been assigned the issue to which you are making a PR.
> - If you make PR before being assigned, It will be labeled `invalid` and closed without merging.

* Fork the repo and clone it on your machine.
* Add a upstream link to main branch in your cloned repo
    ```
    git remote add upstream https://github.com/abhinand5/ml-notebooks-101.git
    ```
* Keep your cloned repo up to date by pulling from upstream (this will also avoid any merge conflicts while committing new changes)
    ```
    git pull upstream master
    ```
* Create your feature branch
    ```
    git checkout -b <feature-name>
    ```
* Commit all the changes
    ```
    git commit -am "Meaningful commit message"
    ```
* Push the changes for review
    ```
    git push origin <branch-name>
    ```
* Create a PR from our repo on Github.

### Additional Notes

* Code should be properly commented to ensure it's readability.
* If you've added code that should be tested, add tests as comments.
* Make sure your code is properly formatted.
* Link the relevant Issue the pull request!
* Use Flake8/Black to check code quality before committing. 

## Issue suggestions/Bug reporting

When you are creating an issue, make sure it's not already present. Furthermore, provide a proper description of the changes. If you are suggesting any code improvements, provide through details about the improvements.

**Great Issue suggestions** tend to have:

- A quick summary of the changes.
- In case of any bug provide steps to reproduce
  - Be specific!
  - Give sample code if you can.
  - What you expected would happen
  - What actually happens
  - Notes (possibly including why you think this might be happening, or stuff you tried that didn't work)


## License

By contributing, you agree that your contributions will be licensed under its  [Apache 2.0 License](http://www.apache.org/licenses/LICENSE-2.0).