<a name="readme-top"></a>

![](https://img.shields.io/badge/Microverse-blueviolet)

<div align="center">


</div>

<!-- Open pull request using the following structure

## Pronject Title: Branch title.............

### 🌟Features:

> - [ ] - [`i`]() ...........
> - [ ] - [`ii`]() ...................
> - [ ] - [`iii`]() ...................
> - [ ] - [`iiii`]() ...................
> - [ ] - [`iiiii`]() ...................

### [ 🚀 Project Demo](#)

-->

> # Bookstore CMS

| Desktop View Representation|
|---------------------------------------|
|<div align="center"><img src="./src/assets/project-image.PNG " width="auto" height="auto"/></div>|

<!-- TABLE OF CONTENTS -->

# 📗 Table of Contents

- [📖 About the Project](#about-project)
  - [🛠 Built With](#built-with)
    - [Tech Stack](#tech-stack)
    - [Key Features](#key-features)
  - [🚀 Live Demo](#live-demo)
- [💻 Getting Started](#getting-started)
  - [Setup](#setup)
  - [Prerequisites](#prerequisites)
  - [Install](#install)
  - [Usage](#usage)
  - [Run tests](#run-tests)
  - [Deployment](#triangular_flag_on_post-deployment)
- [👥 Authors](#authors)
- [🔭 Future Features](#future-features)
- [🤝 Contributing](#contributing)
- [⭐️ Show your support](#support)
- [🙏 Acknowledgements](#acknowledgements)
- [❓ FAQ (OPTIONAL)](#faq)
- [📝 License](#license)

<!-- PROJECT DESCRIPTION -->

# 📖 [Bookstore-CMS] <a name="about-project"></a>

> **[Bookstore-CMS]** Using React and Redux in the context of a real application to create a simplified version of Bookstore to: Display a list of books, Add a book and Remove a selected book.  

## 🛠 Built With <a name="built-with"></a>

### Tech Stack <a name="tech-stack"></a>
- <summary>Client</summary>
    <ul>
      <li><a href="https://reactjs.org/">React</a></li>
      <li><a href="https://reactjs.org/">Redux</a></li>
      <li><a href="https://reactjs.org/">API</a></li>
    </ul>

### Key Features <a name="key-features"></a>

- **[Responsive layout]**
- **[UX/UI accessibility]**
- **[Dynamic data]**

<p align="right">(<a href="#readme-top">back to top</a>)</p>

<!-- LIVE DEMO -->

## 🚀 Live Demo <a name="live-demo"></a>

> - [Live Demo on Gh-pages](https://ab-noori.github.io/bookstore-cms/)

<p align="right">(<a href="#readme-top">back to top</a>)</p>

<!-- GETTING STARTED -->

## 💻 Getting Started <a name="getting-started"></a>

To get a local copy up and running, follow these steps:

### Prerequisites

In order to run this project you need:
  - A browser of your choice.
  - A text editor of your choice.
  - An installed node.js on your local system

### Setup

Clone this repository to your desired folder:

- Use the following Commands:

      cd your-desired-folder
      git clone git@github.com:ab-noori/bookstore-cms.git


### Install
- Install this project with:

       npx create-react-app my-app
       cd my-app
       npm start


### Usage
- Use the following commands to run on your local system:

      npm run build
      npm run deploy

### Run tests
- Run the following script and style test:

      npx eslint "**/*.{js,jsx}"
      npx eslint "**/*.{js,jsx}" --fix

      npx stylelint "**/*.{css,scss}"
      npx stylelint "**/*.{css,scss}" --fix
 
### Deployment
- 1- install `gh-pages` with the following command:

      npm i -D gh-pages

- 2- Add `homepage` to project's Jason file:

      "homepage": "https://ab-noori.github.io/bookstore-cms",

- 3- Add the following scripts to the project's Jason file:

      "predeploy": "npm run build",
      "deploy": "gh-pages -d build "

- 4- Finally run the following command:

      npm run deploy


<p align="right">(<a href="#readme-top">back to top</a>)</p>


## 👥 Authors <a name="authors"></a>

👤 **Abdul Ali Noori**

- GitHub: [@ab-noori](https://github.com/ab-noori)
- Twitter: [@AbdulAliNoori4](https://twitter.com/AbdulAliNoori4)
- LinkedIn: [abdul-ali-noori](https://www.linkedin.com/in/abdul-ali-noori-384b85195/)


## 🔭 Future Features <a name="future-features"></a>

- [ ] **[Add About page]**
- [ ] **[Add Contact page]**

<p align="right">(<a href="#readme-top">back to top</a>)</p>

## 🤝 Contributing <a name="contributing"></a>

Contributions, issues, and feature requests are welcome!

Feel free to check the [issues page](https://github.com/ab-noori/bookstore-cms/issues).

<p align="right">(<a href="#readme-top">back to top</a>)</p>

## ⭐️ Show your support <a name="support"></a>

 
  If you like this project, give it a star.

<p align="right">(<a href="#readme-top">back to top</a>)</p>


## 🙏 Acknowledgments <a name="acknowledgements"></a>

  I would like to thank Microverse and my coding partners. Also, I want to give credit to [`Nerd's lesson`](https://www.youtube.com/@Nerdslesson)
YouTub Channel, its [`react tutorial`](https://www.youtube.com/watch?v=cd3P3yXyx30) is really helpful.

<p align="right">(<a href="#readme-top">back to top</a>)</p>


## ❓ FAQ (OPTIONAL) <a name="faq"></a>

- **How to make it mobile friendly?**

  - Put a viewport tag in the header

- **How to design the site?**

  - Draw a mockup before starting to code

<p align="right">(<a href="#readme-top">back to top</a>)</p>


## 📝 License <a name="license"></a>

This project is [MIT](./LICENSE) licensed.

<p align="right">(<a href="#readme-top">back to top</a>)</p>
