import Header from "@/components/Header";
import { cn } from "@/lib/utils";
import NextTopLoader from 'nextjs-toploader';

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <div className={cn("bg-white bg-[radial-gradient(100%_50%_at_50%_0%,rgba(0,163,255,0.13)_0,rgba(0,163,255,0)_50%,rgba(0,163,255,0)_100%)] dark:bg-neutral-950 dark:bg-[radial-gradient(ellipse_80%_80%_at_50%_-20%,rgba(120,119,198,0.3),rgba(255,255,255,0))]")}>
      <Header />
      <NextTopLoader />
      <main className="py-3 max-w-5xl px-4 lg:px-0 mx-auto">{children}</main>
    </div>
  );
}
