# Contributing

Thank you for your interest in contributing to this repository. To ensure a smooth and collaborative environment, please follow these guidelines. Before contributing, set up the project locally using the steps outlined in [README.md](./README.md).

## Why these guidelines ?

Our goal is to create a healthy and inclusive space for contributions. Remember that open-source contribution is a collaborative effort, not a competition.

## General guidelines

- Work only on one issue at a time since it will provide an opportunity for others to contribute as well.

- Note that each open-source repository generally has its own guidelines, similar to these. Always read them before starting your contributions.

## How to get an issue assigned

- To get an issue assigned, provide a small description as to how you are planning to tackle this issue.

> Ex - If the issue is about UI changes, you should create a design showing how you want it to look on the UI (make it using figma, paint, etc)

- This will allow multiple contributors to discuss their approach to tackle the issue. The maintainer will then assign the issue.

## After getting the issue assigned

- Create your own branch instead of working directly on the main branch.

- Provide feedback every 24-48 hours if an issue is assigned to you. Otherwise, it may be reassigned.

- When submitting a pull request, please provide a screenshot or a screen-recording showcasing your work.

## Don't while contributing

- Avoid comments like "Please assign this issue to me" or "can i work on this issue ?"

- Refrain from tagging the maintainer to assign issues or review pull requests.

- Don't make any pull request for issues you are not assigned to. It will be closed without merging.

Happy Contributing!
