#include "../include/platform/acwaifuos.h"

ACPI_STATUS AcpiOsInitialize()
{
	return AE_OK;
}

ACPI_STATUS AcpiOsTerminate()
{
	return AE_OK;
}

ACPI_PHYSICAL_ADDRESS AcpiOsGetRootPointer()
{
	ACPI_PHYSICAL_ADDRESS Ret = 0;
	AcpiFindRootPointer(&Ret);
	return Ret;
}

ACPI_STATUS AcpiOsPredefinedOverride(const ACPI_PREDEFINED_NAMES *PredefinedObject, ACPI_STRING *NewValue)
{
	*NewValue = NULL;
	return AE_OK;
}

ACPI_STATUS AcpiOsTableOverride(ACPI_TABLE_HEADER *ExistingTable, ACPI_TABLE_HEADER **NewTable)
{
	*NewTable = NULL;
	return AE_OK;
}

vptr AcpiOsMapMemory(ACPI_PHYSICAL_ADDRESS PhysicalAddress, ACPI_SIZE Length)
{
	const size_t PAGE_SIZE = 0x1000;
	size_t nPAGES = Length / PAGE_SIZE;
	if (Length % PAGE_SIZE) nPAGES += 1;

	for (size_t x = 0; x < nPAGES; x++)
	{
		vptr address = ((size_t)PhysicalAddress) + (x * PAGE_SIZE);
		G_MapMemory(address, address);
	}

	return (vptr)(((UINT64)PhysicalAddress));
}

void AcpiOsUnmapMemory(vptr where, ACPI_SIZE length)
{
	const size_t PAGE_SIZE = 0x1000;
	size_t nPAGES = Length / PAGE_SIZE;
	if (Length % PAGE_SIZE) nPAGES += 1;
	FreePages(where, nPAGES);
}

ACPI_STATUS AcpiOsGetPhysicalAddress(vptr LogicalAddress, ACPI_PHYSICAL_ADDRESS *PhysicalAddress)
{
	*PhysicalAddress = LogicalAddress;
	return AE_OK;
}

vptr AcpiOsAllocate(ACPI_SIZE Size)
{
	return malloc(Size);
}

void AcpiOsFree(void* Memory)
{
	free(Memory);
}

BOOLEAN AcpiOsReadable(void *Memory, ACPI_SIZE Length)
{
	// todo: this
}

BOOLEAN AcpiOsWritable(void *Memory, ACPI_SIZE Length)
{
	// todo: this
}
