#ifndef __ACWAIFUOS_H__
#define __ACWAIFUOS_H__

#define ACPI_MACHINE_WIDTH 64
#define ACPI_DEBUGGER

#define ACPI_USE_SYSTEM_INTTYPES
#define ACPI_USE_GPE_POLLING

#define ACPI_CACHE_T                ACPI_MEMORY_LIST
#define ACPI_USE_LOCAL_CACHE        1

#ifdef CONFIG_ACPI_REDUCED_HARDWARE_ONLY
#define ACPI_REDUCED_HARDWARE 1
#endif

#ifdef CONFIG_ACPI_DEBUGGER
#define ACPI_DEBUGGER
#endif

#ifdef CONFIG_ACPI_DEBUG
#define ACPI_MUTEX_DEBUG
#endif

#include <cexport.h>
#include "../actypes.h"
#include "../acpi.h"

#ifndef __cdecl
#define __cdecl
#endif

ACPI_STATUS AcpiOsInitialize();

ACPI_STATUS AcpiOsTerminate();

ACPI_PHYSICAL_ADDRESS AcpiOsGetRootPointer();

ACPI_STATUS AcpiOsPredefinedOverride(const ACPI_PREDEFINED_NAMES *PredefinedObject, ACPI_STRING *NewValue);

ACPI_STATUS AcpiOsTableOverride(ACPI_TABLE_HEADER *ExistingTable, ACPI_TABLE_HEADER **NewTable);

vptr AcpiOsMapMemory(ACPI_PHYSICAL_ADDRESS PhysicalAddress, ACPI_SIZE Length);

void AcpiOsUnmapMemory(vptr where, ACPI_SIZE length);

ACPI_STATUS AcpiOsGetPhysicalAddress(vptr LogicalAddress, ACPI_PHYSICAL_ADDRESS *PhysicalAddress);

vptr AcpiOsAllocate(ACPI_SIZE Size);

void AcpiOsFree(void* Memory);

BOOLEAN AcpiOsReadable(void *Memory, ACPI_SIZE Length);

BOOLEAN AcpiOsWritable(void *Memory, ACPI_SIZE Length);

ACPI_THREAD_ID AcpiOsGetThreadId();

ACPI_STATUS AcpiOsExecute(ACPI_EXECUTE_TYPE Type, ACPI_OSD_EXEC_CALLBACK Function, void *Context);

void AcpiOsSleep(UINT64 Milliseconds);

ACPI_STATUS AcpiOsCreateSemaphore(UINT32 MaxUnits, UINT32 InitialUnits, ACPI_SEMAPHORE *OutHandle);
ACPI_STATUS AcpiOsDeleteSemaphore(ACPI_SEMAPHORE Handle);
ACPI_STATUS AcpiOsWaitSemaphore(ACPI_SEMAPHORE Handle, UINT32 Units, UINT16 Timeout);
ACPI_STATUS AcpiOsSignalSemaphore(ACPI_SEMAPHORE Handle, UINT32 Units);

ACPI_STATUS AcpiOsCreateLock(ACPI_SPINLOCK *OutHandle);
void AcpiOsDeleteLock(ACPI_HANDLE Handle);
ACPI_CPU_FLAGS AcpiOsAcquireLock(ACPI_SPINLOCK Handle);
void AcpiOsReleaseLock(ACPI_SPINLOCK Handle, ACPI_CPU_FLAGS Flags);

ACPI_STATUS AcpiOsInstallInterruptHandler(UINT32 InterruptLevel, ACPI_OSD_HANDLER Handler, void *Context);
ACPI_STATUS AcpiOsRemoveInterruptHandler(UINT32 InterruptNumber, ACPI_OSD_HANDLER Handler);

ACPI_STATUS AcpiOsCreateMutex(ACPI_MUTEX *OutHandle);
void AcpiOsDeleteMutex(ACPI_MUTEX Handle);
ACPI_STATUS AcpiOsAcquireMutex(ACPI_MUTEX Handle, UINT16 Timeout)
void AcpiOsReleaseMutex(ACPI_MUTEX Handle);

#endif /* __ACWAIFUOS_H__ */