import React, { useEffect, useState, MouseEvent, SetStateAction } from 'react';
import CommonBreadcrumb from '/@/components/CommonBreadcrumb';
import { Input } from 'antd';
import MarkdownIt from 'markdown-it';
import hljs from 'highlight.js';
import { useChangeLang } from '/@/hooks';
import style from './index.module.less';
import 'highlight.js/styles/atom-one-dark.css';

const { TextArea } = Input;

const md: {
  render: (val: string) => SetStateAction<string>;
  utils: {
    escapeHtml: (val: string) => string;
  };
} = new MarkdownIt({
  html: true,
  linkify: true,
  typographer: true,
  highlight: function (str: string, lang: string) {
    if (lang && hljs.getLanguage(lang)) {
      try {
        return (
          '<pre class="hljs" style="width: 30vw;"><code>' +
          hljs.highlight(str, { language: lang, ignoreIllegals: true }).value +
          '</code></pre>'
        );
      } catch (__) {}
    }

    return (
      '<pre class="hljs" style="width: 30vw;"><code>' + md.utils.escapeHtml(str) + '</code></pre>'
    );
  },
});

export default function Markwodn() {
  const [mdValue, setMdValue] = useState<string>(`## Hello World`);
  const [html, setHtml] = useState<string>('');
  const { t } = useChangeLang();

  const onChange = (
    e: MouseEvent<Element, globalThis.MouseEvent> & {
      target: { value: string };
    },
  ) => {
    console.log('Change:', e.target.value);
    const value = e.target.value;
    setMdValue(value);
  };

  useEffect(() => {
    setHtml(md.render(mdValue));
  }, [mdValue]);

  return (
    <div>
      <CommonBreadcrumb arr={[t('components.markdown.menu'), t('components.markdown.subMenu')]} />
      <div className={style['content']}>
        <TextArea
          rows={4}
          value={mdValue}
          // @ts-ignore
          onChange={onChange}
          className={style['text-area']}
        />
        <div dangerouslySetInnerHTML={{ __html: html }}></div>
      </div>
    </div>
  );
}
