﻿CREATE SCHEMA taskill;

CREATE TABLE taskill.asp_net_roles (
    id bigint GENERATED BY DEFAULT AS IDENTITY,
    name character varying(256) NULL,
    normalized_name character varying(256) NULL,
    concurrency_stamp text NULL,
    CONSTRAINT pk_asp_net_roles PRIMARY KEY (id)
);

CREATE TABLE taskill.taskillers (
    id bigint GENERATED BY DEFAULT AS IDENTITY,
    user_name character varying(256) NULL,
    normalized_user_name character varying(256) NULL,
    email character varying(256) NULL,
    normalized_email character varying(256) NULL,
    email_confirmed boolean NOT NULL,
    password_hash text NULL,
    security_stamp text NULL,
    concurrency_stamp text NULL,
    phone_number text NULL,
    phone_number_confirmed boolean NOT NULL,
    two_factor_enabled boolean NOT NULL,
    lockout_end timestamp with time zone NULL,
    lockout_enabled boolean NOT NULL,
    access_failed_count integer NOT NULL,
    CONSTRAINT pk_taskillers PRIMARY KEY (id)
);

CREATE TABLE taskill.asp_net_role_claims (
    id integer GENERATED BY DEFAULT AS IDENTITY,
    role_id bigint NOT NULL,
    claim_type text NULL,
    claim_value text NULL,
    CONSTRAINT pk_asp_net_role_claims PRIMARY KEY (id),
    CONSTRAINT fk_asp_net_role_claims_asp_net_roles_role_id FOREIGN KEY (role_id) REFERENCES taskill.asp_net_roles (id) ON DELETE CASCADE
);

CREATE TABLE taskill.asp_net_user_logins (
    login_provider text NOT NULL,
    provider_key text NOT NULL,
    provider_display_name text NULL,
    user_id bigint NOT NULL,
    CONSTRAINT pk_asp_net_user_logins PRIMARY KEY (login_provider, provider_key),
    CONSTRAINT fk_asp_net_user_logins_taskillers_user_id FOREIGN KEY (user_id) REFERENCES taskill.taskillers (id) ON DELETE CASCADE
);

CREATE TABLE taskill.asp_net_user_roles (
    user_id bigint NOT NULL,
    role_id bigint NOT NULL,
    CONSTRAINT pk_asp_net_user_roles PRIMARY KEY (user_id, role_id),
    CONSTRAINT fk_asp_net_user_roles_asp_net_roles_role_id FOREIGN KEY (role_id) REFERENCES taskill.asp_net_roles (id) ON DELETE CASCADE,
    CONSTRAINT fk_asp_net_user_roles_taskillers_user_id FOREIGN KEY (user_id) REFERENCES taskill.taskillers (id) ON DELETE CASCADE
);

CREATE TABLE taskill.asp_net_user_tokens (
    user_id bigint NOT NULL,
    login_provider text NOT NULL,
    name text NOT NULL,
    value text NULL,
    CONSTRAINT pk_asp_net_user_tokens PRIMARY KEY (user_id, login_provider, name),
    CONSTRAINT fk_asp_net_user_tokens_taskillers_user_id FOREIGN KEY (user_id) REFERENCES taskill.taskillers (id) ON DELETE CASCADE
);

CREATE TABLE taskill.claims (
    id integer GENERATED BY DEFAULT AS IDENTITY,
    user_id bigint NOT NULL,
    claim_type text NULL,
    claim_value text NULL,
    CONSTRAINT pk_claims PRIMARY KEY (id),
    CONSTRAINT fk_claims_taskillers_user_id FOREIGN KEY (user_id) REFERENCES taskill.taskillers (id) ON DELETE CASCADE
);

CREATE TABLE taskill.labels (
    id bigint GENERATED BY DEFAULT AS IDENTITY,
    user_id bigint NOT NULL,
    name text NOT NULL,
    creation_date timestamp without time zone NOT NULL,
    CONSTRAINT pk_labels PRIMARY KEY (id),
    CONSTRAINT fk_labels_taskiller_taskiller_id FOREIGN KEY (user_id) REFERENCES taskill.taskillers (id) ON DELETE CASCADE
);

CREATE TABLE taskill.projects (
    id bigint GENERATED BY DEFAULT AS IDENTITY,
    user_id bigint NOT NULL,
    name text NOT NULL,
    layout text NOT NULL,
    creation_date timestamp without time zone NOT NULL,
    CONSTRAINT pk_projects PRIMARY KEY (id),
    CONSTRAINT fk_projects_taskiller_taskiller_id FOREIGN KEY (user_id) REFERENCES taskill.taskillers (id) ON DELETE CASCADE
);

CREATE TABLE taskill.sections (
    id bigint GENERATED BY DEFAULT AS IDENTITY,
    project_id bigint NOT NULL,
    name text NOT NULL,
    CONSTRAINT pk_sections PRIMARY KEY (id),
    CONSTRAINT fk_sections_projects_project_id FOREIGN KEY (project_id) REFERENCES taskill.projects (id) ON DELETE CASCADE
);

CREATE TABLE taskill.tasks (
    id bigint GENERATED BY DEFAULT AS IDENTITY,
    user_id bigint NOT NULL,
    project_id bigint NOT NULL,
    section_id bigint NULL,
    title text NOT NULL,
    description text NULL,
    priority smallint NOT NULL,
    creation_date timestamp without time zone NOT NULL,
    completion_date timestamp without time zone NULL,
    due_date timestamp without time zone NULL,
    index integer NOT NULL,
    CONSTRAINT pk_tasks PRIMARY KEY (id),
    CONSTRAINT fk_tasks_projects_project_id FOREIGN KEY (project_id) REFERENCES taskill.projects (id) ON DELETE CASCADE,
    CONSTRAINT fk_tasks_sections_section_id FOREIGN KEY (section_id) REFERENCES taskill.sections (id),
    CONSTRAINT fk_tasks_taskiller_taskiller_id FOREIGN KEY (user_id) REFERENCES taskill.taskillers (id) ON DELETE CASCADE
);

CREATE TABLE taskill.subtasks (
    id bigint GENERATED BY DEFAULT AS IDENTITY,
    task_id bigint NOT NULL,
    title text NOT NULL,
    creation_date timestamp without time zone NOT NULL,
    completion_date timestamp without time zone NULL,
    index integer NOT NULL,
    CONSTRAINT pk_subtasks PRIMARY KEY (id),
    CONSTRAINT fk_subtasks_tasks_task_id FOREIGN KEY (task_id) REFERENCES taskill.tasks (id) ON DELETE CASCADE
);

CREATE TABLE taskill.tasks_labels (
    label_id bigint NOT NULL,
    task_id bigint NOT NULL,
    CONSTRAINT pk_tasks_labels PRIMARY KEY (label_id, task_id),
    CONSTRAINT fk_tasks_labels_labels_label_id FOREIGN KEY (label_id) REFERENCES taskill.labels (id) ON DELETE CASCADE,
    CONSTRAINT fk_tasks_labels_tasks_task_id FOREIGN KEY (task_id) REFERENCES taskill.tasks (id) ON DELETE CASCADE
);

CREATE INDEX ix_asp_net_role_claims_role_id ON taskill.asp_net_role_claims (role_id);

CREATE UNIQUE INDEX ix_asp_net_roles_normalized_name ON taskill.asp_net_roles (normalized_name);

CREATE INDEX ix_asp_net_user_logins_user_id ON taskill.asp_net_user_logins (user_id);

CREATE INDEX ix_asp_net_user_roles_role_id ON taskill.asp_net_user_roles (role_id);

CREATE INDEX ix_claims_user_id ON taskill.claims (user_id);

CREATE INDEX ix_labels_user_id ON taskill.labels (user_id);

CREATE INDEX ix_projects_user_id ON taskill.projects (user_id);

CREATE INDEX ix_sections_project_id ON taskill.sections (project_id);

CREATE INDEX ix_subtasks_task_id ON taskill.subtasks (task_id);

CREATE INDEX ix_taskillers_normalized_email ON taskill.taskillers (normalized_email);

CREATE UNIQUE INDEX ix_taskillers_normalized_user_name ON taskill.taskillers (normalized_user_name);

CREATE INDEX ix_tasks_project_id ON taskill.tasks (project_id);

CREATE INDEX ix_tasks_section_id ON taskill.tasks (section_id);

CREATE INDEX ix_tasks_title_description ON taskill.tasks USING GIN (to_tsvector('portuguese', title || ' ' || coalesce(description, '')));

CREATE INDEX ix_tasks_user_id ON taskill.tasks (user_id);

CREATE INDEX ix_tasks_labels_task_id ON taskill.tasks_labels (task_id);
