# Summary

- [Introduction](README.md)
- [Getting Started](src/basics.md)

### Setup Server
- [Setup Suave](src/suave.md)
- [Setup Asp.NET Core](src/aspnet-core.md)
- [Setup Giraffe](src/giraffe.md)
- [Setup Saturn](src/saturn.md)

### Setup Client
- [Setup Fable Client](src/client.md)

### Dotnet Client
- [Getting Started from .NET](src/dotnet-client.md)
- [C# Support](src/dotnet-csharp.md)
- [Asp.NET Core Integration Testing](src/dotnet-integration-tests.md)
- [Limitations and Workaround](src/dotnet-client-limitations.md)

### Advanced
- [Custom Route Paths](src/route-builder.md)
- [Error Handling](src/error-handling.md)
- [Modeling Authentication](src/modeling-authentication.md)
- [Implicit Authentication](src/implicit-authentication.md)
- [Refreshing Access Tokens](src/refresh-auth-tokens.md)
- [Accessing Request Context](src/request-context.md)
- [Binary Serialization](src/binary-serialization.md)
- [Functional Dependency Injection](src/dependency-injection.md)
- [Raw Http Communication](src/raw-http.md)
- [File Upload And Download](src/upload-and-download.md)
- [Using Multiple Protocols](src/multiple-protocols.md)
- [Type-Safe Documentation](src/docs.md)
- [Logging](src/logging.md)



### Misc
- [Changelog](src/change-log.md)
- [Migration 2.x to 3.x](src/migrate.md)
- [Troubleshooting](src/troubleshoot.md)
- [Credits](src/credits.md)
