"""added class construct and additonal problem tracability

Revision ID: 36d5d081b3cc
Revises: 2c3d3b296ce5
Create Date: 2019-04-29 23:36:53.314303

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '36d5d081b3cc'
down_revision = '2c3d3b296ce5'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('class',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(), nullable=True),
    sa.Column('description', sa.String(), nullable=True),
    sa.Column('professor_id', sa.Integer(), nullable=True),
    sa.Column('join_code', sa.String(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('class_problem',
    sa.Column('problem_id', sa.Integer(), nullable=True),
    sa.Column('class_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['class_id'], ['class.id'], ),
    sa.ForeignKeyConstraint(['problem_id'], ['problem.id'], )
    )
    op.create_table('class_users',
    sa.Column('user_id', sa.Integer(), nullable=True),
    sa.Column('class_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['class_id'], ['class.id'], ),
    sa.ForeignKeyConstraint(['user_id'], ['user.id'], )
    )
    op.create_table('problem_users',
    sa.Column('user_id', sa.Integer(), nullable=True),
    sa.Column('problem_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['problem_id'], ['problem.id'], ),
    sa.ForeignKeyConstraint(['user_id'], ['user.id'], )
    )
    op.create_table('problembasefile',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('file_name', sa.String(), nullable=True),
    sa.Column('content', sa.String(), nullable=True),
    sa.Column('problem_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['problem_id'], ['problem.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('submission_file',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('file_name', sa.String(), nullable=True),
    sa.Column('content', sa.String(), nullable=True),
    sa.Column('submission_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['submission_id'], ['submission.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.add_column('submission', sa.Column('final_submission', sa.Boolean(), nullable=True))
    op.add_column('submission', sa.Column('grade', sa.Integer(), nullable=True))
    op.add_column('submission', sa.Column('start_time', sa.DateTime(), nullable=False))
    op.add_column('submission', sa.Column('submission_time', sa.DateTime(), nullable=True))
    op.add_column('user', sa.Column('last_problem_id', sa.Integer(), nullable=True))
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('user', 'last_problem_id')
    op.drop_column('submission', 'submission_time')
    op.drop_column('submission', 'start_time')
    op.drop_column('submission', 'grade')
    op.drop_column('submission', 'final_submission')
    op.drop_table('submission_file')
    op.drop_table('problembasefile')
    op.drop_table('problem_users')
    op.drop_table('class_users')
    op.drop_table('class_problem')
    op.drop_table('class')
    # ### end Alembic commands ###
