/*
 * Copyright (C) 2011 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef _ART_RUNTIME_STRING_INL_H_
#define _ART_RUNTIME_STRING_INL_H_


#include "mirror/string.h"


namespace art {

inline int32_t String::GetLength(const String* real)
{
    return real->count_;
}

inline const Array* String::GetCharArray(const String* real)
{
    return reinterpret_cast<const Array*>(real->hearef_char_array_);
}

}

#endif