**Elementary**

The radio tile allows using a fancy box that is similar to the `MetroInfoTile` instead of a plain radio input box.

```jsx
const { MetroRadioTile } = require('precise-ui');

<MetroRadioTile title="Agree?" />
```

All the props from the `RadioButton` are in there. Likewise, once a single `RadioButton` is checked it cannot be unchecked (in managed mode).

Like the `MetroInfoTile` it can have an illustrative image, which is by default sized to 50 x 50 pixels.

```jsx
const { MetroRadioTile } = require('precise-ui');
const image = 'data:image/png;base64,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';

<MetroRadioTile title="Node.js" image={image} />
```
