// AUTO GENERATED by /tools/convert-icons.js
// add new icons to /tools/icongen.config.js

import * as React from 'react';

export interface SvgIconProps {
  width?: string | null;
  height?: string | null;
  viewBox?: string;
  version?: string;
  style?: React.CSSProperties;
}

export interface SvgIconConstructor {
  (props: SvgIconProps): React.ReactSVGElement;
  displayName: string;
  defaultProps: {
    version?: string;
    width: string;
    height: string;
    viewBox: string;
  };
}

export const AccountBalance = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d: 'M4 10v7h3v-7H4zm6 0v7h3v-7h-3zM2 22h19v-3H2v3zm14-12v7h3v-7h-3zm-4.5-9L2 6v2h19V6l-9.5-5z',
    }),
  );
};

AccountBalance.displayName = 'AccountBalance';
AccountBalance.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const AccountCircle = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 3c1.66 0 3 1.34 3 3s-1.34 3-3 3-3-1.34-3-3 1.34-3 3-3zm0 14.2c-2.5 0-4.71-1.28-6-3.22.03-1.99 4-3.08 6-3.08 1.99 0 5.97 1.09 6 3.08-1.29 1.94-3.5 3.22-6 3.22z',
    }),
  );
};

AccountCircle.displayName = 'AccountCircle';
AccountCircle.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Announcement = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d: 'M20 2H4c-1.1 0-1.99.9-1.99 2L2 22l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-7 9h-2V5h2v6zm0 4h-2v-2h2v2z',
    }),
  );
};

Announcement.displayName = 'Announcement';
Announcement.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Bookmark = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', { d: 'M17 3H7c-1.1 0-1.99.9-1.99 2L5 21l7-3 7 3V5c0-1.1-.9-2-2-2z' }),
  );
};

Bookmark.displayName = 'Bookmark';
Bookmark.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Book = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d: 'M18 2H6c-1.1 0-2 .9-2 2v16c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zM6 4h5v8l-2.5-1.5L6 12V4z',
    }),
  );
};

Book.displayName = 'Book';
Book.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Build = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M22.7 19l-9.1-9.1c.9-2.3.4-5-1.5-6.9-2-2-5-2.4-7.4-1.3L9 6 6 9 1.6 4.7C.4 7.1.9 10.1 2.9 12.1c1.9 1.9 4.6 2.4 6.9 1.5l9.1 9.1c.4.4 1 .4 1.4 0l2.3-2.3c.5-.4.5-1.1.1-1.4z',
    }),
  );
};

Build.displayName = 'Build';
Build.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Cached = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M19 8l-4 4h3c0 3.31-2.69 6-6 6-1.01 0-1.97-.25-2.8-.7l-1.46 1.46C8.97 19.54 10.43 20 12 20c4.42 0 8-3.58 8-8h3l-4-4zM6 12c0-3.31 2.69-6 6-6 1.01 0 1.97.25 2.8.7l1.46-1.46C15.03 4.46 13.57 4 12 4c-4.42 0-8 3.58-8 8H1l4 4 4-4H6z',
    }),
  );
};

Cached.displayName = 'Cached';
Cached.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const CheckCircle = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z',
    }),
  );
};

CheckCircle.displayName = 'CheckCircle';
CheckCircle.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Dashboard = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', { d: 'M3 13h8V3H3v10zm0 8h8v-6H3v6zm10 0h8V11h-8v10zm0-18v6h8V3h-8z' }),
  );
};

Dashboard.displayName = 'Dashboard';
Dashboard.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const DateRange = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M9 11H7v2h2v-2zm4 0h-2v2h2v-2zm4 0h-2v2h2v-2zm2-7h-1V2h-2v2H8V2H6v2H5c-1.11 0-1.99.9-1.99 2L3 20c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 16H5V9h14v11z',
    }),
  );
};

DateRange.displayName = 'DateRange';
DateRange.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Delete = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', { d: 'M6 19c0 1.1.9 2 2 2h8c1.1 0 2-.9 2-2V7H6v12zM19 4h-3.5l-1-1h-5l-1 1H5v2h14V4z' }),
  );
};

Delete.displayName = 'Delete';
Delete.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Description = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M14 2H6c-1.1 0-1.99.9-1.99 2L4 20c0 1.1.89 2 1.99 2H18c1.1 0 2-.9 2-2V8l-6-6zm2 16H8v-2h8v2zm0-4H8v-2h8v2zm-3-5V3.5L18.5 9H13z',
    }),
  );
};

Description.displayName = 'Description';
Description.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Done = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', { d: 'M9 16.2L4.8 12l-1.4 1.4L9 19 21 7l-1.4-1.4L9 16.2z' }),
  );
};

Done.displayName = 'Done';
Done.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Event = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M17 12h-5v5h5v-5zM16 1v2H8V1H6v2H5c-1.11 0-1.99.9-1.99 2L3 19c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2h-1V1h-2zm3 18H5V8h14v11z',
    }),
  );
};

Event.displayName = 'Event';
Event.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const ExitToApp = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M10.09 15.59L11.5 17l5-5-5-5-1.41 1.41L12.67 11H3v2h9.67l-2.58 2.59zM19 3H5c-1.11 0-2 .9-2 2v4h2V5h14v14H5v-4H3v4c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2z',
    }),
  );
};

ExitToApp.displayName = 'ExitToApp';
ExitToApp.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Favorite = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M12 21.35l-1.45-1.32C5.4 15.36 2 12.28 2 8.5 2 5.42 4.42 3 7.5 3c1.74 0 3.41.81 4.5 2.09C13.09 3.81 14.76 3 16.5 3 19.58 3 22 5.42 22 8.5c0 3.78-3.4 6.86-8.55 11.54L12 21.35z',
    }),
  );
};

Favorite.displayName = 'Favorite';
Favorite.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const FavoriteBorder = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M16.5 3c-1.74 0-3.41.81-4.5 2.09C10.91 3.81 9.24 3 7.5 3 4.42 3 2 5.42 2 8.5c0 3.78 3.4 6.86 8.55 11.54L12 21.35l1.45-1.32C18.6 15.36 22 12.28 22 8.5 22 5.42 19.58 3 16.5 3zm-4.4 15.55l-.1.1-.1-.1C7.14 14.24 4 11.39 4 8.5 4 6.5 5.5 5 7.5 5c1.54 0 3.04.99 3.57 2.36h1.87C13.46 5.99 14.96 5 16.5 5c2 0 3.5 1.5 3.5 3.5 0 2.89-3.14 5.74-7.9 10.05z',
    }),
  );
};

FavoriteBorder.displayName = 'FavoriteBorder';
FavoriteBorder.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Feedback = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d: 'M20 2H4c-1.1 0-1.99.9-1.99 2L2 22l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-7 12h-2v-2h2v2zm0-4h-2V6h2v4z',
    }),
  );
};

Feedback.displayName = 'Feedback';
Feedback.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const HelpOutline = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M11 18h2v-2h-2v2zm1-16C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm0-14c-2.21 0-4 1.79-4 4h2c0-1.1.9-2 2-2s2 .9 2 2c0 2-3 1.75-3 5h2c0-2.25 3-2.5 3-5 0-2.21-1.79-4-4-4z',
    }),
  );
};

HelpOutline.displayName = 'HelpOutline';
HelpOutline.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Home = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement('svg', props, React.createElement('path', { d: 'M10 20v-6h4v6h5v-8h3L12 3 2 12h3v8z' }));
};

Home.displayName = 'Home';
Home.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const ImportantDevices = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M23 11.01L18 11c-.55 0-1 .45-1 1v9c0 .55.45 1 1 1h5c.55 0 1-.45 1-1v-9c0-.55-.45-.99-1-.99zM23 20h-5v-7h5v7zM20 2H2C.89 2 0 2.89 0 4v12c0 1.1.89 2 2 2h7v2H7v2h8v-2h-2v-2h2v-2H2V4h18v5h2V4c0-1.11-.9-2-2-2zm-8.03 7L11 6l-.97 3H7l2.47 1.76-.94 2.91 2.47-1.8 2.47 1.8-.94-2.91L15 9h-3.03z',
    }),
  );
};

ImportantDevices.displayName = 'ImportantDevices';
ImportantDevices.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Info = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d: 'M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-6h2v6zm0-8h-2V7h2v2z',
    }),
  );
};

Info.displayName = 'Info';
Info.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const InfoOutline = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M11 17h2v-6h-2v6zm1-15C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zM11 9h2V7h-2v2z',
    }),
  );
};

InfoOutline.displayName = 'InfoOutline';
InfoOutline.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Label = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M17.63 5.84C17.27 5.33 16.67 5 16 5L5 5.01C3.9 5.01 3 5.9 3 7v10c0 1.1.9 1.99 2 1.99L16 19c.67 0 1.27-.33 1.63-.84L22 12l-4.37-6.16z',
    }),
  );
};

Label.displayName = 'Label';
Label.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const LabelOutline = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M17.63 5.84C17.27 5.33 16.67 5 16 5L5 5.01C3.9 5.01 3 5.9 3 7v10c0 1.1.9 1.99 2 1.99L16 19c.67 0 1.27-.33 1.63-.84L22 12l-4.37-6.16zM16 17H5V7h11l3.55 5L16 17z',
    }),
  );
};

LabelOutline.displayName = 'LabelOutline';
LabelOutline.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Language = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zm6.93 6h-2.95c-.32-1.25-.78-2.45-1.38-3.56 1.84.63 3.37 1.91 4.33 3.56zM12 4.04c.83 1.2 1.48 2.53 1.91 3.96h-3.82c.43-1.43 1.08-2.76 1.91-3.96zM4.26 14C4.1 13.36 4 12.69 4 12s.1-1.36.26-2h3.38c-.08.66-.14 1.32-.14 2 0 .68.06 1.34.14 2H4.26zm.82 2h2.95c.32 1.25.78 2.45 1.38 3.56-1.84-.63-3.37-1.9-4.33-3.56zm2.95-8H5.08c.96-1.66 2.49-2.93 4.33-3.56C8.81 5.55 8.35 6.75 8.03 8zM12 19.96c-.83-1.2-1.48-2.53-1.91-3.96h3.82c-.43 1.43-1.08 2.76-1.91 3.96zM14.34 14H9.66c-.09-.66-.16-1.32-.16-2 0-.68.07-1.35.16-2h4.68c.09.65.16 1.32.16 2 0 .68-.07 1.34-.16 2zm.25 5.56c.6-1.11 1.06-2.31 1.38-3.56h2.95c-.96 1.65-2.49 2.93-4.33 3.56zM16.36 14c.08-.66.14-1.32.14-2 0-.68-.06-1.34-.14-2h3.38c.16.64.26 1.31.26 2s-.1 1.36-.26 2h-3.38z',
    }),
  );
};

Language.displayName = 'Language';
Language.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Pageview = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M11.5 9C10.12 9 9 10.12 9 11.5s1.12 2.5 2.5 2.5 2.5-1.12 2.5-2.5S12.88 9 11.5 9zM20 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm-3.21 14.21l-2.91-2.91c-.69.44-1.51.7-2.39.7C9.01 16 7 13.99 7 11.5S9.01 7 11.5 7 16 9.01 16 11.5c0 .88-.26 1.69-.7 2.39l2.91 2.9-1.42 1.42z',
    }),
  );
};

Pageview.displayName = 'Pageview';
Pageview.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const PowerSettingsNew = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M13 3h-2v10h2V3zm4.83 2.17l-1.42 1.42C17.99 7.86 19 9.81 19 12c0 3.87-3.13 7-7 7s-7-3.13-7-7c0-2.19 1.01-4.14 2.58-5.42L6.17 5.17C4.23 6.82 3 9.26 3 12c0 4.97 4.03 9 9 9s9-4.03 9-9c0-2.74-1.23-5.18-3.17-6.83z',
    }),
  );
};

PowerSettingsNew.displayName = 'PowerSettingsNew';
PowerSettingsNew.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Print = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M19 8H5c-1.66 0-3 1.34-3 3v6h4v4h12v-4h4v-6c0-1.66-1.34-3-3-3zm-3 11H8v-5h8v5zm3-7c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm-1-9H6v4h12V3z',
    }),
  );
};

Print.displayName = 'Print';
Print.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const QuestionAnswer = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M21 6h-2v9H6v2c0 .55.45 1 1 1h11l4 4V7c0-.55-.45-1-1-1zm-4 6V3c0-.55-.45-1-1-1H3c-.55 0-1 .45-1 1v14l4-4h10c.55 0 1-.45 1-1z',
    }),
  );
};

QuestionAnswer.displayName = 'QuestionAnswer';
QuestionAnswer.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Restore = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M13 3c-4.97 0-9 4.03-9 9H1l3.89 3.89.07.14L9 12H6c0-3.87 3.13-7 7-7s7 3.13 7 7-3.13 7-7 7c-1.93 0-3.68-.79-4.94-2.06l-1.42 1.42C8.27 19.99 10.51 21 13 21c4.97 0 9-4.03 9-9s-4.03-9-9-9zm-1 5v5l4.28 2.54.72-1.21-3.5-2.08V8H12z',
    }),
  );
};

Restore.displayName = 'Restore';
Restore.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Search = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5 14 7.01 14 9.5 11.99 14 9.5 14z',
    }),
  );
};

Search.displayName = 'Search';
Search.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Settings = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M19.43 12.98c.04-.32.07-.64.07-.98s-.03-.66-.07-.98l2.11-1.65c.19-.15.24-.42.12-.64l-2-3.46c-.12-.22-.39-.3-.61-.22l-2.49 1c-.52-.4-1.08-.73-1.69-.98l-.38-2.65C14.46 2.18 14.25 2 14 2h-4c-.25 0-.46.18-.49.42l-.38 2.65c-.61.25-1.17.59-1.69.98l-2.49-1c-.23-.09-.49 0-.61.22l-2 3.46c-.13.22-.07.49.12.64l2.11 1.65c-.04.32-.07.65-.07.98s.03.66.07.98l-2.11 1.65c-.19.15-.24.42-.12.64l2 3.46c.12.22.39.3.61.22l2.49-1c.52.4 1.08.73 1.69.98l.38 2.65c.03.24.24.42.49.42h4c.25 0 .46-.18.49-.42l.38-2.65c.61-.25 1.17-.59 1.69-.98l2.49 1c.23.09.49 0 .61-.22l2-3.46c.12-.22.07-.49-.12-.64l-2.11-1.65zM12 15.5c-1.93 0-3.5-1.57-3.5-3.5s1.57-3.5 3.5-3.5 3.5 1.57 3.5 3.5-1.57 3.5-3.5 3.5z',
    }),
  );
};

Settings.displayName = 'Settings';
Settings.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const SwapVert = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', { d: 'M16 17.01V10h-2v7.01h-3L15 21l4-3.99h-3zM9 3L5 6.99h3V14h2V6.99h3L9 3z' }),
  );
};

SwapVert.displayName = 'SwapVert';
SwapVert.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const ThumbDown = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M15 3H6c-.83 0-1.54.5-1.84 1.22l-3.02 7.05c-.09.23-.14.47-.14.73v1.91l.01.01L1 14c0 1.1.9 2 2 2h6.31l-.95 4.57-.03.32c0 .41.17.79.44 1.06L9.83 23l6.59-6.59c.36-.36.58-.86.58-1.41V5c0-1.1-.9-2-2-2zm4 0v12h4V3h-4z',
    }),
  );
};

ThumbDown.displayName = 'ThumbDown';
ThumbDown.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const ThumbUp = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M1 21h4V9H1v12zm22-11c0-1.1-.9-2-2-2h-6.31l.95-4.57.03-.32c0-.41-.17-.79-.44-1.06L14.17 1 7.59 7.59C7.22 7.95 7 8.45 7 9v10c0 1.1.9 2 2 2h9c.83 0 1.54-.5 1.84-1.22l3.02-7.05c.09-.23.14-.47.14-.73v-1.91l-.01-.01L23 10z',
    }),
  );
};

ThumbUp.displayName = 'ThumbUp';
ThumbUp.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Update = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M21 10.12h-6.78l2.74-2.82c-2.73-2.7-7.15-2.8-9.88-.1-2.73 2.71-2.73 7.08 0 9.79 2.73 2.71 7.15 2.71 9.88 0C18.32 15.65 19 14.08 19 12.1h2c0 1.98-.88 4.55-2.64 6.29-3.51 3.48-9.21 3.48-12.72 0-3.5-3.47-3.53-9.11-.02-12.58 3.51-3.47 9.14-3.47 12.65 0L21 3v7.12zM12.5 8v4.25l3.5 2.08-.72 1.21L11 13V8h1.5z',
    }),
  );
};

Update.displayName = 'Update';
Update.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const VerifiedUser = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M12 1L3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4zm-2 16l-4-4 1.41-1.41L10 14.17l6.59-6.59L18 9l-8 8z',
    }),
  );
};

VerifiedUser.displayName = 'VerifiedUser';
VerifiedUser.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const ViewCarousel = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', { d: 'M7 19h10V4H7v15zm-5-2h4V6H2v11zM18 6v11h4V6h-4z' }),
  );
};

ViewCarousel.displayName = 'ViewCarousel';
ViewCarousel.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const ViewColumn = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', { d: 'M10 18h5V5h-5v13zm-6 0h5V5H4v13zM16 5v13h5V5h-5z' }),
  );
};

ViewColumn.displayName = 'ViewColumn';
ViewColumn.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Visibility = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M12 4.5C7 4.5 2.73 7.61 1 12c1.73 4.39 6 7.5 11 7.5s9.27-3.11 11-7.5c-1.73-4.39-6-7.5-11-7.5zM12 17c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5zm0-8c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z',
    }),
  );
};

Visibility.displayName = 'Visibility';
Visibility.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const VisibilityOff = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M12 7c2.76 0 5 2.24 5 5 0 .65-.13 1.26-.36 1.83l2.92 2.92c1.51-1.26 2.7-2.89 3.43-4.75-1.73-4.39-6-7.5-11-7.5-1.4 0-2.74.25-3.98.7l2.16 2.16C10.74 7.13 11.35 7 12 7zM2 4.27l2.28 2.28.46.46C3.08 8.3 1.78 10.02 1 12c1.73 4.39 6 7.5 11 7.5 1.55 0 3.03-.3 4.38-.84l.42.42L19.73 22 21 20.73 3.27 3 2 4.27zM7.53 9.8l1.55 1.55c-.05.21-.08.43-.08.65 0 1.66 1.34 3 3 3 .22 0 .44-.03.65-.08l1.55 1.55c-.67.33-1.41.53-2.2.53-2.76 0-5-2.24-5-5 0-.79.2-1.53.53-2.2zm4.31-.78l3.15 3.15.02-.16c0-1.66-1.34-3-3-3l-.17.01z',
    }),
  );
};

VisibilityOff.displayName = 'VisibilityOff';
VisibilityOff.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Error = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d: 'M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-2h2v2zm0-4h-2V7h2v6z',
    }),
  );
};

Error.displayName = 'Error';
Error.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Warning = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', { d: 'M1 21h22L12 2 1 21zm12-3h-2v-2h2v2zm0-4h-2v-4h2v4z' }),
  );
};

Warning.displayName = 'Warning';
Warning.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const PlayArrow = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement('svg', props, React.createElement('path', { d: 'M8 5v14l11-7z' }));
};

PlayArrow.displayName = 'PlayArrow';
PlayArrow.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Replay = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d: 'M12 5V1L7 6l5 5V7c3.31 0 6 2.69 6 6s-2.69 6-6 6-6-2.69-6-6H4c0 4.42 3.58 8 8 8s8-3.58 8-8-3.58-8-8-8z',
    }),
  );
};

Replay.displayName = 'Replay';
Replay.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const VideoLibrary = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M4 6H2v14c0 1.1.9 2 2 2h14v-2H4V6zm16-4H8c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-8 12.5v-9l6 4.5-6 4.5z',
    }),
  );
};

VideoLibrary.displayName = 'VideoLibrary';
VideoLibrary.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Email = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M20 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 4l-8 5-8-5V6l8 5 8-5v2z',
    }),
  );
};

Email.displayName = 'Email';
Email.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const MailOutline = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M20 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 14H4V8l8 5 8-5v10zm-8-7L4 6h16l-8 5z',
    }),
  );
};

MailOutline.displayName = 'MailOutline';
MailOutline.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Phone = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M6.62 10.79c1.44 2.83 3.76 5.14 6.59 6.59l2.2-2.2c.27-.27.67-.36 1.02-.24 1.12.37 2.33.57 3.57.57.55 0 1 .45 1 1V20c0 .55-.45 1-1 1-9.39 0-17-7.61-17-17 0-.55.45-1 1-1h3.5c.55 0 1 .45 1 1 0 1.25.2 2.45.57 3.57.11.35.03.74-.25 1.02l-2.2 2.2z',
    }),
  );
};

Phone.displayName = 'Phone';
Phone.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Add = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement('svg', props, React.createElement('path', { d: 'M19 13h-6v6h-2v-6H5v-2h6V5h2v6h6v2z' }));
};

Add.displayName = 'Add';
Add.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const AddCircle = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d: 'M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm5 11h-4v4h-2v-4H7v-2h4V7h2v4h4v2z',
    }),
  );
};

AddCircle.displayName = 'AddCircle';
AddCircle.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const AddCircleOutline = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M13 7h-2v4H7v2h4v4h2v-4h4v-2h-4V7zm-1-5C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z',
    }),
  );
};

AddCircleOutline.displayName = 'AddCircleOutline';
AddCircleOutline.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const ContentCopy = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M16 1H4c-1.1 0-2 .9-2 2v14h2V3h12V1zm3 4H8c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h11c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 16H8V7h11v14z',
    }),
  );
};

ContentCopy.displayName = 'ContentCopy';
ContentCopy.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Create = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM20.71 7.04c.39-.39.39-1.02 0-1.41l-2.34-2.34c-.39-.39-1.02-.39-1.41 0l-1.83 1.83 3.75 3.75 1.83-1.83z',
    }),
  );
};

Create.displayName = 'Create';
Create.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const FilterList = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', { d: 'M10 18h4v-2h-4v2zM3 6v2h18V6H3zm3 7h12v-2H6v2z' }),
  );
};

FilterList.displayName = 'FilterList';
FilterList.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Remove = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement('svg', props, React.createElement('path', { d: 'M19 13H5v-2h14v2z' }));
};

Remove.displayName = 'Remove';
Remove.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const RemoveCircle = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d: 'M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm5 11H7v-2h10v2z',
    }),
  );
};

RemoveCircle.displayName = 'RemoveCircle';
RemoveCircle.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const RemoveCircleOutline = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M7 11v2h10v-2H7zm5-9C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z',
    }),
  );
};

RemoveCircleOutline.displayName = 'RemoveCircleOutline';
RemoveCircleOutline.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Send = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement('svg', props, React.createElement('path', { d: 'M2.01 21L23 12 2.01 3 2 10l15 2-15 2z' }));
};

Send.displayName = 'Send';
Send.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Sort = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', { d: 'M3 18h6v-2H3v2zM3 6v2h18V6H3zm0 7h12v-2H3v2z' }),
  );
};

Sort.displayName = 'Sort';
Sort.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Unarchive = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M20.55 5.22l-1.39-1.68C18.88 3.21 18.47 3 18 3H6c-.47 0-.88.21-1.15.55L3.46 5.22C3.17 5.57 3 6.01 3 6.5V19c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V6.5c0-.49-.17-.93-.45-1.28zM12 9.5l5.5 5.5H14v2h-4v-2H6.5L12 9.5zM5.12 5l.82-1h12l.93 1H5.12z',
    }),
  );
};

Unarchive.displayName = 'Unarchive';
Unarchive.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const LocationSearching = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M20.94 11c-.46-4.17-3.77-7.48-7.94-7.94V1h-2v2.06C6.83 3.52 3.52 6.83 3.06 11H1v2h2.06c.46 4.17 3.77 7.48 7.94 7.94V23h2v-2.06c4.17-.46 7.48-3.77 7.94-7.94H23v-2h-2.06zM12 19c-3.87 0-7-3.13-7-7s3.13-7 7-7 7 3.13 7 7-3.13 7-7 7z',
    }),
  );
};

LocationSearching.displayName = 'LocationSearching';
LocationSearching.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Widgets = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d: 'M13 13v8h8v-8h-8zM3 21h8v-8H3v8zM3 3v8h8V3H3zm13.66-1.31L11 7.34 16.66 13l5.66-5.66-5.66-5.65z',
    }),
  );
};

Widgets.displayName = 'Widgets';
Widgets.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const BorderClear = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M7 5h2V3H7v2zm0 8h2v-2H7v2zm0 8h2v-2H7v2zm4-4h2v-2h-2v2zm0 4h2v-2h-2v2zm-8 0h2v-2H3v2zm0-4h2v-2H3v2zm0-4h2v-2H3v2zm0-4h2V7H3v2zm0-4h2V3H3v2zm8 8h2v-2h-2v2zm8 4h2v-2h-2v2zm0-4h2v-2h-2v2zm0 8h2v-2h-2v2zm0-12h2V7h-2v2zm-8 0h2V7h-2v2zm8-6v2h2V3h-2zm-8 2h2V3h-2v2zm4 16h2v-2h-2v2zm0-8h2v-2h-2v2zm0-8h2V3h-2v2z',
    }),
  );
};

BorderClear.displayName = 'BorderClear';
BorderClear.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const CreateNewFolder = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M20 6h-8l-2-2H4c-1.11 0-1.99.89-1.99 2L2 18c0 1.11.89 2 2 2h16c1.11 0 2-.89 2-2V8c0-1.11-.89-2-2-2zm-1 8h-3v3h-2v-3h-3v-2h3V9h2v3h3v2z',
    }),
  );
};

CreateNewFolder.displayName = 'CreateNewFolder';
CreateNewFolder.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const FileDownload = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', { d: 'M19 9h-4V3H9v6H5l7 7 7-7zM5 18v2h14v-2H5z' }),
  );
};

FileDownload.displayName = 'FileDownload';
FileDownload.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const FileUpload = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement('svg', props, React.createElement('path', { d: 'M9 16h6v-6h4l-7-7-7 7h4zm-4 2h14v2H5z' }));
};

FileUpload.displayName = 'FileUpload';
FileUpload.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Folder = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d: 'M10 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2h-8l-2-2z',
    }),
  );
};

Folder.displayName = 'Folder';
Folder.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const FolderOpen = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d: 'M20 6h-8l-2-2H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2zm0 12H4V8h16v10z',
    }),
  );
};

FolderOpen.displayName = 'FolderOpen';
FolderOpen.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const FolderShared = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M20 6h-8l-2-2H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2zm-5 3c1.1 0 2 .9 2 2s-.9 2-2 2-2-.9-2-2 .9-2 2-2zm4 8h-8v-1c0-1.33 2.67-2 4-2s4 .67 4 2v1z',
    }),
  );
};

FolderShared.displayName = 'FolderShared';
FolderShared.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const KeyboardArrowDown = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', { d: 'M7.41 7.84L12 12.42l4.59-4.58L18 9.25l-6 6-6-6z' }),
  );
};

KeyboardArrowDown.displayName = 'KeyboardArrowDown';
KeyboardArrowDown.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const KeyboardArrowLeft = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', { d: 'M15.41 16.09l-4.58-4.59 4.58-4.59L14 5.5l-6 6 6 6z' }),
  );
};

KeyboardArrowLeft.displayName = 'KeyboardArrowLeft';
KeyboardArrowLeft.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const KeyboardArrowRight = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', { d: 'M8.59 16.34l4.58-4.59-4.58-4.59L10 5.75l6 6-6 6z' }),
  );
};

KeyboardArrowRight.displayName = 'KeyboardArrowRight';
KeyboardArrowRight.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const KeyboardArrowUp = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', { d: 'M7.41 15.41L12 10.83l4.59 4.58L18 14l-6-6-6 6z' }),
  );
};

KeyboardArrowUp.displayName = 'KeyboardArrowUp';
KeyboardArrowUp.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Adjust = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M12 2C6.49 2 2 6.49 2 12s4.49 10 10 10 10-4.49 10-10S17.51 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm3-8c0 1.66-1.34 3-3 3s-3-1.34-3-3 1.34-3 3-3 3 1.34 3 3z',
    }),
  );
};

Adjust.displayName = 'Adjust';
Adjust.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Edit = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM20.71 7.04c.39-.39.39-1.02 0-1.41l-2.34-2.34c-.39-.39-1.02-.39-1.41 0l-1.83 1.83 3.75 3.75 1.83-1.83z',
    }),
  );
};

Edit.displayName = 'Edit';
Edit.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Filter1 = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M3 5H1v16c0 1.1.9 2 2 2h16v-2H3V5zm11 10h2V5h-4v2h2v8zm7-14H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm0 16H7V3h14v14z',
    }),
  );
};

Filter1.displayName = 'Filter1';
Filter1.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const FilterNone = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M3 5H1v16c0 1.1.9 2 2 2h16v-2H3V5zm18-4H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm0 16H7V3h14v14z',
    }),
  );
};

FilterNone.displayName = 'FilterNone';
FilterNone.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const LocalOffer = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M21.41 11.58l-9-9C12.05 2.22 11.55 2 11 2H4c-1.1 0-2 .9-2 2v7c0 .55.22 1.05.59 1.42l9 9c.36.36.86.58 1.41.58.55 0 1.05-.22 1.41-.59l7-7c.37-.36.59-.86.59-1.41 0-.55-.23-1.06-.59-1.42zM5.5 7C4.67 7 4 6.33 4 5.5S4.67 4 5.5 4 7 4.67 7 5.5 6.33 7 5.5 7z',
    }),
  );
};

LocalOffer.displayName = 'LocalOffer';
LocalOffer.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const MyLocation = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M12 8c-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4-1.79-4-4-4zm8.94 3c-.46-4.17-3.77-7.48-7.94-7.94V1h-2v2.06C6.83 3.52 3.52 6.83 3.06 11H1v2h2.06c.46 4.17 3.77 7.48 7.94 7.94V23h2v-2.06c4.17-.46 7.48-3.77 7.94-7.94H23v-2h-2.06zM12 19c-3.87 0-7-3.13-7-7s3.13-7 7-7 7 3.13 7 7-3.13 7-7 7z',
    }),
  );
};

MyLocation.displayName = 'MyLocation';
MyLocation.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Place = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z',
    }),
  );
};

Place.displayName = 'Place';
Place.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Apps = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M4 8h4V4H4v4zm6 12h4v-4h-4v4zm-6 0h4v-4H4v4zm0-6h4v-4H4v4zm6 0h4v-4h-4v4zm6-10v4h4V4h-4zm-6 4h4V4h-4v4zm6 6h4v-4h-4v4zm0 6h4v-4h-4v4z',
    }),
  );
};

Apps.displayName = 'Apps';
Apps.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const ArrowDropDown = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement('svg', props, React.createElement('path', { d: 'M7 10l5 5 5-5z' }));
};

ArrowDropDown.displayName = 'ArrowDropDown';
ArrowDropDown.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const ArrowDropUp = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement('svg', props, React.createElement('path', { d: 'M7 14l5-5 5 5z' }));
};

ArrowDropUp.displayName = 'ArrowDropUp';
ArrowDropUp.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const ArrowForward = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', { d: 'M12 4l-1.41 1.41L16.17 11H4v2h12.17l-5.58 5.59L12 20l8-8z' }),
  );
};

ArrowForward.displayName = 'ArrowForward';
ArrowForward.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Cancel = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M12 2C6.47 2 2 6.47 2 12s4.47 10 10 10 10-4.47 10-10S17.53 2 12 2zm5 13.59L15.59 17 12 13.41 8.41 17 7 15.59 10.59 12 7 8.41 8.41 7 12 10.59 15.59 7 17 8.41 13.41 12 17 15.59z',
    }),
  );
};

Cancel.displayName = 'Cancel';
Cancel.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Check = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', { d: 'M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z' }),
  );
};

Check.displayName = 'Check';
Check.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Close = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d: 'M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z',
    }),
  );
};

Close.displayName = 'Close';
Close.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Fullscreen = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      transform: 'translate(11.919596, 11.919596) rotate(-45.000000) translate(-11.919596, -11.919596)',
      d:
        'M7.11159595,12.7195959 L7.11159595,15.1195959 L3.91959595,11.9195959 L7.11159595,8.71959595 L7.11159595,11.1195959 L16.7275959,11.1195959 L16.7275959,8.71959595 L19.9195959,11.9195959 L16.7275959,15.1195959 L16.7275959,12.7195959 L7.11159595,12.7195959 Z',
    }),
  );
};

Fullscreen.displayName = 'Fullscreen';
Fullscreen.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const FullscreenExit = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      transform: 'translate(12.220116, 12.220116) rotate(-45.000000) translate(-12.220116, -12.220116)',
      d:
        'M8.85261633,11.4701163 L3.59511633,11.4701163 L3.59511633,12.9701163 L8.85261633,12.9701163 L8.85261633,15.2201163 L11.8451163,12.2201163 L8.85261633,9.22011633 L8.85261633,11.4701163 L8.85261633,11.4701163 Z M15.5876163,15.2201163 L15.5876163,12.9701163 L20.8451163,12.9701163 L20.8451163,11.4701163 L15.5876163,11.4701163 L15.5876163,9.22011633 L12.5951163,12.2201163 L15.5876163,15.2201163 L15.5876163,15.2201163 Z',
    }),
  );
};

FullscreenExit.displayName = 'FullscreenExit';
FullscreenExit.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Menu = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', { d: 'M3 18h18v-2H3v2zm0-5h18v-2H3v2zm0-7v2h18V6H3z' }),
  );
};

Menu.displayName = 'Menu';
Menu.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const MoreHoriz = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M6 10c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm12 0c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm-6 0c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z',
    }),
  );
};

MoreHoriz.displayName = 'MoreHoriz';
MoreHoriz.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const MoreVert = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M12 8c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zm0 2c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm0 6c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z',
    }),
  );
};

MoreVert.displayName = 'MoreVert';
MoreVert.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const UnfoldLess = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M7.41 18.59L8.83 20 12 16.83 15.17 20l1.41-1.41L12 14l-4.59 4.59zm9.18-13.18L15.17 4 12 7.17 8.83 4 7.41 5.41 12 10l4.59-4.59z',
    }),
  );
};

UnfoldLess.displayName = 'UnfoldLess';
UnfoldLess.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const UnfoldMore = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M12 5.83L15.17 9l1.41-1.41L12 3 7.41 7.59 8.83 9 12 5.83zm0 12.34L8.83 15l-1.41 1.41L12 21l4.59-4.59L15.17 15 12 18.17z',
    }),
  );
};

UnfoldMore.displayName = 'UnfoldMore';
UnfoldMore.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const ConfirmationNumber = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M22 10V6c0-1.11-.9-2-2-2H4c-1.1 0-1.99.89-1.99 2v4c1.1 0 1.99.9 1.99 2s-.89 2-2 2v4c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2v-4c-1.1 0-2-.9-2-2s.9-2 2-2zm-9 7.5h-2v-2h2v2zm0-4.5h-2v-2h2v2zm0-4.5h-2v-2h2v2z',
    }),
  );
};

ConfirmationNumber.displayName = 'ConfirmationNumber';
ConfirmationNumber.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Sync = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M12 4V1L8 5l4 4V6c3.31 0 6 2.69 6 6 0 1.01-.25 1.97-.7 2.8l1.46 1.46C19.54 15.03 20 13.57 20 12c0-4.42-3.58-8-8-8zm0 14c-3.31 0-6-2.69-6-6 0-1.01.25-1.97.7-2.8L5.24 7.74C4.46 8.97 4 10.43 4 12c0 4.42 3.58 8 8 8v3l4-4-4-4v3z',
    }),
  );
};

Sync.displayName = 'Sync';
Sync.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const SyncDisabled = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M10 6.35V4.26c-.8.21-1.55.54-2.23.96l1.46 1.46c.25-.12.5-.24.77-.33zm-7.14-.94l2.36 2.36C4.45 8.99 4 10.44 4 12c0 2.21.91 4.2 2.36 5.64L4 20h6v-6l-2.24 2.24C6.68 15.15 6 13.66 6 12c0-1 .25-1.94.68-2.77l8.08 8.08c-.25.13-.5.25-.77.34v2.09c.8-.21 1.55-.54 2.23-.96l2.36 2.36 1.27-1.27L4.14 4.14 2.86 5.41zM20 4h-6v6l2.24-2.24C17.32 8.85 18 10.34 18 12c0 1-.25 1.94-.68 2.77l1.46 1.46C19.55 15.01 20 13.56 20 12c0-2.21-.91-4.2-2.36-5.64L20 4z',
    }),
  );
};

SyncDisabled.displayName = 'SyncDisabled';
SyncDisabled.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const SyncProblem = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M3 12c0 2.21.91 4.2 2.36 5.64L3 20h6v-6l-2.24 2.24C5.68 15.15 5 13.66 5 12c0-2.61 1.67-4.83 4-5.65V4.26C5.55 5.15 3 8.27 3 12zm8 5h2v-2h-2v2zM21 4h-6v6l2.24-2.24C18.32 8.85 19 10.34 19 12c0 2.61-1.67 4.83-4 5.65v2.09c3.45-.89 6-4.01 6-7.74 0-2.21-.91-4.2-2.36-5.64L21 4zm-10 9h2V7h-2v6z',
    }),
  );
};

SyncProblem.displayName = 'SyncProblem';
SyncProblem.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Notifications = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M12 22c1.1 0 2-.9 2-2h-4c0 1.1.89 2 2 2zm6-6v-5c0-3.07-1.64-5.64-4.5-6.32V4c0-.83-.67-1.5-1.5-1.5s-1.5.67-1.5 1.5v.68C7.63 5.36 6 7.92 6 11v5l-2 2v1h16v-1l-2-2z',
    }),
  );
};

Notifications.displayName = 'Notifications';
Notifications.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Person = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z',
    }),
  );
};

Person.displayName = 'Person';
Person.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Public = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-1 17.93c-3.95-.49-7-3.85-7-7.93 0-.62.08-1.21.21-1.79L9 15v1c0 1.1.9 2 2 2v1.93zm6.9-2.54c-.26-.81-1-1.39-1.9-1.39h-1v-3c0-.55-.45-1-1-1H8v-2h2c.55 0 1-.45 1-1V7h2c1.1 0 2-.9 2-2v-.41c2.93 1.19 5 4.06 5 7.41 0 2.08-.8 3.97-2.1 5.39z',
    }),
  );
};

Public.displayName = 'Public';
Public.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Share = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M18 16.08c-.76 0-1.44.3-1.96.77L8.91 12.7c.05-.23.09-.46.09-.7s-.04-.47-.09-.7l7.05-4.11c.54.5 1.25.81 2.04.81 1.66 0 3-1.34 3-3s-1.34-3-3-3-3 1.34-3 3c0 .24.04.47.09.7L8.04 9.81C7.5 9.31 6.79 9 6 9c-1.66 0-3 1.34-3 3s1.34 3 3 3c.79 0 1.5-.31 2.04-.81l7.12 4.16c-.05.21-.08.43-.08.65 0 1.61 1.31 2.92 2.92 2.92 1.61 0 2.92-1.31 2.92-2.92s-1.31-2.92-2.92-2.92z',
    }),
  );
};

Share.displayName = 'Share';
Share.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const CheckBox = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M19 3H5c-1.11 0-2 .9-2 2v14c0 1.1.89 2 2 2h14c1.11 0 2-.9 2-2V5c0-1.1-.89-2-2-2zm-9 14l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z',
    }),
  );
};

CheckBox.displayName = 'CheckBox';
CheckBox.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const CheckBoxOutlineBlank = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d: 'M19 5v14H5V5h14m0-2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2z',
    }),
  );
};

CheckBoxOutlineBlank.displayName = 'CheckBoxOutlineBlank';
CheckBoxOutlineBlank.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const IndeterminateCheckBox = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d: 'M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-2 10H7v-2h10v2z',
    }),
  );
};

IndeterminateCheckBox.displayName = 'IndeterminateCheckBox';
IndeterminateCheckBox.defaultProps = { viewBox: '0 0 24 24', width: '24', height: '24' };

export const RadioButtonChecked = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M12 7c-2.76 0-5 2.24-5 5s2.24 5 5 5 5-2.24 5-5-2.24-5-5-5zm0-5C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z',
    }),
  );
};

RadioButtonChecked.displayName = 'RadioButtonChecked';
RadioButtonChecked.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const RadioButtonUnchecked = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z',
    }),
  );
};

RadioButtonUnchecked.displayName = 'RadioButtonUnchecked';
RadioButtonUnchecked.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Star = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d: 'M12 17.27L18.18 21l-1.64-7.03L22 9.24l-7.19-.61L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21z',
    }),
  );
};

Star.displayName = 'Star';
Star.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const FitToWidth = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M14,4 L18.8,8.8 L18.8,18.4 C18.8,19.28 18.08,20 17.2,20 L17.2,20 L7.592,20 C6.712,20 6,19.28 6,18.4 L6,18.4 L6,5.6 C6,4.72 6.72,4 7.6,4 L7.6,4 L14,4 Z M8.68968421,10.6666667 L6.67368421,12.6666667 L8.68968421,14.6666667 L8.68968421,13.1666667 L11.5578947,13.1666667 L11.5578947,12.1666667 L8.68968421,12.1666667 L8.68968421,10.6666667 Z M16.2787368,10.6666667 L16.2787368,12.1666667 L13.4105263,12.1666667 L13.4105263,13.1666667 L16.2787368,13.1666667 L16.2787368,14.6666667 L18.2947368,12.6666667 L16.2787368,10.6666667 Z',
    }),
  );
};

FitToWidth.displayName = 'FitToWidth';
FitToWidth.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const FitToHeight = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M14,4 L18.8,8.8 L18.8,18.4 C18.8,19.28 18.08,20 17.2,20 L17.2,20 L7.592,20 C6.712,20 6,19.28 6,18.4 L6,18.4 L6,5.6 C6,4.72 6.72,4 7.6,4 L7.6,4 L14,4 Z M12.8,13.3333333 L11.8,13.3333333 L11.8,16.8383333 L10.3,16.8383333 L12.3,18.8333333 L14.3,16.8383333 L12.8,16.8383333 L12.8,13.3333333 Z M12.3,5.33333333 L10.3,7.32833333 L11.8,7.32833333 L11.8,10.8333333 L12.8,10.8333333 L12.8,7.32833333 L14.3,7.32833333 L12.3,5.33333333 Z',
    }),
  );
};

FitToHeight.displayName = 'FitToHeight';
FitToHeight.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const Page = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M14,4 L7.6,4 C6.72,4 6,4.72 6,5.6 L6,18.4 C6,19.28 6.712,20 7.592,20 L17.2,20 C18.08,20 18.8,19.28 18.8,18.4 L18.8,8.8 L14,4 Z',
    }),
  );
};

Page.displayName = 'Page';
Page.defaultProps = { width: '24', height: '24', viewBox: '0 0 24 24' };

export const PDFFile = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M23.333 3.333l10 10v20c0 1.834-1.5 3.334-3.333 3.334H9.983c-1.833 0-3.316-1.5-3.316-3.334l.016-26.666c0-1.834 1.484-3.334 3.317-3.334h13.333zM14.386 25.33h-2.17V32h1.57v-2.42h.59c.5 0 .5 0 .92-.135.42-.135.42-.135.73-.4s.31-.265.48-.665c.17-.4.17-.4.17-.93 0-.52 0-.52-.17-.92s-.17-.4-.475-.665c-.305-.265-.305-.265-.725-.4-.315-.101-.315-.101-.675-.127l-.245-.008zm5.446 0h-2.06V32h2.11c.74 0 .74 0 1.31-.265.57-.265.57-.265.96-.72.39-.455.39-.455.59-1.07.2-.615.2-.615.2-1.325 0-.75 0-.75-.195-1.355s-.195-.605-.58-1.035c-.385-.43-.385-.43-.97-.665-.488-.196-.488-.196-1.11-.228l-.255-.007zm8.136 0h-3.72V32h1.59v-2.77h2.03v-1.19h-2.03v-1.5h2.13v-1.21zm-8.266 1.21c.47 0 .47 0 .78.165.31.165.31.165.49.45.18.285.18.285.25.665.07.38.07.38.07.8 0 .42 0 .42-.075.81-.075.39-.075.39-.255.695-.18.305-.18.305-.48.485s-.3.18-.74.18h-.38v-4.25h.34zm-5.566-.05c.45 0 .45 0 .69.255.24.255.24.255.24.705 0 .42 0 .42-.215.69-.215.27-.215.27-.675.27h-.4v-1.92h.36zM21.666 15V5.833L30.834 15h-9.166z',
    }),
  );
};

PDFFile.displayName = 'PDFFile';
PDFFile.defaultProps = { width: '24', height: '24', viewBox: '0 0 40 40' };

export const PDFFileOutline = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M23.333 3.333H10c-1.833 0-3.317 1.5-3.317 3.334l-.016 26.666c0 1.834 1.483 3.334 3.316 3.334H30c1.833 0 3.333-1.5 3.333-3.334v-20l-10-10zM10 33.333V6.667h11.667V15H30v18.333H10zM13.786 32v-2.42h.59c.5 0 .5 0 .92-.135.42-.135.42-.135.73-.4s.31-.265.48-.665c.17-.4.17-.4.17-.93 0-.52 0-.52-.17-.92s-.17-.4-.475-.665c-.305-.265-.305-.265-.725-.4s-.42-.135-.92-.135h-2.17V32h1.57zm.39-3.59h-.4v-1.92h.36c.45 0 .45 0 .69.255.24.255.24.255.24.705 0 .42 0 .42-.215.69-.215.27-.215.27-.675.27zM19.882 32c.74 0 .74 0 1.31-.265.57-.265.57-.265.96-.72.39-.455.39-.455.59-1.07.2-.615.2-.615.2-1.325 0-.75 0-.75-.195-1.355s-.195-.605-.58-1.035c-.385-.43-.385-.43-.97-.665-.585-.235-.585-.235-1.365-.235h-2.06V32zm-.14-1.21h-.38v-4.25h.34c.47 0 .47 0 .78.165.31.165.31.165.49.45.18.285.18.285.25.665.07.38.07.38.07.8 0 .42 0 .42-.075.81-.075.39-.075.39-.255.695-.18.305-.18.305-.48.485s-.3.18-.74.18zM25.838 32v-2.77h2.03v-1.19h-2.03v-1.5h2.13v-1.21h-3.72V32h1.59z',
    }),
  );
};

PDFFileOutline.displayName = 'PDFFileOutline';
PDFFileOutline.defaultProps = { width: '24', height: '24', viewBox: '0 0 40 40' };

export const Video = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M19.1780822,34.1780822 C27.4623534,34.1780822 34.1780822,27.4623534 34.1780822,19.1780822 C34.1780822,10.8938109 27.4623534,4.17808219 19.1780822,4.17808219 C10.8938109,4.17808219 4.17808219,10.8938109 4.17808219,19.1780822 C4.17808219,27.4623534 10.8938109,34.1780822 19.1780822,34.1780822 Z M15.8447489,12.5114155 L25.8447489,19.061799 L15.8447489,25.8447489 L15.8447489,12.5114155 Z',
    }),
  );
};

Video.displayName = 'Video';
Video.defaultProps = { width: '24', height: '24', viewBox: '0 0 40 40' };

export const VideoOutline = <SvgIconConstructor>function(props: SvgIconProps) {
  return React.createElement(
    'svg',
    props,
    React.createElement('path', {
      d:
        'M19.1780822,4.17808219 C27.4623534,4.17808219 34.1780822,10.8938109 34.1780822,19.1780822 C34.1780822,27.4623534 27.4623534,34.1780822 19.1780822,34.1780822 C10.8938109,34.1780822 4.17808219,27.4623534 4.17808219,19.1780822 C4.17808219,10.8938109 10.8938109,4.17808219 19.1780822,4.17808219 Z M19.1780822,7.51141553 C12.7347601,7.51141553 7.51141553,12.7347601 7.51141553,19.1780822 C7.51141553,25.6214043 12.7347601,30.8447489 19.1780822,30.8447489 C25.6214043,30.8447489 30.8447489,25.6214043 30.8447489,19.1780822 C30.8447489,12.7347601 25.6214043,7.51141553 19.1780822,7.51141553 Z M15.8447489,12.5114155 L25.8447489,19.061799 L15.8447489,25.8447489 L15.8447489,12.5114155 Z',
    }),
  );
};

VideoOutline.displayName = 'VideoOutline';
VideoOutline.defaultProps = { width: '24', height: '24', viewBox: '0 0 40 40' };
