**Elementary**

A "public" icon.

```jsx
const { Icon } = require('precise-ui');

<Icon name="Public" />
```

**Appareance Options**

The person symbol colored in red.

```jsx
const { Icon } = require('precise-ui');

<Icon name="Person" color="red" />
```

The `Icon` actually scales with the font (if not being told otherwise). Additionally, by default it uses the color of the font.

```jsx
const { Icon, colors } = require('precise-ui');

<div style={{ background: 'black', padding: '1em', color: colors.white, fontSize: '2em' }}>
  Please <Icon name="Check" /> me
</div>
```

Different sizes of an eye icon.

```jsx
const { Icon, colors } = require('precise-ui');
const { indigo, orangeNeon, green, brightLemon, purpleRed, teal } = colors;

<table>
  <tbody>
    <tr>
      <td width={50}>3.0</td>
      <td width={50}>2.5</td>
      <td width={50}>2.0</td>
      <td width={50}>1.5</td>
      <td width={50}>1.0</td>
      <td width={50}>0.5</td>
    </tr>
    <tr>
      <td><Icon name="Visibility" color={orangeNeon} size={3} /></td>
      <td><Icon name="Visibility" color={green} size={2.5} /></td>
      <td><Icon name="Visibility" color={brightLemon} size={2} /></td>
      <td><Icon name="Visibility" color={purpleRed} size={1.5} /></td>
      <td><Icon name="Visibility" color={indigo} size={1} /></td>
      <td><Icon name="Visibility" color={teal} size={0.5} /></td>
    </tr>
  </tbody>
</table>
```

**Custom Icons**

Custom SVG Icons can be registered as well.

To be able to register icons and extend type definitions in Typescript, interface `AdditionalIconNames` with registered icon names should be provided in global scope for interface augmentation. Example shown below

```ts
declare global {
  interface AdditionalIconNames {
    Foo: string;
    Bar: string;
  }
}

registerIcons({
  Foo: /*some svg value*/,
  Bar: /*some svg value*/,
})
```

```jsx
const { Icon, registerIcons, colors } = require('precise-ui');
const { indigo, purpleRed, teal } = colors;

registerIcons({
  'Yammer': (
    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0,0,2048,2048">
      <g>
        <path
          d={`M 1887 888 q 33 8 54 34 q 21 26 21 61 q 0 35 -22 62 q -23 26 -57 31 q -57 0 -121 -2 q -64 -3 -128 -7 q -64 -5 -122 -11 q
          -59 -7 -104 -16 q -45 -9 -72 -20 q -27 -12 -27 -26 q 0 -13 37 -26 q 37 -13 94 -24 q 57 -12 126 -22 q 68 -11 131 -18 q 63 -8
          112 -12 q 48 -4 66 -4 m -163 549 q 17 14 26 34 q 9 20 9 41 q 0 21 -8 39 q -8 17 -21 30 q -14 13 -31 20 q -17 7 -36 7 q -10 0
          -18 -2 q -8 -2 -19 -8 q -15 -8 -54 -34 q -39 -26 -88 -61 q -50 -35 -104 -76 q -54 -41 -98 -78 q -45 -37 -74 -67 q -29 -30
          -29 -44 q 0 -8 9 -10 q 8 -3 19 -3 q 22 0 57 9 q 34 9 77 25 q 42 15 91 36 q 48 20 98 44 q 50 23 100 49 q 49 25 94 49 m 0 -901
          q -67 37 -144 75 q -77 38 -149 69 q -73 30 -132 50 q -60 19 -93 19 q -11 0 -19 -2 q -8 -3 -8 -10 q 0 -14 29 -44 q 29 -30 74
          -67 q 44 -38 98 -78 q 54 -41 104 -76 q 49 -36 88 -62 q 39 -26 54 -34 q 11 -6 20 -8 q 8 -2 18 -2 q 18 0 36 8 q 17 7 30 20 q
          13 12 21 30 q 8 17 8 38 q 0 21 -9 41 q -9 19 -26 33 m -1191 823 l -430 -1051 q -6 -16 -6 -33 q 0 -20 8 -38 q 7 -19 21 -33 q
          13 -15 33 -24 q 19 -9 42 -9 q 30 0 56 16 q 26 16 40 44 l 343 866 h 4 l 326 -860 q 11 -29 37 -46 q 25 -18 56 -18 q 22 0 40 9
          q 18 8 31 22 q 13 13 21 31 q 7 17 7 36 q 0 14 -5 31 l -462 1154 q -30 74 -62 136 q -32 62 -76 107 q -44 44 -105 69 q -62 24
          -151 24 q -28 0 -57 -2 q -30 -3 -54 -12 q -24 -10 -39 -28 q -16 -19 -16 -52 q 0 -21 8 -38 q 8 -17 21 -29 q 13 -12 30 -18 q
          17 -6 35 -6 q 1 0 9 1 q 7 0 17 1 q 10 0 19 1 q 9 0 14 0 q 48 0 84 -15 q 36 -15 65 -46 q 28 -31 51 -78 q 22 -48 45 -112`}
        />
      </g>
    </svg>
  ),
  'ThumbsUp': (
    <svg viewBox="0 0 1024 1024">
      <path
        d="M968.517 573.851c22.662-26.155 35.565-69.381 35.565-110.541 0-27.17-5.899-50.974-17.056-68.842-14.526-23.259-37.762-36.069-65.426-36.069h-134.053c72.966-132.683 91.408-232.587 54.766-297.302-25.534-45.096-72.366-61.098-104.714-61.098-12.811 0-23.65 9.469-25.368 22.165-9.147 67.554-60.811 148.131-141.742 221.074-77.518 69.869-172.765 125.768-270.642 159.208-12.317-26.010-38.811-44.046-69.448-44.046h-153.6c-42.347 0-76.8 34.453-76.8 76.8v460.8c0 42.347 34.453 76.8 76.8 76.8h153.6c32.437 0 60.222-20.226 71.459-48.718 100.421 12.57 138.195 32.754 174.794 52.314 45.802 24.482 89.062 47.605 230.547 47.605 36.854 0 71.587-9.624 97.8-27.101 25.61-17.074 41.968-41.006 47.4-68.755 20.414-8.283 38.544-27.426 52.454-55.893 13.53-27.688 22.272-63.077 22.272-90.166 0-5.069-0.296-9.726-0.89-14.014 12.944-9.528 24.56-24.243 34.152-43.592 13.837-27.912 22.099-62.866 22.099-93.494 0-21.694-4.027-39.802-11.968-53.822-0.645-1.128-1.312-2.234-2.003-3.31zM230.4 921.6h-153.6c-14.115 0-25.6-11.485-25.6-25.6v-460.8c0-14.115 11.485-25.6 25.6-25.6h153.6c14.115 0 25.6 11.485 25.6 25.6v460.738c0 0.022 0 0.043 0 0.066-0.002 14.114-11.486 25.597-25.6 25.597zM938.944 526.014c-7.739 15.546-15.57 21.186-18.944 21.186-14.139 0-25.6 11.461-25.6 25.6s11.461 25.6 25.6 25.6c2.149 0 3.699 0 5.971 4.008 3.378 5.965 5.315 16.382 5.315 28.582 0 22.77-6.427 49.883-16.771 70.754-10.131 20.437-20.451 27.856-24.915 27.856-14.139 0-25.6 11.461-25.6 25.6 0 9.067 4.715 17.034 11.827 21.582 1.581 16.206-5.976 59.629-25.627 87.947-7.438 10.722-15.238 16.87-21.4 16.87-14.139 0-25.6 11.461-25.6 25.6 0 45.072-49.765 65.6-96 65.6-128.659 0-164.691-19.259-206.413-41.56-38.992-20.84-82.864-44.29-193.587-58.085v-419.179c107.558-35.258 212.589-96.114 297.566-172.704 81.554-73.502 135.12-152.979 153.286-226.603 13.933 4.477 29.651 13.896 39.706 31.656 17.096 30.192 29.896 107.299-76.43 284.506-4.746 7.909-4.87 17.758-0.325 25.784s13.053 12.987 22.277 12.987h178.32c10.17 0 16.749 3.586 21.998 11.99 5.986 9.586 9.283 24.402 9.283 41.72 0 21.733-5.211 45.174-13.938 62.702z"/>
    `</svg>
  ),
  'Car': (
    <svg viewBox="0 0 1024 1024">
      <path class="path1"
        d="M281.6 819.2c-42.347 0-76.8-34.451-76.8-76.8s34.453-76.8 76.8-76.8 76.8 34.451 76.8 76.8-34.453 76.8-76.8 76.8zM281.6 716.8c-14.115 0-25.6 11.485-25.6 25.6s11.485 25.6 25.6 25.6 25.6-11.485 25.6-25.6-11.485-25.6-25.6-25.6z"/>
      <path class="path2"
        d="M742.4 819.2c-42.349 0-76.8-34.451-76.8-76.8s34.451-76.8 76.8-76.8 76.8 34.451 76.8 76.8-34.451 76.8-76.8 76.8zM742.4 716.8c-14.115 0-25.6 11.485-25.6 25.6s11.485 25.6 25.6 25.6 25.6-11.485 25.6-25.6-11.485-25.6-25.6-25.6z"/>
      <path class="path3"
        d="M868.256 609.642c-6.646-40.557-28.301-164.576-51.76-211.491-15.627-31.256-55.694-55.139-119.088-70.987-51.496-12.874-117.342-19.963-185.408-19.963s-133.912 7.090-185.408 19.965c-63.394 15.848-103.461 39.733-119.090 70.987-23.458 46.915-45.112 170.933-51.758 211.491-35.778 24.512-53.344 59.99-53.344 107.157v128c0 33.373 21.403 61.829 51.2 72.397v55.603c0 28.232 22.968 51.2 51.2 51.2h51.2c28.232 0 51.2-22.968 51.2-51.2v-51.2h409.6v51.2c0 28.232 22.968 51.2 51.2 51.2h51.2c28.232 0 51.2-22.968 51.2-51.2v-55.603c29.797-10.566 51.2-39.024 51.2-72.397v-128c0-47.166-17.566-82.645-53.344-107.158zM253.298 421.048c15.186-30.37 111.014-62.648 258.702-62.648s243.517 32.278 258.702 62.648c14.718 29.437 31.026 107.306 41.139 162.966-4.998-1.472-10.166-2.845-15.512-4.118-13.656-3.251-28.434-5.862-44.2-7.971l-148.421-106.334c-11.494-8.237-27.485-5.59-35.72 5.901-8.234 11.493-5.592 27.485 5.901 35.72l80.166 57.435c-43.517-1.443-91.251-1.446-142.056-1.446-5.998 0-11.942 0-17.854 0.003l-147.146-98.102c-11.765-7.843-27.658-4.664-35.501 7.099s-4.666 27.658 7.099 35.501l84.178 56.122c-68.654 1.237-128.362 4.946-175.107 16.075-5.347 1.274-10.517 2.648-15.517 4.12 10.115-55.654 26.418-133.515 41.146-162.97zM256 972.8h-51.2v-51.2h51.2v51.2zM768 972.8v-51.2h51.2v51.2h-51.2zM870.4 844.8c0 14.115-11.485 25.6-25.6 25.6h-665.6c-14.115 0-25.6-11.485-25.6-25.6v-128c0-47.331 24.896-72.565 85.93-87.098 64.275-15.302 160.757-15.302 272.47-15.302s208.194 0 272.47 15.302c61.034 14.533 85.93 39.766 85.93 87.098v128z"/>
    </svg>
  ),
});
<>
<Icon name="Car" size={6} color={indigo}/>
<Icon name="Yammer" size={3} color={purpleRed} />
<Icon name="ThumbsUp" size={2} color={teal}  />
</>
```

**Reference**

All available icons.

```jsx
const { Icon, IconNames } = require('precise-ui');
const names = IconNames.slice(0).sort();

<div style={{ columnWidth: '180px' }}>
  {
    names.map(name => (
      <div key={name}>
        <Icon name={name} />
        {' '}
        <span>{name}</span>
      </div>
    ))
  }
</div>
```
