## Styleguide

### Idea and Motivation

The basic idea of a pattern library is to provide the basis for consistent UI development.

In total we gain:

- **Efficiency**: Instead of repeatedly building similar components from scratch, Design Systems enable designers & developers to reuse components and thereby increase efficiency.
- **Consistency**: Design Systems introduce a shared set of principles and rules to build components. It becomes much easier to create consistent experiences across different platforms.
- **Scale**: Increased efficiency and consistency lead a company to build faster products at scale.
- **Alignment**: A Design System that responds to the needs of all platforms drives product alignment. Companies make sure their product is consistent on iOS, Android, and web.
- **Speed**: Design Systems provide a shared library of reusable components and guidelines. Building products becomes much faster.
- **Gaining time**: As building products becomes faster, designers gain time they can invest in other areas. Companies invest more in understanding users and their needs. There's more space for exploration because designers are no longer reinventing the wheel.
