### Use Cases

In this section use cases and examples will be described to provide you a better understanding if Precise UI is the right library for your Project.

**Cases where Precise UI should be used**

If your application consists on any of these cases below, Precise UI is highly recommended as your main UI library.

1. *Single Page Applications*: most modern web applications today are SPAs, and, for that reason, Precise UI was created to work smoothly with these types of applications.

2. *Forms Heavy Applications*: this library was created really with this and the next use case in mind. So, it is a suitable choise for applications that use a lot of forms and tables.

3. *Table Heavy Applications*: most applications that use it, are heavily using `AccordionTables` and `Tables`. It provides out-of-the-box sorting features.

4. *Internal Tools*: it is also a great library to use to develop complex internal tools that usually do not have dedicated designers but need a simple and consistent UI, nevertheless.

**Cases where Precise UI might not be ideal**

Nevertheless, there are always some cases where this library is probably not the best option and it is best to avoiding using it.

1. *Tiny Tools/Applications*: while it is possible to use Precise UI for a simple application, it might not make sense to have to overhead of using it for really small tools.

2. *Conceptual UI Applications*: websites and products that want to experiment with really conceptual designs are probably not suitable for using Precise UI. Our library focus on having a consistent look and feel across all applications using it.

3. *Acessible Applications*: while we are focusing on increasing accessibility of our library. It is still not recommended to use it for applications where accessibility is essential.

4. *Mobile-First Applications*: most of our components are fully responsive, however, many of them are planned to be used in a big screen. It is actually easy to create responsive applications with Precise UI, but if you application is mobile first, this might not be the ideal library.

