```                
                          ____           __                                    __ 
                         / __/___ ______/ /_      ____ __________  ____  ___  / /_
                        / /_/ __ `/ ___/ __/_____/ __ `/ ___/ __ \/ __ \/ _ \/ __/
                       / __/ /_/ (__  ) /_/_____/ /_/ (__  ) /_/ / / / /  __/ /_  
                      /_/  \__,_/____/\__/      \__,_/____/ .___/_/ /_/\___/\__/  
                                                         /_/
                                ---ASP.NET core WEB API using .NET8--- 
```

               
**fast-aspnet** is a pre-built ASP.NET core web API using .NET 8 with embedded security features &amp; good practices.

## Code Architecture :
Before delving into features, let's explain the code organization:

**MODELS:**
Models are used to define your future database entities. I've chosen to use BaseEntity models to centralize data logic, such as IDs and creation dates, for cleaner code.

**REPOSITORIES:**
Repositories are utilized to interact directly with the database using an abstraction layer for communication.

**SERVICES:**
Services are employed to manipulate client data using DTOs (Data Transfer Objects) and interact with the database using repository methods.

**CONTROLLERS:**
Controllers are responsible for interacting with your API through endpoints and retrieving data -> All controller are using **RESTFULL convention**

**MIGRATIONS :**
Migrations are used to interact with database creating your Models into it.

Creating migrations ? : `dotnet ef migrations add <migration_name>`

---

<img src="https://github.com/Yekuuun/fast-aspnet/blob/main/assets/api-controllers.png" alt="DebugInfo" />

---

## Sec features :

This section contains description about good practices i learned after completing pentest audits for other API's.

### HTTP headers
Add custom http headers to yours requests preventing from attacks.

Wich add ? => <a href="https://cheatsheetseries.owasp.org/cheatsheets/HTTP_Headers_Cheat_Sheet.html">OWASP CheatSheet</a>

<img src="https://github.com/Yekuuun/fast-aspnet/blob/main/assets/content-sec-curl.png" alt="DebugInfo" />

<img src="https://github.com/Yekuuun/fast-aspnet/blob/main/assets/content-sec.png" alt="DebugInfo" />

---

### Rate limiting
A rate limiter is a mechanism used in web applications and APIs to control the number of requests a client can make to a server within a specified time frame. Here's a concise overview:
Purpose of a Rate Limiter:

- Prevent Abuse: Protect your server from potential Denial of Service (DoS) attacks by limiting the number of requests from a single source.
- Resource Management: Ensure fair usage of server resources by preventing any single client from overwhelming the system.
- Cost Control: Reduce infrastructure costs by limiting excessive API calls, especially in cloud-based environments where usage directly impacts billing.
- Performance Optimization: Maintain consistent performance by preventing any single client from monopolizing server resources.

Rate limiter - IP based.

<img src="https://github.com/Yekuuun/fast-aspnet/blob/main/assets/rate-limiter.png" alt="DebugInfo" />

---
