![Logo](https://media.githubusercontent.com/media/XyrisOS/artwork/stable/images/xyris-banner-full.png)

[![License](https://img.shields.io/github/license/XyrisOS/xyris)](https://github.com/XyrisOS/xyris/blob/dev/LICENSE)
[![Kernel CI](https://github.com/XyrisOS/xyris/actions/workflows/kernel.yml/badge.svg)](https://github.com/XyrisOS/xyris/actions/workflows/kernel.yml)
[![Discord](https://img.shields.io/discord/732032083647660123.svg?logo=discord&logoColor=white&logoWidth=20&labelColor=7289DA&label=Discord&color=17cf48)](https://discord.gg/FNbZMr7p9d)

## Xyris
Xyris (previously known as Panix) is a small, hobbyist kernel with the goal of becoming a fully-fledged microkernel with an emphasis on usability and security.
Having now undergone three rewrites from the ground up, Xyris has come a long way since its first start in 2018.

### Design Philosophy
Xyris is designed to be readable first and foremost. Having been developed at [Cedarville University](https://cs.cedarville.edu), the primary goal of Xyris is to provide an opportunity for students (and anyone else interested) to learn the intricacies of kernel development. Function names are descriptive and structs are used when possible in order to help increase the legibility of code and provide an "easy-in" for kernel development.

### How to Help
We are constantly looking for people to help contribute to Xyris. If you would like to contribute driver code or a new feature, feel free to fork the repository and submit a pull request. We would love to have you help us make Xyris better! The [Getting Started](https://github.com/XyrisOS/xyris/wiki/Getting-Started) wiki page describes everything necessary to start developing.

### Demos
- [Minesweeper](https://github.com/Jmallone/Panix/tree/minesweeper) [(@jmallone)](https://github.com/Jmallone)

### License
Xyris is available under the MIT license. This license may not apply to third party source code used by Xyris. Third party source code used is listed below.

See [LICENSE](https://github.com/XyrisOS/xyris/blob/stable/LICENSE) for details.

## Contributors
<a href="https://github.com/XyrisOS/xyris/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=XyrisOS/xyris" />
</a>
<br>

## Third Party Projects
* [Limine Bootloader](https://github.com/limine-bootloader/limine)
* [Liballoc](https://github.com/blanham/liballoc)
* [Catch2](https://github.com/catchorg/Catch2)
