# Contributing to Xyris

Thank you for your interest in contributing to Xyris! This document is designed to help streamline and document the contribution process.

## Getting Started

If you are new to the project, please start with the [Getting Started Guide](https://github.com/XyrisOS/xyris/wiki/Getting-Started).

## Ways to Contribute

### Pull Requests

Pull requests are number one way to contribute directly to Xyris. Before opening a Pull Request, please do a self-review first. All Pull Requests
must be approved by at least one Xyris organization member before it may be merged. Contributions should be of high quality, and an important step
in ensuring your code is merged is to double check your work by doing a self-review. The [Wiki](https://github.com/XyrisOS/xyris/wiki/Pull-Requests)
details all of the expectations and submission process for Pull Requests.

### Issues

Opening an issue is another important way to contribute. Issue templates are provided for both feature and bug reports. It is highly recommended that
these templates are used unless there is a strong reason otherwise. Additionally, before contributing code or opening a Pull Request, it is highly suggested
that an issue is opened so that the branch name may reflect what issue it resolves.

If you are looking to contribute code and want to work on an open issue, the [`easy` label](https://github.com/XyrisOS/xyris/issues?q=is%3Aissue+is%3Aopen+label%3Aeasy)
is a good way to find beginner-friendly tasks.

### Discussions

If your topic does not fit neatly into either a feature or bug report category, consider opening a new topic in [Discussions](https://github.com/XyrisOS/xyris/discussions)
section instead of an Issue. If a discussion is opened instead, people will be able to discuss whatever question, improvement, or other comment you have.
