package plugin

var (
	PluginSelectionIcon    = NewWoxImageSvg(`<svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="48" height="48" viewBox="0 0 48 48"><path fill="#388e3c" d="M43,38.833C43,41.135,41.135,43,38.833,43H17.167C14.866,43,13,41.135,13,38.833V17.167 C13,14.865,14.866,13,17.167,13h21.667C41.135,13,43,14.865,43,17.167V38.833z"></path><path fill="#c8e6c9" d="M35,30.833C35,33.135,33.135,35,30.833,35H9.167C6.866,35,5,33.135,5,30.833V9.167 C5,6.865,6.866,5,9.167,5h21.667C33.135,5,35,6.865,35,9.167V30.833z"></path><path fill="#4caf50" d="M18 28.121L11.064 21.186 13.186 19.064 18 23.879 28.814 13.064 30.936 15.186z"></path></svg>`)
	PluginAICommandIcon    = NewWoxImageBase64(`data:image/png;base64,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`)
	PluginAppIcon          = NewWoxImageSvg(`<svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="48" height="48" viewBox="0 0 48 48"><path fill="#0091ea" d="M14.1,42h19.8c4.474,0,8.1-3.627,8.1-8.1V27H6v6.9C6,38.373,9.626,42,14.1,42z"></path><rect width="36" height="11" x="6" y="16" fill="#00b0ff"></rect><path fill="#40c4ff" d="M33.9,6H14.1C9.626,6,6,9.626,6,14.1V16h36v-1.9C42,9.626,38.374,6,33.9,6z"></path><path fill="#fff" d="M22.854,18.943l1.738-2.967l-1.598-2.727c-0.418-0.715-1.337-0.954-2.052-0.536	c-0.715,0.418-0.955,1.337-0.536,2.052L22.854,18.943z"></path><path fill="#fff" d="M26.786,12.714c-0.716-0.419-1.635-0.179-2.052,0.536L16.09,28h3.477l7.754-13.233	C27.74,14.052,27.5,13.133,26.786,12.714z"></path><path fill="#fff" d="M34.521,32.92l-7.611-12.987l-0.763,1.303c-0.444,0.95-0.504,2.024-0.185,3.011l5.972,10.191	c0.279,0.476,0.78,0.741,1.295,0.741c0.257,0,0.519-0.066,0.757-0.206C34.701,34.554,34.94,33.635,34.521,32.92z"></path><path fill="#fff" d="M25.473,27.919l-0.171-0.289c-0.148-0.224-0.312-0.434-0.498-0.621H12.3	c-0.829,0-1.5,0.665-1.5,1.484s0.671,1.484,1.5,1.484h13.394C25.888,29.324,25.835,28.595,25.473,27.919z"></path><path fill="#fff" d="M16.66,32.961c-0.487-0.556-1.19-0.934-2.03-0.959l-0.004,0c-0.317-0.009-0.628,0.026-0.932,0.087	l-0.487,0.831c-0.419,0.715-0.179,1.634,0.536,2.053c0.238,0.14,0.5,0.206,0.757,0.206c0.515,0,1.017-0.266,1.295-0.741	L16.66,32.961z"></path><path fill="#fff" d="M30.196,27.009H35.7c0.829,0,1.5,0.665,1.5,1.484s-0.671,1.484-1.5,1.484h-5.394	C30.112,29.324,30.01,27.196,30.196,27.009z"></path></svg>`)
	PluginCalculatorIcon   = NewWoxImageSvg(`<svg t="1697204721503" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="5110" width="200" height="200"><path d="M853.333333 341.333333H170.666667v512c0 46.933333 38.4 85.333333 85.333333 85.333334h512c46.933333 0 85.333333-38.4 85.333333-85.333334V341.333333z" fill="#616161" p-id="5111"></path><path d="M768 85.333333H256C209.066667 85.333333 170.666667 123.733333 170.666667 170.666667v192h682.666666V170.666667c0-46.933333-38.4-85.333333-85.333333-85.333334z" fill="#424242" p-id="5112"></path><path d="M768 298.666667H256c-12.8 0-21.333333-8.533333-21.333333-21.333334V170.666667c0-12.8 8.533333-21.333333 21.333333-21.333334h512c12.8 0 21.333333 8.533333 21.333333 21.333334v106.666666c0 12.8-8.533333 21.333333-21.333333 21.333334z" fill="#9CCC65" p-id="5113"></path><path d="M704 213.333333h42.666667v42.666667h-42.666667zM618.666667 213.333333h42.666666v42.666667h-42.666666z" fill="#33691E" p-id="5114"></path><path d="M768 490.666667h-64c-12.8 0-21.333333-8.533333-21.333333-21.333334v-42.666666c0-12.8 8.533333-21.333333 21.333333-21.333334h64c12.8 0 21.333333 8.533333 21.333333 21.333334v42.666666c0 12.8-8.533333 21.333333-21.333333 21.333334z" fill="#FF5252" p-id="5115"></path><path d="M320 490.666667h-64c-12.8 0-21.333333-8.533333-21.333333-21.333334v-42.666666c0-12.8 8.533333-21.333333 21.333333-21.333334h64c12.8 0 21.333333 8.533333 21.333333 21.333334v42.666666c0 12.8-8.533333 21.333333-21.333333 21.333334zM469.333333 490.666667h-64c-12.8 0-21.333333-8.533333-21.333333-21.333334v-42.666666c0-12.8 8.533333-21.333333 21.333333-21.333334h64c12.8 0 21.333333 8.533333 21.333334 21.333334v42.666666c0 12.8-8.533333 21.333333-21.333334 21.333334zM618.666667 490.666667h-64c-12.8 0-21.333333-8.533333-21.333334-21.333334v-42.666666c0-12.8 8.533333-21.333333 21.333334-21.333334h64c12.8 0 21.333333 8.533333 21.333333 21.333334v42.666666c0 12.8-8.533333 21.333333-21.333333 21.333334zM320 618.666667h-64c-12.8 0-21.333333-8.533333-21.333333-21.333334v-42.666666c0-12.8 8.533333-21.333333 21.333333-21.333334h64c12.8 0 21.333333 8.533333 21.333333 21.333334v42.666666c0 12.8-8.533333 21.333333-21.333333 21.333334zM469.333333 618.666667h-64c-12.8 0-21.333333-8.533333-21.333333-21.333334v-42.666666c0-12.8 8.533333-21.333333 21.333333-21.333334h64c12.8 0 21.333333 8.533333 21.333334 21.333334v42.666666c0 12.8-8.533333 21.333333-21.333334 21.333334zM618.666667 618.666667h-64c-12.8 0-21.333333-8.533333-21.333334-21.333334v-42.666666c0-12.8 8.533333-21.333333 21.333334-21.333334h64c12.8 0 21.333333 8.533333 21.333333 21.333334v42.666666c0 12.8-8.533333 21.333333-21.333333 21.333334zM320 746.666667h-64c-12.8 0-21.333333-8.533333-21.333333-21.333334v-42.666666c0-12.8 8.533333-21.333333 21.333333-21.333334h64c12.8 0 21.333333 8.533333 21.333333 21.333334v42.666666c0 12.8-8.533333 21.333333-21.333333 21.333334zM469.333333 746.666667h-64c-12.8 0-21.333333-8.533333-21.333333-21.333334v-42.666666c0-12.8 8.533333-21.333333 21.333333-21.333334h64c12.8 0 21.333333 8.533333 21.333334 21.333334v42.666666c0 12.8-8.533333 21.333333-21.333334 21.333334zM618.666667 746.666667h-64c-12.8 0-21.333333-8.533333-21.333334-21.333334v-42.666666c0-12.8 8.533333-21.333333 21.333334-21.333334h64c12.8 0 21.333333 8.533333 21.333333 21.333334v42.666666c0 12.8-8.533333 21.333333-21.333333 21.333334zM320 874.666667h-64c-12.8 0-21.333333-8.533333-21.333333-21.333334v-42.666666c0-12.8 8.533333-21.333333 21.333333-21.333334h64c12.8 0 21.333333 8.533333 21.333333 21.333334v42.666666c0 12.8-8.533333 21.333333-21.333333 21.333334zM469.333333 874.666667h-64c-12.8 0-21.333333-8.533333-21.333333-21.333334v-42.666666c0-12.8 8.533333-21.333333 21.333333-21.333334h64c12.8 0 21.333333 8.533333 21.333334 21.333334v42.666666c0 12.8-8.533333 21.333333-21.333334 21.333334zM618.666667 874.666667h-64c-12.8 0-21.333333-8.533333-21.333334-21.333334v-42.666666c0-12.8 8.533333-21.333333 21.333334-21.333334h64c12.8 0 21.333333 8.533333 21.333333 21.333334v42.666666c0 12.8-8.533333 21.333333-21.333333 21.333334z" fill="#E0E0E0" p-id="5116"></path><path d="M768 618.666667h-64c-12.8 0-21.333333-8.533333-21.333333-21.333334v-42.666666c0-12.8 8.533333-21.333333 21.333333-21.333334h64c12.8 0 21.333333 8.533333 21.333333 21.333334v42.666666c0 12.8-8.533333 21.333333-21.333333 21.333334zM768 746.666667h-64c-12.8 0-21.333333-8.533333-21.333333-21.333334v-42.666666c0-12.8 8.533333-21.333333 21.333333-21.333334h64c12.8 0 21.333333 8.533333 21.333333 21.333334v42.666666c0 12.8-8.533333 21.333333-21.333333 21.333334zM768 874.666667h-64c-12.8 0-21.333333-8.533333-21.333333-21.333334v-42.666666c0-12.8 8.533333-21.333333 21.333333-21.333334h64c12.8 0 21.333333 8.533333 21.333333 21.333334v42.666666c0 12.8-8.533333 21.333333-21.333333 21.333334z" fill="#BDBDBD" p-id="5117"></path></svg>`)
	PluginDoctorIcon       = NewWoxImageSvg(`<svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 26 26"><path fill="#e93a3a" d="M10 1C8.355 1 7 2.355 7 4v2h2V4c0-.563.437-1 1-1h6c.563 0 1 .437 1 1v2h2V4c0-1.645-1.355-3-3-3zM3 7a3 3 0 0 0-3 3v12a3 3 0 0 0 3 3h20c1.656 0 3-1.344 3-3V10a3 3 0 0 0-3-3zm10 2.906A6.09 6.09 0 0 1 19.094 16A6.09 6.09 0 0 1 13 22.094A6.09 6.09 0 0 1 6.906 16A6.09 6.09 0 0 1 13 9.906M12 13v2h-2v2h2v2h2v-2h2v-2h-2v-2z"/></svg>`)
	PluginFileIcon         = NewWoxImageSvg(`<svg t="1715182653592" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="7787" width="200" height="200"><path d="M0 0m102.4 0l819.2 0q102.4 0 102.4 102.4l0 819.2q0 102.4-102.4 102.4l-819.2 0q-102.4 0-102.4-102.4l0-819.2q0-102.4 102.4-102.4Z" fill="#8A73F2" p-id="7788"></path><path d="M767.36 776.7552c0 16.9472-8.5248 29.6448-21.2992 29.6448H307.1744c-12.8 0-25.5744-12.6976-25.5744-29.6448V247.2448c0-16.9472 8.5248-29.6448 21.2992-29.6448h235.8784l227.072 215.2448 1.5104 343.9104z" fill="#EEF0FF" p-id="7789"></path><path d="M766.5664 432.896h-194.2784c-20.8128 0-34.688-20.8128-34.688-48.6144V217.6l228.9664 215.296z" fill="#CDC7FB" p-id="7790"></path></svg>`)
	PluginMenusIcon        = NewWoxImageSvg(`<svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24"><path fill="#53b9f9" d="M12 22c-4.714 0-7.071 0-8.536-1.465C2 19.072 2 16.714 2 12s0-7.071 1.464-8.536C4.93 2 7.286 2 12 2c4.714 0 7.071 0 8.535 1.464C22 4.93 22 7.286 22 12c0 4.714 0 7.071-1.465 8.535C19.072 22 16.714 22 12 22" opacity="0.5"/><path fill="#53b9f9" d="M18.75 8a.75.75 0 0 1-.75.75H6a.75.75 0 0 1 0-1.5h12a.75.75 0 0 1 .75.75m0 4a.75.75 0 0 1-.75.75H6a.75.75 0 0 1 0-1.5h12a.75.75 0 0 1 .75.75m0 4a.75.75 0 0 1-.75.75H6a.75.75 0 0 1 0-1.5h12a.75.75 0 0 1 .75.75"/></svg>`)
	PluginSysIcon          = NewWoxImageSvg(`<svg t="1700799439280" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="5120" width="200" height="200"><path d="M914.032 867.569h-799.58c-25.398 0-45.969 20.683-45.969 46.216 0 25.534 20.571 46.215 45.968 46.215h799.581C939.428 960 960 939.319 960 913.785c0-25.415-20.572-46.216-45.968-46.216z" fill="#FA8B14" p-id="5121"></path><path d="M102.73 791.32h814.175c21.38 0 38.73-17.45 38.73-38.939V102.938c0-21.495-17.35-38.938-38.73-38.938H102.73C81.35 64 64 81.443 64 102.938v649.443c0.112 21.489 17.35 38.938 38.73 38.938z m224.708-379.778l-34.129-46.91c-6.323-8.784-7.013-20.45-1.61-29.81l30.223-52.686c5.404-9.359 15.745-14.674 26.435-13.517l57.572 6.24c11.834 1.269 22.984-5.203 27.81-16.175l23.331-53.262c4.366-9.94 14.135-16.292 24.82-16.292h60.563c10.8 0 20.57 6.352 24.824 16.292l23.326 53.262c4.832 10.86 16.094 17.444 27.816 16.174l57.572-6.239c10.689-1.157 21.144 4.158 26.429 13.517l30.228 52.687c5.398 9.358 4.709 21.025-1.61 29.809l-34.017 46.91c-7.007 9.59-7.007 22.644 0 32.348l34.129 46.91c6.325 8.784 7.014 20.45 1.61 29.81l-30.223 52.686c-5.402 9.359-15.745 14.674-26.428 13.517l-57.578-6.24c-11.834-1.269-22.984 5.201-27.81 16.175l-23.332 53.267c-4.366 9.935-14.135 16.287-24.819 16.287h-60.45c-10.803 0-20.57-6.352-24.819-16.287l-23.333-53.267c-4.825-10.861-16.087-17.444-27.809-16.174l-57.572 6.239c-10.69 1.157-21.15-4.158-26.434-13.517l-30.224-52.687c-5.403-9.359-4.713-21.025 1.612-29.809l34.126-46.91c6.78-9.704 6.78-22.758-0.23-32.348z m100.613 16.174c0 48.178 38.842 87.229 86.763 87.229 47.92 0 86.762-39.05 86.762-87.23 0-48.179-38.842-87.23-86.762-87.23-47.921 0-86.763 39.051-86.763 87.23z" fill="#2075CC" p-id="5122"></path></svg>`)
	PluginWebsearchIcon    = NewWoxImageSvg(`<svg t="1700799533400" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="8846" width="200" height="200"><path d="M869.484748 1024a96.009331 96.009331 0 0 1-76.327418-37.923686l-174.736982-228.982254a96.009331 96.009331 0 0 1 152.654836-116.651337l174.736982 228.982254a96.009331 96.009331 0 0 1-76.327418 154.094976z" fill="#D34233" p-id="8847"></path><path d="M770.595138 640.92277a96.009331 96.009331 0 0 0-100.809798-34.563359 240.023327 240.023327 0 0 1-57.605598 65.766391c-3.360327 2.400233-7.2007 4.32042-11.041074 6.720653a96.009331 96.009331 0 0 0 16.801633 79.687745l70.566859 92.649004a432.041989 432.041989 0 0 0 39.843872-26.882612A429.161709 429.161709 0 0 0 826.760596 715.810048z" fill="#C1211A" p-id="8848"></path><path d="M490.727938 864.144464a432.041989 432.041989 0 1 1 261.625427-88.328584A432.041989 432.041989 0 0 1 490.727938 864.144464zM490.727938 192.079148a240.023327 240.023327 0 1 0 192.018662 96.009331 240.023327 240.023327 0 0 0-192.018662-96.009331z" fill="#F16A54" p-id="8849"></path></svg>`)
	PluginBackupIcon       = NewWoxImageBase64(`data:image/png;base64,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`)
	PluginBrowserIcon      = NewWoxImageBase64(`data:image/png;base64,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`)
	PluginBookmarkIcon     = NewWoxImageBase64(`data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAAACXBIWXMAAAsTAAALEwEAmpwYAAAC9UlEQVR4nO1bTW8SURSdahfWdf0l6u9whfoPdNtNo2Ye07jRtNbE2LU1UZgHiZLUiJpIqXVhWw2ygkZMdGNTrMaApYChHHOnSJpWyswwH8z03uQkBN5M7j1z77sfvFEUFhYWlj6iaTihSlxWdbxUJcpCAk5h5skv4PMVW6Br99+ro9uLqI5LCjCiOCHXkzij6lhy0mi3CDiArBbD+EDGaws4LXR8cMt4lwkgvJ9IYsw2AULippvGe0AAhYVm7+lnMarq+Bl0AoSOH2SLnad/3m3jPSFAAjfiOGedAB0XwkIA2WKZgKhEJCwEkC1MgFWJsgeAQ0DwHgDeBAVnAXAaFFwH4BAJt1JtbHyvo1mrmUJ9u4aVYjM8hdCDTMu08f9QqexYIqBamDQwlARoCeD1xz/IlxqmkPvUwKOl1qH7TB8goF26ilLuHvRXOUwlWgboM31Hv+1fOx2GUjiaaONrfgaVwjUsv03hbmqr51r6jdZUi5P4kp81rg08AcILkpkAuOMBc+ldxJdbphB70zIyR2g8YC69i8a2tSywUa4fbwK+hYkAYSMEbj8NUQiIAIEJkOwBEVdK4UzefClsFVQ6P+6UzrPP2lhbb/53HelAungeAvM2miG7zRN1kUeto8bMn3a4bL4dtgpqn98V9tpn8oRqdadnau2XXXgPkLwJRhwPAREgsAdIn2eCvyu17jRotdg0NjinNkvSoV+XORQzwZXOQJRSm9MZw5c0qFmYCa6uN3FnYe8pkSdQkeNUwUQ6+FIIiQCBCZDsARHfByLxI/BwsdWNY9rRaXhi9lrSITAjseYRoM2M7mvl7zYC6dCPhGARULZOwH0/CBDHPQREgMAESPaAyNAelRVewM5RWeHRYWlPkMRZywRoWYzSUXPflR8QqsRWJImTlgkgETqm/DbAAaiKXZlIYoxeOwns09exps3jlDKIaDGMqzoW/TbGBjIDvzTVFWBETeCiKpEWEptDYFwvbAodz42879RrcywsLEqY5S+u/BSNeloCCQAAAABJRU5ErkJggg==`)
	PluginClipboardIcon    = NewWoxImageBase64(`data:image/png;base64,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`)
	PluginIndicatorIcon    = NewWoxImageBase64(`data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAYAAABw4pVUAAAACXBIWXMAAAsTAAALEwEAmpwYAAACVklEQVR4nO2cQUrdUBSG30aae1Md5RZUcFSecCaOWtfRtw+ltHYB2g2cXWgp4kTX4CKqzlOS+AqVQqG+l//05fvgzIQcv48kjwzubAYAAAAAAAAAAAAAAAAAsBZSbq5TXdoXTy5Xm7SLjJUIqIfZpF1kLP+Bt8ff/3nSioNE2EVGJAkp0C4yIklIgXaREUlCCrSLjEgSUqBdZESSkALtIiOShBRol7Xyqi5HVd18S3XzuMrf+um/muaxqpvLqi7vpTGqXD7qZZRQU+XmRHZn9Ets77S7iy/t/PymNb+b5MzPb9rdxWnvoo+iuFOGx1TpF1ELsSCzt/g83Cm5XIweJOXy0F384OutXIQFmc7F8Ngq9+MHeXpmqiVYsFl6CRVka/9w9Jfp1v7hX/d4/jcv2fNP1wsbZMqTCHInj0AQ14sniOtlE8T1ggnieqkECSDSCKKXZwTRCzOC6CUZQfRijCB6GRZg+HTi+ggEcb14grheNkFcL5ggrpdKkAAijSB6eUYQvTAjiF6SEUQvxgiil2EBhk8nro9AENeLJ4jrZRPE9YIJ4nqpBAkg0giil2cE0QszguglGUH0YowgehkWYPh04voIBHG9eIK4XjZBXC+YIK6XSpAAIm2TgygODkgBDioIG2TKk2RBng6fmfKxTPZs5me/Dp/5MXqQ7gS17uLdkURqERZk9j580h3P1B3S1V98e6ePMuU7ZX52O8RYHmD2+s270YP0UXJzon65pnDTHEti/Han5HKxfKdMcnJ56BzI7gwAAAAAAAAAAAAAAAAAAJitgZ+lmGHcVGx/0gAAAABJRU5ErkJggg==`)
	PluginQueryHistoryIcon = NewWoxImageBase64(`data:image/png;base64,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`)
	PluginThemeIcon        = NewWoxImageBase64(`data:image/png;base64,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`)
	PluginUrlIcon          = NewWoxImageBase64(`data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAACXBIWXMAAAsTAAALEwEAmpwYAAAEEUlEQVR4nO2Yz28TRxTHX9omjSqSS5XEO2NDVXKsqlYJSPkDeuHUc1X12FtSVBLv2G5iRClqA5EgCoJkdwvqvf9CBSGJWxrieGdoKkPizihATyC1Un6UiKlmTfjhHRsveGMj+SuNVs7m7X7eezPvzSxAU0011VRQGdN39iOHp7DDF7Aj/sY230G2uIdtMY9tnkQ/rsegEXXgUqEdO2ICOWILO0KWG8gWm9jhp3vP5d+GRlG3tdqDHJ6pBI59gy/0/HS7u0HgBQsGL4rZcHimrpk4cKkQwbZYeRl4/DQT4w0Hj2y+gRwxGrvMD/ZNL7aqK3LEmPq7bk1ELwvcOPCOuB+1xGGdHbLXB3ROYIeThoE3LN5XyR45YkyzFq6+FvBKajppbO/AXlSbV4VXUlVHY78FYTepcnU+CLxS1BK9e54B1WFrAa+EbJHWVK0rEJY6Tv0xgCy+U/pSw/rrYXvy+gyYi/urfVbUEoe1VcjmZu3J04V2GLo22XEy+9AXMYvLtvi8hKMZCfHcJpjsNAxW7qiGxftUxnQ9o/Z9IOH2QHzpVxiak12Ted/U6fg2K+GrOQUvgbDiMNkCmNn3gsDjYvR/qD08oQziyxKGZmXkYsH30re+npUwfOMp/JPh/guD+c7q4cV8bfdCwywCJlvxYJQDg1e96VL64pbBKxJGshoHvExcrxJ+RZXmcOA9B3JlM9D53dIncCx7HAjb8DtBJSTd/sjF2/2V4FVTDA/ei6QrH68B/yJ2xJhnl3A/1WXhzRTLGFPsAbZ5neB3I3l04UHX1K0L2t2mvT7g2Zvsl1Lb1m9yj4xzyxJbhXrBe+M+jNzoV2fY4jHQ74QxvXq8PU2/KLV9I0mlcTYrsbUWIryqNpXgifukw2Kbn9F24ulVGZn43WffQpg0zi5JNLMWErxqUoRmqoFXUocSbItZnwMX8rJr3O/AbgaQ5wD/M2ZzBDWVSSeqhd+VOoA//lRSdMBak8ZkTu474S+nbaM57x6yVjO1LZVKKRoDQreCwD+/FebjaGZtE00x+e73i7Il4Q/EvhPZHTxJJ8I5sBOa0sBvAKGHqn0EOn8r1nly6eeWBNVkkcp3TrlHIDSZbE7jwGiwZ7ifg0kf6Tsx/Q1CFaH3NHuY96u2N9lnZeEJ+6d0L1R7mXTb9+I0a6tB5LchsfwBhC6iycAwPfhKkVfww+wj2BMRek2zgxx7PeCVTJrUVyG3uLcp1cjNI5Xh3Q9hT5WiMTDpptYJlQnCer3joboSltZvmesR+WdF6JkyVaS6UVd4pS8XW8Gksy/nwM1tMPMfQ911bLnbO4gHirz6/wA9I3Spua4+iejXxLNTRt0ff9Gnk/opnouCyYg3rUx6Fwj7z7t6vxnx7jfVVFNNQUD9D+AcOX6Kbv2UAAAAAElFTkSuQmCC`)
	PluginWPMIcon          = NewWoxImageBase64(`data:image/png;base64,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`)

	DefaultActionIcon        = NewWoxImageSvg(`<svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24"><path fill="#5da3ef" d="m21.6 23l-3.075-3.05q-.45.275-.962.413T16.5 20.5q-1.65 0-2.825-1.175T12.5 16.5t1.175-2.825T16.5 12.5t2.825 1.175T20.5 16.5q0 .575-.15 1.088t-.425.962L23 21.6zM5.5 20.5q-1.65 0-2.825-1.175T1.5 16.5t1.175-2.825T5.5 12.5t2.825 1.175T9.5 16.5t-1.175 2.825T5.5 20.5m11-2q.825 0 1.413-.587T18.5 16.5t-.587-1.412T16.5 14.5t-1.412.588T14.5 16.5t.588 1.413t1.412.587m-11-9q-1.65 0-2.825-1.175T1.5 5.5t1.175-2.825T5.5 1.5t2.825 1.175T9.5 5.5T8.325 8.325T5.5 9.5m11 0q-1.65 0-2.825-1.175T12.5 5.5t1.175-2.825T16.5 1.5t2.825 1.175T20.5 5.5t-1.175 2.825T16.5 9.5"/></svg>`)
	AddToFavIcon             = NewWoxImageSvg(`<svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24"><path fill="#e93a3a" d="M22 9.67a1 1 0 0 0-.86-.67l-5.69-.83L12.9 3a1 1 0 0 0-1.8 0L8.55 8.16L2.86 9a1 1 0 0 0-.81.68a1 1 0 0 0 .25 1l4.13 4l-1 5.68a1 1 0 0 0 1.47 1.08l5.1-2.67l5.1 2.67a.93.93 0 0 0 .46.12a1 1 0 0 0 .59-.19a1 1 0 0 0 .4-1l-1-5.68l4.13-4A1 1 0 0 0 22 9.67m-6.15 4a1 1 0 0 0-.29.88l.72 4.2l-3.76-2a1.06 1.06 0 0 0-.94 0l-3.76 2l.72-4.2a1 1 0 0 0-.29-.88l-3-3l4.21-.61a1 1 0 0 0 .76-.55L12 5.7l1.88 3.82a1 1 0 0 0 .76.55l4.21.61Z"/></svg>`)
	RemoveFromFavIcon        = NewWoxImageSvg(`<svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24"><path fill="#e93a3a" d="M17.562 21.56a1 1 0 0 1-.465-.116L12 18.764l-5.097 2.68a1 1 0 0 1-1.45-1.053l.973-5.676l-4.124-4.02a1 1 0 0 1 .554-1.705l5.699-.828l2.549-5.164a1.04 1.04 0 0 1 1.793 0l2.548 5.164l5.699.828a1 1 0 0 1 .554 1.705l-4.124 4.02l.974 5.676a1 1 0 0 1-.985 1.169Z"/></svg>`)
	OpenContainingFolderIcon = NewWoxImageBase64(`data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAACXBIWXMAAAsTAAALEwEAmpwYAAABCUlEQVR4nO2VMWrDQBBFp8gRQhoFV5a0pM0Zci/fRAK7CcJd0gXcRfKALxFIZ4OdA+gbxZ1A3nU1A/4Pfv/f7OyuCCGEEDICS3lGJQ1q+UMtSEolC3FTvpZDcnFvErhM/vbyXiRwy9p4lMBQYPUAfGVAVwAabNMVPTazX3w+vaUJDOXb3L64jtLmPT4eX+MCw+Sty+pENrOfuICHtdGpUyj6uIB1Sb0eCoAnELhCV7FeEfASq/2UwWdU7ScNfmTqMxLDuiAooPZTBldI7ScNXmL1GbmHZ/RkXRJT2YZjXGBbrh0LNAkCoYCWe/OyOk55wO5lHhX4l/jOM2h4d7JOp2HyyeUJIYTcFWcLXG7i+rfwxwAAAABJRU5ErkJggg==`)
	PreviewIcon              = NewWoxImageSvg(`<svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24"><path fill="#5366f9" d="M5 21q-.825 0-1.412-.587T3 19V5q0-.825.588-1.412T5 3h14q.825 0 1.413.588T21 5v14q0 .825-.587 1.413T19 21zm0-2h14V7H5zm7-2q-2.05 0-3.662-1.112T6 13q.725-1.775 2.338-2.887T12 9t3.663 1.113T18 13q-.725 1.775-2.337 2.888T12 17m0-2.5q-.625 0-1.062-.437T10.5 13t.438-1.062T12 11.5t1.063.438T13.5 13t-.437 1.063T12 14.5m0 1q1.05 0 1.775-.725T14.5 13t-.725-1.775T12 10.5t-1.775.725T9.5 13t.725 1.775T12 15.5"/></svg>`)
	AirdropIcon              = NewWoxImageSvg(`<svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24"><g fill="none" fill-rule="evenodd"><path d="m12.594 23.258l-.012.002l-.071.035l-.02.004l-.014-.004l-.071-.036q-.016-.004-.024.006l-.004.01l-.017.428l.005.02l.01.013l.104.074l.015.004l.012-.004l.104-.074l.012-.016l.004-.017l-.017-.427q-.004-.016-.016-.018m.264-.113l-.014.002l-.184.093l-.01.01l-.003.011l.018.43l.005.012l.008.008l.201.092q.019.005.029-.008l.004-.014l-.034-.614q-.005-.019-.02-.022m-.715.002a.02.02 0 0 0-.027.006l-.006.014l-.034.614q.001.018.017.024l.015-.002l.201-.093l.01-.008l.003-.011l.018-.43l-.003-.012l-.01-.01z"/><path fill="#5da3ef" d="M12 4a8 8 0 0 0-3.578 15.157a1 1 0 0 1-.896 1.789A10 10 0 0 1 2 12C2 6.477 6.477 2 12 2s10 4.477 10 10a10 10 0 0 1-5.526 8.946a1 1 0 1 1-.896-1.789A8 8 0 0 0 12 4m0 4a4 4 0 0 0-1.789 7.579a1 1 0 0 1-.895 1.788a6 6 0 1 1 5.369 0a1 1 0 0 1-.896-1.788A4 4 0 0 0 12 8m-2 4a2 2 0 1 1 4 0a2 2 0 0 1-4 0"/></g></svg>QAAAAASUVORK5CYII=`)
	CopyIcon                 = NewWoxImageBase64(`data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAACXBIWXMAAAsTAAALEwEAmpwYAAABRElEQVR4nO2ZzUpCQRiG5wJa63gFQfaziLqFEhfp7RzbtiloUwg6Bi26FEFy00ItMUHPHPm6gFauvhijIKgo5puxn/eBd/89zHNWRykAwLeoPnC5QjyrELPPdlqTtloGB8SZ7/Fua4e95UhIHO9WrPWeJS6mnV8rUIwhkW9Ny9qkM31+x7nja5Hj3dZr/bcSZtxVSq2IC2iTZgVjWVpgI+l/JCGLOz6EwGYyeF9COqdQAlvJII5EKIHto/tPJXYv0/aPFtjrPMaRCCXw1SkIGLwAIyEfkBAhIT+QECEhP5AQISE/kBAhIT+QECEhP5AQISE//lBCQ86ddLk0nscUsHIC9RHnT2949WoYS8JWiffFBAqNCeuz24WEewmXU4gpaV4FXiTqo8X3EGoq1A+OGNPN1MoLNLJSDAndTK021r95AP4ZT0uTPkQe0ydSAAAAAElFTkSuQmCC`)
	OpenIcon                 = NewWoxImageSvg(`<svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="64" height="64" viewBox="0 0 32 32"><polygon fill="#0f518c" points="30,30 2,30 2,2 17,2 17,6 6,6 6,26 26,26 26,15 30,15"></polygon><polygon fill="#ed0049" points="19,2 19,6 23.172,6 14.586,14.586 17.414,17.414 26,8.828 26,13 30,13 30,2"></polygon></svg>`)
	TerminateAppIcon         = NewWoxImageSvg(`<svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 20 20"><path fill="#f33939" d="M2.93 17.07A10 10 0 1 1 17.07 2.93A10 10 0 0 1 2.93 17.07m1.41-1.41A8 8 0 1 0 15.66 4.34A8 8 0 0 0 4.34 15.66m9.9-8.49L11.41 10l2.83 2.83l-1.41 1.41L10 11.41l-2.83 2.83l-1.41-1.41L8.59 10L5.76 7.17l1.41-1.41L10 8.59l2.83-2.83z"/></svg>`)
	TextIcon                 = NewWoxImageSvg(`<svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="48" height="48" viewBox="0 0 48 48"><path fill="#90CAF9" d="M40 45L8 45 8 3 30 3 40 13z"></path><path fill="#E1F5FE" d="M38.5 14L29 14 29 4.5z"></path><path fill="#1976D2" d="M16 21H33V23H16zM16 25H29V27H16zM16 29H33V31H16zM16 33H29V35H16z"></path></svg>`)
	ErrorIcon                = NewWoxImageSvg(`<svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24"><path fill="#f21818" d="M12 17q.425 0 .713-.288T13 16t-.288-.712T12 15t-.712.288T11 16t.288.713T12 17m-1-4h2V7h-2zm1 9q-2.075 0-3.9-.788t-3.175-2.137T2.788 15.9T2 12t.788-3.9t2.137-3.175T8.1 2.788T12 2t3.9.788t3.175 2.137T21.213 8.1T22 12t-.788 3.9t-2.137 3.175t-3.175 2.138T12 22"/></svg>`)
	CorrectIcon              = NewWoxImageSvg(`<svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24"><path fill="#1adb1d" d="m10.6 16.6l7.05-7.05l-1.4-1.4l-5.65 5.65l-2.85-2.85l-1.4 1.4zM12 22q-2.075 0-3.9-.788t-3.175-2.137T2.788 15.9T2 12t.788-3.9t2.137-3.175T8.1 2.788T12 2t3.9.788t3.175 2.137T21.213 8.1T22 12t-.788 3.9t-2.137 3.175t-3.175 2.138T12 22"/></svg>`)
	SettingIcon              = NewWoxImageSvg(`<svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="48" height="48" viewBox="0 0 48 48"><circle cx="24" cy="24" r="20" fill="#616161"></circle><path fill="#d1d1d1" d="M34.139,17.887l-0.955,0.265c-0.453,0.126-0.812-0.388-0.539-0.77l0.576-0.807 c0.123-0.2-0.08-0.441-0.298-0.355l-0.838,0.4c-0.443,0.211-0.906-0.251-0.694-0.694l0.4-0.838 c0.086-0.218-0.155-0.421-0.355-0.298l-0.807,0.576c-0.383,0.273-0.896-0.086-0.77-0.539l0.265-0.955 c0.047-0.23-0.226-0.387-0.401-0.232l-0.695,0.707c-0.329,0.335-0.897,0.07-0.852-0.397l0.095-0.987 c0.006-0.235-0.29-0.342-0.436-0.159l-0.562,0.817c-0.266,0.387-0.871,0.225-0.908-0.243l-0.078-0.988 c-0.034-0.232-0.345-0.287-0.456-0.08l-0.411,0.902c-0.195,0.428-0.819,0.373-0.937-0.082l-0.248-0.96 c-0.074-0.223-0.389-0.223-0.463,0l-0.248,0.96c-0.118,0.455-0.742,0.51-0.937,0.082l-0.411-0.902 c-0.112-0.206-0.422-0.152-0.456,0.08l-0.078,0.988c-0.037,0.469-0.642,0.631-0.908,0.243l-0.562-0.817 c-0.146-0.184-0.442-0.076-0.436,0.158l0.095,0.987c0.045,0.468-0.523,0.733-0.852,0.397l-0.695-0.707 c-0.176-0.156-0.448,0.002-0.401,0.232l0.265,0.955c0.126,0.453-0.388,0.812-0.77,0.539l-0.807-0.576 c-0.2-0.123-0.441,0.08-0.355,0.298l0.427,0.895c0.202,0.424-0.241,0.867-0.665,0.665l-0.895-0.427 c-0.218-0.086-0.421,0.155-0.298,0.355l0.576,0.807c0.273,0.383-0.086,0.896-0.539,0.77l-0.955-0.265 c-0.23-0.047-0.387,0.226-0.232,0.401l0.707,0.695c0.335,0.329,0.07,0.897-0.397,0.852l-0.987-0.095 c-0.235-0.006-0.342,0.29-0.159,0.435l0.817,0.562c0.387,0.266,0.225,0.871-0.243,0.908l-0.988,0.078 c-0.232,0.034-0.287,0.345-0.08,0.456l0.902,0.411c0.428,0.195,0.373,0.819-0.082,0.937l-0.96,0.248 c-0.223,0.074-0.223,0.389,0,0.463l0.96,0.248c0.455,0.118,0.51,0.742,0.082,0.937l-0.902,0.411 c-0.206,0.112-0.152,0.422,0.08,0.456l0.988,0.078c0.469,0.037,0.631,0.642,0.243,0.908l-0.817,0.562 c-0.184,0.146-0.076,0.442,0.158,0.436l0.987-0.095c0.468-0.045,0.733,0.523,0.397,0.852l-0.707,0.695 c-0.156,0.176,0.002,0.448,0.232,0.401l0.955-0.265c0.453-0.126,0.812,0.388,0.539,0.77l-0.576,0.807 c-0.123,0.2,0.08,0.441,0.298,0.355l0.895-0.427c0.424-0.202,0.867,0.241,0.665,0.665l-0.427,0.895 c-0.086,0.218,0.155,0.421,0.355,0.298l0.807-0.576c0.383-0.273,0.896,0.086,0.77,0.539l-0.265,0.956 c-0.047,0.23,0.226,0.387,0.401,0.232l0.695-0.707c0.329-0.335,0.897-0.07,0.852,0.397l-0.095,0.987 c-0.006,0.235,0.29,0.342,0.436,0.159l0.562-0.817c0.266-0.387,0.871-0.225,0.908,0.243l0.078,0.988 c0.034,0.232,0.345,0.287,0.456,0.08l0.411-0.902c0.195-0.428,0.819-0.373,0.937,0.082l0.248,0.96 c0.074,0.223,0.389,0.223,0.463,0l0.248-0.96c0.118-0.455,0.742-0.51,0.937-0.082l0.411,0.902c0.112,0.206,0.422,0.152,0.456-0.08 l0.078-0.988c0.037-0.469,0.642-0.631,0.908-0.243l0.562,0.817c0.146,0.184,0.442,0.076,0.436-0.158l-0.095-0.987 c-0.045-0.468,0.523-0.733,0.852-0.397l0.695,0.707c0.176,0.156,0.448-0.002,0.401-0.232l-0.265-0.956 c-0.126-0.453,0.388-0.812,0.77-0.539l0.807,0.576c0.2,0.123,0.441-0.08,0.355-0.298l-0.427-0.895 c-0.202-0.424,0.241-0.867,0.665-0.665l0.895,0.427c0.218,0.086,0.421-0.155,0.298-0.355l-0.576-0.807 c-0.273-0.383,0.086-0.896,0.539-0.77l0.955,0.265c0.23,0.047,0.387-0.226,0.232-0.401l-0.707-0.695 c-0.335-0.329-0.07-0.897,0.397-0.852l0.987,0.095c0.235,0.006,0.342-0.29,0.159-0.436l-0.817-0.562 c-0.387-0.266-0.225-0.871,0.243-0.908l0.988-0.078c0.232-0.034,0.287-0.345,0.08-0.456l-0.902-0.411 c-0.428-0.195-0.373-0.819,0.082-0.937l0.96-0.248c0.223-0.074,0.223-0.389,0-0.463l-0.96-0.248 c-0.455-0.118-0.51-0.742-0.082-0.937l0.902-0.411c0.206-0.112,0.152-0.422-0.08-0.456l-1.054-0.083 c-0.447-0.035-0.601-0.612-0.232-0.866l0.871-0.599c0.184-0.146,0.076-0.442-0.158-0.436l-0.987,0.095 c-0.468,0.045-0.733-0.523-0.397-0.852l0.707-0.695C34.527,18.113,34.369,17.84,34.139,17.887z M23.496,23.135 c0.48-0.277,1.093-0.113,1.37,0.367c0.277,0.48,0.113,1.093-0.367,1.37c-0.48,0.277-1.093,0.113-1.37-0.367 C22.852,24.025,23.016,23.412,23.496,23.135z M17.477,30.691c-0.601-0.582-1.133-1.254-1.572-2.015 c-2.181-3.778-1.418-8.441,1.57-11.352c0.616-0.6,1.642-0.438,2.073,0.307l3.022,5.234c0.407,0.705,0.407,1.573,0,2.277 l-3.024,5.237C19.116,31.123,18.094,31.288,17.477,30.691z M33.047,26.328c-0.603,2.348-2.113,4.46-4.378,5.768 c-2.265,1.308-4.849,1.559-7.184,0.907c-0.835-0.233-1.218-1.204-0.785-1.955l2.797-4.845c0.547-0.948,1.559-1.532,2.653-1.532 l5.595,0C32.613,24.671,33.263,25.488,33.047,26.328z M33.049,21.701c0.209,0.833-0.445,1.635-1.304,1.635l-6.047,0 c-0.814,0-1.565-0.434-1.972-1.139l-3.022-5.234c-0.43-0.745-0.058-1.715,0.77-1.949c4.015-1.132,8.435,0.538,10.616,4.317 C32.529,20.092,32.845,20.889,33.049,21.701z"></path><path fill="#bdbdbd" d="M39.191,14.837l-1.431,0.397c-0.679,0.188-1.217-0.581-0.808-1.154l0.863-1.209 c0.184-0.3-0.119-0.661-0.446-0.532l-1.256,0.599c-0.664,0.317-1.357-0.377-1.04-1.041l0.599-1.256 c0.129-0.327-0.232-0.63-0.532-0.446l-1.21,0.863c-0.573,0.409-1.342-0.13-1.154-0.808l0.397-1.432 c0.07-0.345-0.338-0.581-0.601-0.347l-1.041,1.06c-0.494,0.502-1.344,0.106-1.277-0.595l0.142-1.479 c0.01-0.352-0.434-0.513-0.653-0.237L28.9,8.442c-0.399,0.58-1.306,0.337-1.361-0.365l-0.117-1.481 c-0.052-0.348-0.516-0.43-0.684-0.121l-0.616,1.352c-0.292,0.641-1.227,0.559-1.403-0.123l-0.372-1.438 c-0.111-0.334-0.583-0.334-0.694,0l-0.372,1.438c-0.176,0.682-1.111,0.764-1.403,0.123l-0.616-1.352 c-0.167-0.309-0.632-0.227-0.684,0.121l-0.117,1.481C20.405,8.78,19.499,9.023,19.1,8.442l-0.841-1.224 c-0.219-0.276-0.662-0.114-0.653,0.237l0.142,1.479c0.067,0.701-0.783,1.098-1.277,0.595L15.43,8.47 c-0.263-0.233-0.672,0.003-0.601,0.347l0.397,1.432c0.188,0.678-0.581,1.217-1.154,0.808l-1.209-0.863 c-0.3-0.184-0.661,0.119-0.532,0.446l0.639,1.341c0.303,0.636-0.361,1.299-0.996,0.996l-1.341-0.639 c-0.327-0.129-0.63,0.232-0.446,0.532l0.863,1.21c0.409,0.573-0.13,1.342-0.808,1.154l-1.432-0.397 c-0.345-0.07-0.581,0.338-0.347,0.601l1.059,1.041c0.502,0.494,0.106,1.344-0.595,1.277l-1.479-0.142 c-0.352-0.01-0.513,0.434-0.238,0.652l1.224,0.841c0.58,0.399,0.337,1.306-0.365,1.361l-1.481,0.117 c-0.348,0.052-0.43,0.516-0.121,0.684l1.352,0.616c0.641,0.292,0.559,1.227-0.123,1.403l-1.438,0.372 c-0.334,0.111-0.334,0.583,0,0.694l1.438,0.372c0.682,0.176,0.764,1.111,0.123,1.403l-1.352,0.616 c-0.309,0.167-0.227,0.632,0.121,0.684l1.481,0.117c0.702,0.055,0.945,0.962,0.365,1.361L7.21,29.75 c-0.276,0.219-0.114,0.662,0.237,0.653l1.479-0.142c0.701-0.067,1.098,0.783,0.595,1.277l-1.059,1.041 c-0.233,0.263,0.003,0.672,0.347,0.601l1.431-0.397c0.679-0.188,1.217,0.581,0.808,1.154l-0.863,1.209 c-0.184,0.3,0.119,0.661,0.446,0.532l1.341-0.639c0.636-0.303,1.299,0.361,0.996,0.996l-0.639,1.341 c-0.129,0.327,0.232,0.63,0.532,0.446l1.209-0.863c0.573-0.409,1.342,0.13,1.154,0.808l-0.397,1.432 c-0.071,0.345,0.338,0.581,0.601,0.347l1.041-1.06c0.494-0.502,1.344-0.106,1.277,0.595l-0.142,1.479 c-0.01,0.352,0.434,0.513,0.653,0.237l0.841-1.224c0.399-0.58,1.306-0.337,1.361,0.365l0.117,1.481 c0.052,0.348,0.516,0.43,0.684,0.121l0.616-1.352c0.292-0.641,1.227-0.559,1.403,0.123l0.372,1.438 c0.111,0.334,0.583,0.334,0.694,0l0.372-1.438c0.176-0.682,1.111-0.763,1.403-0.123l0.616,1.352 c0.168,0.309,0.632,0.227,0.684-0.121l0.117-1.481c0.055-0.702,0.962-0.945,1.361-0.365l0.842,1.224 c0.219,0.276,0.662,0.114,0.653-0.237l-0.142-1.479c-0.067-0.701,0.783-1.098,1.277-0.595l1.041,1.06 c0.263,0.233,0.672-0.003,0.601-0.347l-0.397-1.432c-0.188-0.678,0.581-1.217,1.154-0.808l1.21,0.863 c0.3,0.184,0.661-0.119,0.532-0.446l-0.639-1.341c-0.303-0.636,0.361-1.299,0.996-0.996l1.341,0.639 c0.327,0.129,0.63-0.232,0.446-0.532l-0.863-1.21c-0.409-0.573,0.13-1.342,0.808-1.154l1.432,0.397 c0.345,0.07,0.581-0.338,0.347-0.601l-1.06-1.041c-0.502-0.494-0.105-1.344,0.595-1.277l1.479,0.142 c0.352,0.01,0.513-0.434,0.237-0.653l-1.224-0.842c-0.58-0.399-0.337-1.306,0.365-1.361l1.481-0.117 c0.348-0.052,0.43-0.516,0.121-0.684l-1.352-0.616c-0.641-0.292-0.559-1.227,0.123-1.403l1.438-0.372 c0.334-0.111,0.334-0.583,0-0.694l-1.438-0.372c-0.682-0.176-0.764-1.111-0.123-1.403l1.352-0.616 c0.309-0.167,0.227-0.632-0.121-0.684l-1.579-0.124c-0.669-0.053-0.901-0.917-0.348-1.297l1.306-0.897 c0.276-0.219,0.114-0.662-0.237-0.653l-1.479,0.142c-0.701,0.067-1.098-0.783-0.595-1.277l1.06-1.041 C39.771,15.175,39.536,14.766,39.191,14.837z M23.496,23.135c0.478-0.276,1.09-0.112,1.366,0.366 c0.276,0.478,0.112,1.09-0.366,1.366s-1.09,0.112-1.366-0.366C22.854,24.023,23.018,23.411,23.496,23.135z M14.227,34.02 c-0.9-0.872-1.698-1.879-2.356-3.019c-3.268-5.661-2.125-12.647,2.352-17.009c0.924-0.9,2.461-0.656,3.105,0.461l4.528,7.842 c0.61,1.056,0.61,2.356,0,3.412l-4.53,7.847C16.683,34.668,15.151,34.915,14.227,34.02z M37.555,27.484 c-0.903,3.517-3.165,6.683-6.559,8.642s-7.266,2.336-10.763,1.359c-1.251-0.349-1.825-1.804-1.176-2.929l4.191-7.259 c0.82-1.42,2.335-2.295,3.975-2.295l8.383,0C36.905,25.001,37.878,26.225,37.555,27.484z M37.557,20.551 c0.313,1.247-0.667,2.45-1.953,2.45l-9.06,0c-1.219,0-2.346-0.65-2.955-1.706l-4.528-7.842c-0.645-1.117-0.087-2.57,1.154-2.919 c6.016-1.697,12.637,0.806,15.906,6.468C36.778,18.141,37.252,19.335,37.557,20.551z"></path></svg>`)
	ChromeIcon               = NewWoxImageBase64(`data:image/png;base64,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`)
	LockIcon                 = NewWoxImageBase64(`data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAACXBIWXMAAAsTAAALEwEAmpwYAAABzElEQVR4nO2Yv0oDQRDGPwQrfQMt1VY0oHZ3MyGtNnkOIX0gnX+4tfDPG2gj4nPYmFqxSaOdARMF4x64MnhoXDVG73KXM/vBwLHswPfbmdnjDnByckpMhUJhnJnLRHTEzBdE9MDM99GzrJVlD4ZRvu+vEdEVM5teIXtkL4ZFtVptjJk3fzJuxTMzb0hu1v7xB/PdsZGpeWmF6DS7W6TDzHu+7y+XSqUJCc/zVohon4ie7EoQ0Wom5mUY7Z4nomsimv8up1gsLhDRjT0ThSwGW24U++R7me/KW/yiEmWkreha7Dax+4vcAwv+EGmLmS8tgKV+c2UmrNxLpK3oBfVmwvO8yX5zZa8FcI+0ZV+JaefHlgNgV4H+ZbYwrRVOtEI7VDCDDK3Q1gqnnW3MJmc+QHPQxkMbJEDT7GAqNoCcfNrmw/dqHCcB0M4Q4C42QFbmwygcQOgqANdCsTSSLaQVTKMKc16BqVden3WeABpVmLP1jyFruQE4r3wGkLXcANS/AKjnCaCR9xbSEUQ9r0McJhhwAMpVwLgWGukW0gFauf6k1AqnGQKcxAboKMxphdvUzQdoPu5gBklI/s/IL4402kkHaMnJJ2beyemf6wXITRX/xbt3RgAAAABJRU5ErkJggg==`)
	TrashIcon                = NewWoxImageBase64(`data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAACXBIWXMAAAsTAAALEwEAmpwYAAABKklEQVR4nO2XMW7CMBiFfY+uFXcpc+kJuEAr/1FHhiKxN1YXzI4QS0J3DhCrnQkTrEWCExglVRYUA5LzGxG9T3rK8GTpf/bL8AsBAACtQZEZKDL2nGKZjcS9Dq9uFSKdrLuJzrepzm0IJTrfJnr91FiAkMOnlcarTWMBgg+v/4UAp1z7k/pKcIEAhBfwo3UV+ugvbfTybYf9pa3zqLco5fIjx9lgAYrh5HNafl3eJZ9qvGABqgELnfMu+QoBrgQvQKiQH6gQoUJ+oEKECvmBChEq5AcqRKiQH62rEN37SjksF/NFuaDXedVS7/Ijx9lgAbgkGAMcuIePpdmzBYhlNmd/AZnN2AJ8vv12lDR/bLdPZhe/m0fBydfrz4MiM224Tofi5tmHB6CFHAGn3ZbcU2hBbwAAAABJRU5ErkJggg==`)
	ExitIcon                 = NewWoxImageBase64(`data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAACXBIWXMAAAsTAAALEwEAmpwYAAABgklEQVR4nO2ZTU7DQAyF5zYgxE0AET+pJ0KVOEA5DtDTIFhCu+i8LkBTdVFVpfMTTxzCWLKajSt/85yxIzvXrFmzItt03b0Hll5kTeDb0r3I2ou8boC7LAgPPFonz9+ggHmyEtbJMuLbrrtNUWNpnSjjpfYSBxFZWSfKeHl9RUGsk2SiNxCOQAU2RWB/8myKIPsqfPLAe+nJhtjwH6aKeGCxmwZms6sSmBATYveNeGEJ8uFFrvcwFx54K4oFLnNiWaOPlMD0hWCthpgDowHBmp09BUYLgrVHlHMwmhAcYtY6BaMNwaGGxsNrNfwePvfpORwa5FgZTSVoDpLZZzgGkEmUlj/xYveZAGgBcu520oZxtUBSrlhNGFcDJKdPaME4bZCSZqcB4zRB+nTsvjBOGWQaH1acyqcuDd01ENirwKYI7E+e/14R/xcWPSKf0VsrbE9HDwI8R0HCCtg6UUZ8K3ITBdmpAsxHXFYPLsfCCjhsT8fwzniRVSinZCWaNWvmju0Hs8M8e1QllsgAAAAASUVORK5CYII=`)
	WoxIcon                  = NewWoxImageBase64(`data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAMAAACdt4HsAAAAclBMVEUAAAD///////////////////////////////////////////////////8AAAARERHNzc3x8fHCwsLh4eF4eHg0NDQmJiY/Pz9XV1cdHR34+PiysrKdnZ3Y2NiTk5Po6OhtbW2FhYViYmJLS0u6urqpqalzyZ7dAAAADXRSTlMAHt/ScPjnvolJNrFbjqNo5gAAAkhJREFUWMO1l+ly4jAQhB3AJCQ7yCc2lg988P6vuLu2pNbumHLCJP2HQow+z3SrCiswejl87EL6pMLj6+Fl3obte/qidm8e4v2VntD+ZPefdvSUjr/M87H/q4TTPL/r/4kp/vpwIIHe/jSwlwCO76YBQQsfMsA+2MkAYRCSTAF9F6CKklkdQd2ylBIUJ4tiBqjVeVZZkWOWy1LhQbPzoowBWvPLtXHFjTJrExrIzdKNASJbfXfV97NRT4+rAsbOXPXNAsbKDWr7TB2AlRcVkKx8AJIBNExAu0b6f2ZLHJBeUI12MZbPVNEKgEpUo12M5TPzeA3QohrtYizDRIgAoD9U4ytSA1OvAuICP6MhPBLMS8oB/JgOPqCIfQtKWgdoP+Tu4gNU4x+VlgFckDg3idl5XT5rYwFCBIAHqWHBeIMJkcI8PoAH2QPWayRfw6NVAB4xVm6cKb2atmGBZgAE6UyYbGDVaE2IC7vGACxITb0JzK0N1Ci39hCgnQmjc8OZcHchMgALcmxMegmRNSHJXIgMwIK8tOazI6psMwVCZAAWZO6N25slhRAZgAXpjbsEAk0MsBYkxoUxmIoBeJA4fjAGUzEAD9JmT8YEqN4AoF8UJ2wqDoBKXtwBihAfAmpmAaAIkQFWg7zhdCDETQCCxB9oohDiJgBB4o++y5HLNmBa8WtALpsAeJ5xZ1XzGABlatbV86vJl7Wh+gwgjmb987B0WYt/4jUvFALEr7ril23x6774wiG98ogvXdJrn/jiKb/6yi/f4uv/b4RD2ZgRa71/AAAAAElFTkSuQmCC`)
	CPUProfileIcon           = NewWoxImageBase64(`data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGAAAABgCAYAAADimHc4AAAACXBIWXMAAAsTAAALEwEAmpwYAAACvUlEQVR4nO2cPW4UQRCFO4Gz8BM6GBNAOrKndruE5CsgxFXAixGJyRwQIdQNIXAMm4MAzoxUqDbjx6zk1eyrmX6fVOFqe96rqp6eGVVKhBBCCCGEEDIydprsf5GC/37yoAU0GkADoKAz2FgBNAAKOoONFUADoKAz2OZeAYuPi/tS9OVQ9EKKXkpVm3QUvfRrGYqulh+W91JUjt4d3ZaaXw81/4SLVscJv7ah5ld7b57cSuHEL/oFLZDszojPoUzwzEeLIjuPfJKi9Pw5tx25LopeHRa9GyH7T+BiVEwMNR+j9U9D0a9oIQQW+Rytfxpq/tFsBRT9jtY/oUUQcKD1pwFo0BkorAC8CDLnFrTp4RVaAAHH6A/3aIDSAAmQ6ayAihebLajiBeceUGPFpDfhw7dqj55l25dsXb/b8P98+FTt4Cy3aYCLv7/cvfB/GbHM67WENWATN124Z37Xxwhfy02vY3SBxzIA0Xa666pg0aABaNG7P4IG9DSAFVDZgowtiHuAcRPuuQmPfhCby12QTfUkjBa8owF40VkBPV54tqA+RnAP6GkAN+HKuyBjC+JJ2HgS7qezCSc0rR/EEhoaAIYGgKEBEzXAX4R3fYxo8qW8fxTVBRA//GcpYz2OPjhTe5BjfJjla2nuWdBvnyYuMG3H/3sb8SdvgMwgaEClAfAsFFYAXghhC8KLIYDgHlBnbsAm0AIIOEYXmAYoDZAAmc4KqHixQ7YgH1qEFkFQUfRbBAMu4ELUlkeWFV3hhVBIDEWfo/VPPs631bGV8v7xnRQBH+fbYPavUhR8jK+P821G/Jo/hRpd7PiC1kNcvTQDiCRjRNErz/xw4v9jTzj2O4Q5zBQd1teQz6XoixCjirdl24dXBv795EELaDSABkBBZ7CxAmgAFHQGGyuABkBBZ7C1XgGEEEIIIYSQhOYXgxYY872M2ekAAAAASUVORK5CYII=`)
	SearchIcon               = NewWoxImageSvg(`<svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24"><path fill="#5da3ef" d="M15.5 14h-.79l-.28-.27A6.47 6.47 0 0 0 16 9.5A6.5 6.5 0 1 0 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5S14 7.01 14 9.5S11.99 14 9.5 14"/></svg>`)
	GoogleIcon               = NewWoxImageBase64(`data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAACXBIWXMAAAsTAAALEwEAmpwYAAAEkUlEQVR4nO2Zb0wbZRzHn3taesUtRpOJYbo/DoQM5c/GMgryzxkYxbGBiQsbNBCEFGaIY8zCCuaUMSiQAQMGQWAgcSY2GeuNuzpc8NqNvRoCItE3841Dthj3ToNzbX+mVRBI197Zo2VJv8n3XZ+nn89dn6dPrwj5448/HgcoJIWqgGIoxywU4HuQTfwJSsIKBxBAKgJIQzbIJhZBhX+BE/g6VAUU2ccgXwc0UgWU4tvwNmGBJASCqiQsoMa3QRsQ433wOlk4qPEsvCkQ2llTEUAxnoEaFOIdeA3RCumEzWPwtT2IrHCK0K0f+HkUCMX4B9HBk9b0PTwNFJKJC9+NngcVfrDu8En/toJoFw9+EMnhOPGr1+DLCE40eIeAGn/vPXgsMvyHRIfgrbEMT0IlroUmaQpQaAtQKAjOSN6C05hy7Db21zgbW4pN4sI3kyGQQVh5g5+W9PJZfEChZ+ADydAqkVKR4R1vVIHv8IIvwPNwDr0oeP4aFAJ5+P76wJvl22CcfAQaCUCyC/gSPAV6JEEbLWAmdWAmwdHeAIB0wvmV35DweiQBs2x+WcDeURmACv8Hn0lYoAK9hDZiwCSPXwW/VI4E0En/ObuclPSjjRowybROBZY6FPAAyhGJNmrATF5xKWCSdQiZL1gzC2I0XDthO9rUd9e9gImccynAkRm+EAjWzMIbddcW+Qg8dCMQ6iuB3TW3rHwEHrkWQJt9JbCjehKeaoHtVd+C5x+hm7IwXwns1t60Pd2L+JNRHovYTI642UY7fSVwRDc8z0NAduZJ8A+5Z6Geif/jvF4RiEROy3D+puiPvrG4Eii/0DjqXoALVDiDnx0PBhWthENXs6HDGHtJbIGTnfX97u6Arq/iuHsBQBjMsntL4DYzCfRYOGQbDjvg7c2jlZaL11/bJhZ8W496Z2SNyeoK/vVas4XiKH5P88BENtrhfzdthrNMwjL4ylaPJi9wXIrHjwcpjpIeafxswd3VL2lrm+A9KXCBL98df+GvEjrdKfxSP2YTZjyRoDhKmt/SM+d2/6+egsbuylhBkzcwihlX8CvvRP/X4VuFwvfeiNhe1lX3E5/d51hz75zQ+RE9FvZKPq208pHIp5WWzq/2DlCDKXJ38w6PRW1qZ/b15RmU1pyRHDja2uH2FEp9ekrQl+dyutmY1iweAitFGljFdJdxL6VnIw5cGdsVdJkL2zJgjEq8aNxTV8ckTNpfs3JM1kgOFPZQsLXqO6cC77c3dSNPomPjpvkKeNKiwXLYWX1nFfy7TQM/Ik+j10fINHTqfW9IFH5RCJG1Jgd8ev2Xv53o6hJ0cHxiOG7HczVM4oI3JI7pc0HVemGeGq4MEgV+hYT8LBM/K2RN/J+eYxXTRmPo+v3m7jNGNecaMq2iX3lDprWXjWlG3sgwvSe0gY2beseQ5TF4ztXDjqt++caru5C3MzQWGdvM7L9VZDj4WCh4AZ3xuJGJm/icifb+n3xrowck6WeiC1uN+0a1TOLPajptUWVQWu13yH4IzDVk2tSGtMWqa8nzLex+ts8YU2Afg/zxxx/kaf4GzSVnCicBYF0AAAAASUVORK5CYII=`)
)
