import { ThunkAction } from 'redux-thunk'

import { State as BookmarkBtnState } from './bookmark-button/reducer'
import { State as CollectionsBtnState } from './collections-button/reducer'
import { State as PauseBtnState } from './pause-button/reducer'
import { State as NotifsBtnState } from './notif-button/reducer'
import { State as SidebarBtnState } from './sidebar-button/reducer'
import { State as RibbonBtnState } from './sidebar-open-button/reducer'
import { State as TooltipBtnState } from './tooltip-button/reducer'
import { State as PopupState } from './reducer'
import type { Props as ActivityIndicatorProps } from 'src/activity-indicator/ui'

export interface RootState {
    bookmarkBtn?: BookmarkBtnState
    collectionsBtn: CollectionsBtnState
    pauseBtn?: PauseBtnState
    sidebarBtn?: SidebarBtnState
    sidebarOpenBtn?: RibbonBtnState
    tooltipBtn?: TooltipBtnState
    notifsBtn?: NotifsBtnState
    popup?: PopupState
    activityIndicator: ActivityIndicatorProps
}

export type ClickHandler<T extends HTMLElement> = (
    e: React.SyntheticEvent<T>,
) => void

export type Thunk<R = void> = ThunkAction<R, RootState, void, any>
