import type { Anchor } from 'src/highlighting/types'
import type {
    SharedAnnotation,
    SharedAnnotationReference,
} from '@worldbrain/memex-common/lib/content-sharing/types'
import type { UserReference } from '@worldbrain/memex-common/lib/web-interface/types/users'
import type { UserPublicDetails } from '@worldbrain/memex-common/lib/user-management/types'
import type { RGBAColor } from './cache/types'
import { HighlightColor } from '@worldbrain/memex-common/lib/common-ui/components/highlightColorPicker/types'

// export interface Annotation {
//     /** Unique URL for this annotation. Used as more of an ID; probably not for display. */
//     url: string
//     /** URL for display. */
//     pageUrl: string
//     /** Defined for annotations with highlighted text. */
//     body?: string
//     /** Defined for annotations with a user comment. */
//     comment?: string
//     /** Selector required for highlighting annotations. */
//     selector?: Anchor
//     createdWhen: number
//     lastEdited: number
//     tags: string[]
//     hasBookmark?: boolean
// }

export interface Annotation {
    url: string
    pageTitle?: string
    pageUrl: string
    body?: string
    selector?: Anchor
    createdWhen?: Date
    lastEdited?: Date
    comment?: string
    color?: HighlightColor['id']
    _body_terms?: string[]
    _comment_terms?: string[]
    tags?: string[]
    lists?: number[]
    isShared?: boolean
    isBookmarked?: boolean
    isSocialPost?: boolean
    isBulkShareProtected?: boolean
    userId?: string
}

export interface NewAnnotationOptions {
    anchor?: Anchor
    text: string
    tags: string[]
    isBookmarked?: boolean
}

export interface AnnotationsManagerInterface {
    createAnnotation(input: {
        pageUrl: string
        pageTitle: string
        body: string
        comment: string
        anchor: Anchor
        tags: string[]
        lists: number[]
        bookmarked?: boolean
        isSocialPost?: boolean
        color?: RGBAColor | string
    }): Promise<Annotation>
    fetchAnnotationsWithTags(
        url: string,
        // limit = 10,
        // skip = 0,
        isSocialPost?: boolean,
    ): Promise<Annotation[]>
}

export interface SidebarAnnotationTheme {
    hasHighlight: boolean
    hasComment: boolean
    isEditing: boolean
    isActive: boolean
    cursor: 'pointer' | 'auto'
}

export interface AnnotListEntry {
    listId: number
    url: string
}

export interface AnnotationRequest {
    memexLinkOrigin: string
    // urlWithoutProtocol: string
    annotationId: string
    tabId: string
}

interface StoredAnnotationRequest extends AnnotationRequest {
    annotationPromise: Promise<Annotation>
}

export interface StoredAnnotationRequestMap {
    [tabId: string]: StoredAnnotationRequest
}

export type TextTruncator = (
    text: string,
    opts?: { maxLength?: number; maxLineBreaks?: number },
) => { text: string; isTooLong: boolean }

export type SelectionIndices = [number, number]

export type ListDetailsGetter = (
    id: number,
) => {
    name: string | JSX.Element
    isShared: boolean
    description?: string
    type: 'page-link' | 'user-list' | 'special-list'
}

export type SharedAnnotationWithRefs = SharedAnnotation & {
    reference: SharedAnnotationReference
    creatorReference: UserReference
    creator?: UserPublicDetails
    selector?: Anchor
    color?: RGBAColor | string
}
