# Local Storage Keys

Naming conventions for storage keys have varied over time, however, any new keys should be in
`kebab-case`.

|                Key Name                | Value Type       | Purpose                                                                                                                                                                                                                                             |
| :------------------------------------: | ---------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
|     **Page indexing preferences**      |                  |                                                                                                                                                                                                                                                     |
|         `visit-indexing-delay`         | `number`         | Number of seconds to wait before performing page indexing.                                                                                                                                                                                          |
|         `should-index-visits`          | `boolean`        | Denotes whether or not the full page text should be indexed after `visit-indexing-delay`.                                                                                                                                                           |
|          `should-index-stubs`          | `boolean`        | Denotes whether or not page stubs (title, URL) should be indexed immediately on page visit.                                                                                                                                                         |
|          `should-index-links`          | `boolean`        | Denotes whether or not creating a Memex.link should also invoke page indexing.                                                                                                                                                                      |
|        `should-index-bookmarks`        | `boolean`        | Denotes whether or not creating a bookmark should also invoke page indexing.                                                                                                                                                                        |
|             **Onboarding**             |                  |                                                                                                                                                                                                                                                     |
|      `onboarding-import-progress`      | `number`         | Total count of pages processed during the onboarding imports process.                                                                                                                                                                               |
|          `is-onboarding-done`          | `boolean`        | Denotes whether or not onboarding process has been finished.                                                                                                                                                                                        |
|          **Tooltips feature**          |                  |                                                                                                                                                                                                                                                     |
|      `is-overview-tooltips-shown`      | `boolean`        | Denotes whether or not tooltips should be shown in the overview.                                                                                                                                                                                    |
|          `overview-tooltips`           | `any`            | An object containing the current tooltip for display in the overview.                                                                                                                                                                               |
|            `tooltip_index`             | `number`         | Index of the current tooltip shown in overview.                                                                                                                                                                                                     |
|             **Analytics**              |                  |                                                                                                                                                                                                                                                     |
|        `should-track-analytics`        | `boolean`        | Denotes whether or not user analytics will be tracked and sent to the server.                                                                                                                                                                       |
|               `user-id`                | `string`         | UUID used to uniquely identify user for analytics.                                                                                                                                                                                                  |
|  `last-daily-activity-ping-timestamp`  | `number`         | Epoch timestamp used for activity analytics.                                                                                                                                                                                                        |
| `last-weekly-activity-ping-timestamp`  | `number`         | Epoch timestamp used for activity analytics.                                                                                                                                                                                                        |
| `last-monthly-activity-ping-timestamp` | `number`         | Epoch timestamp used for activity analytics.                                                                                                                                                                                                        |
|  `last-daily-install-ping-timestamp`   | `number`         | Epoch timestamp used for activity analytics.                                                                                                                                                                                                        |
|  `last-weekly-install-ping-timestamp`  | `number`         | Epoch timestamp used for activity analytics.                                                                                                                                                                                                        |
| `last-monthly-install-ping-timestamp`  | `number`         | Epoch timestamp used for activity analytics.                                                                                                                                                                                                        |
|        `last-search-timestamp`         | `number`         | Epoch timestamp used for activity analytics.                                                                                                                                                                                                        |
|        `last-search-timestamp`         | `number`         | Epoch timestamp used for activity analytics.                                                                                                                                                                                                        |
|     **History/Bookmarks Imports**      |                  |                                                                                                                                                                                                                                                     |
|        `is-imports-in-progress`        | `boolean`        | Denotes whether or not imports is currently running.                                                                                                                                                                                                |
|    `import_success_progress_state`     | `any`            | Contains counts for successfully imported bookmarks and history items in the current import process.                                                                                                                                                |
|      `import_fail_progress_state`      | `any`            | Contains counts for failed imported bookmarks and history items in the current import process.                                                                                                                                                      |
|           `import_progress`            | `Array<any>`     | Contains the states of completed import items. **Currently unused/disabled.**                                                                                                                                                                       |
|         `import_totals_state`          | `any`            | Contains total counts for bookmark and history import items.                                                                                                                                                                                        |
|        `import-estimate-counts`        | `any`            | Object holding the calculated `completed` and `remaining` counts for history and bookmark import items (derived from web ext APIs). Also contains a `calculatedAt` epoch timestamp field to determine when state needs recalculation in the future. |
|             `allow_types`              | `any`            | Holds `boolean` values to denote whether bookmark and history import items are allowed in the current imports process.                                                                                                                              |
|            `import-items-*`            | `any`            | Holds a chunk of import items. Will be named according to the chunk in overall sequence. e.g., `import-items-1`. Also contains a `type` field to denote if items are bookmarks or history items.                                                    |
|          `err-import-items-*`          | `any`            | Similar to the `import-items-*` chunks but for failed items to afford easy retrying at a later stage.                                                                                                                                               |
|          `import-items-state`          | `Array<string>`  | Reverse index pointing back to all the `import-items-*` keys.                                                                                                                                                                                       |
|        `import-err-items-state`        | `Array<string>`  | Reverse index pointing back to all the `err-import-items-*` keys.                                                                                                                                                                                   |
|      **Search engine injection**       |                  |                                                                                                                                                                                                                                                     |
|           `SEARCH_INJECTION`           | `any`            | Object holding `boolean` values for each supported search engine we inject Memex results into.                                                                                                                                                      |
|          `RESULTS_POSITION_`           | `'side'|'above'` | Denotes where search engine injection UI should appear relative to search engine UI.                                                                                                                                                                |
|           **Misc. features**           |                  |                                                                                                                                                                                                                                                     |
|              `blacklist`               | `string`         | Serialized JS array holding blacklisted patterns to match against webpage URLs.                                                                                                                                                                     |
|          `is-logging-paused`           | `number`         | Denotes if ext indexing is paused or not. `0` is paused infinitely, `1` is paused with a timeout, `2` is unpaused.                                                                                                                                  |
|          `memex_link_tooltip`          | `boolean`        | Denotes whether or not the tooltip and sidebar should be shown when the user is on any webpage.                                                                                                                                                     |
|              **Internal**              |                  |                                                                                                                                                                                                                                                     |
|          `number-of-searches`          | `number`         | Total count of searches a user has attempted using the extension.                                                                                                                                                                                   |
|        `extension_install_time`        | `number`         | Epoch timestamp denoting when the extension was installed.                                                                                                                                                                                          |
|         **Keyboard Shortcuts**         |                  |                                                                                                                                                                                                                                                     |
|       `memex-keyboardshortcuts`        | `any`            | The state of keyboard settings for the tooltip functions                                                                                                                                                                                            |
|      **Quick & Dirty Migrations**      |                  |                                                                                                                                                                                                                                                     |
|  `annots-created-when-to-last-edited`  | `boolean`        | Denotes whether or not migration has been run                                                                                                                                                                                                       |
