# WorldBrain's Memex

[![Financial Contributors on Open Collective](https://opencollective.com/worldbrain/all/badge.svg?label=financial+contributors)](https://opencollective.com/worldbrain)

## Table Of Content

1. [Memex Features](#memex-features)
1. [Changelog and Roadmap](#changelog--roadmap)
1. [Contributing](#contributing)
    1. [Report Bugs & Feature Requests](#bugs--feature-requests)
    1. [Getting started as a developer](#getting-started-as-a-developer)
1. [License](#license)
1. [Our Funders](#funders)

# Memex Features

A browser extension to eliminate time spent bookmarking, retracing steps to recall an old webpage, or copy-pasting notes into scattered documents.
Its name and functionalities are heavily inspired by [Vannevar Bush's vision of a Memex](http://memex.link/S1zVMgKzX/en.wikipedia.org/wiki/Memex).
<img width="1025" alt="main_screen_new" src="https://user-images.githubusercontent.com/7870039/75159434-0bf63700-5710-11ea-9179-2d49b8810400.png">

## Full-Text Search in Bookmarks:

Search with every word of all websites & PDFs you bookmarked, tagged, listed, or annotated. Filter by time, domain, list, or tags.
![](https://user-images.githubusercontent.com/7870039/75158724-a8b7d500-570e-11ea-9d35-0255cb9ea2da.gif)

## Highlights, Notes & Annotations:

Add notes to websites as a whole and to individual components (e.g. text, images)
![](https://user-images.githubusercontent.com/7870039/75158717-a3f32100-570e-11ea-901d-8241b0710d60.gif)

## Tags, Lists, Bookmarks

Add bookmarks, tags or sort websites into lists on the fly.
![](https://user-images.githubusercontent.com/7870039/75158720-a786a800-570e-11ea-9891-0ef26f7066f3.gif)

## Mobile Apps for iOS & Android + Encrypted Sync

With [Memex Go](https://getmemex.com) you can save & organise content on the go.
Sync is end2end encrypted with [TweetNaCl](https://github.com/dchest/tweetnacl-js)

<img width="1025" alt="mobileSync" src="https://user-images.githubusercontent.com/7870039/75159422-07ca1980-5710-11ea-845e-25f5157bcfd0.png">

## No VC Money, No Exit: Your Data & Attention Stays Yours

Memex is funded without VC money or selling shares. Instead we are funded with a model called "Steward Ownership". This model ensures that the company can never be sold and our investors are rewarded with a capped profit share. This way we will never be tempted by incentivizes to optimise our company for maximising growth and shareholder profits at the expense of your privacy, attention, or freed to choose a provider.
You can find more about our choice [in this post](https://community.worldbrain.io/t/why-worldbrain-io-does-not-take-venture-capital/75).

## Other:

⛅ Backup and restore your data to any of your favorite cloud providers including Google Drive

📲 Import bookmarks and history from other services

⌨ Keyboard Shortcuts for everything

🗂 Tab manager: add all open tabs to a collection or tag

## Changelog & Roadmap:

See a list of our past updates and upcoming features [here](https://www.notion.so/Release-Notes-Roadmap-262a367f7a2a48ff8115d2c71f700c14).

# Contributing

## Near term features where contributions are welcome

⭐️Archiving websites + reader mode + offline-viewing on mobile

⭐️Mobile Annotations

⭐️Support for Brave and Firefox on mobile

⭐️API to import/export your data & integrate with other apps

⭐️Bulk tag, delete, add to lists & bookmark of items

⭐️Nested Collections

Drop by in our [team chat](https://join.slack.com/t/worldbrain/shared_invite/enQtOTcwMjQxNTgyNTE4LTRhYTAzN2QwNmM3ZjQwMGE5MzllZDM3N2E5OTFjY2FmY2JmOTY3ZWJhNGEyNWRiMzU5NTZjMzU0MWJhOTA2ZDA) if you're interested in contributing to those features.
**_Experience in React or React Native & Test Driven Development required_**

## Bugs & Feature Requests

Head over to our [community forums](https://community.worldbrain.io) to post your requests.

## Getting started as a developer

[Click here](./GETTING-STARTED.md#installation) for all instructions on how to build Memex so you can hack on it.

## Contributors

### Code Contributors

This project exists thanks to all the people who contribute. [[Contribute](CONTRIBUTING.md)].

<a href="https://github.com/worldbrain/memex/graphs/contributors"><img src="https://opencollective.com/worldbrain/contributors.svg?width=890&button=false" /></a>

### Financial Contributors

Become a financial contributor and help us sustain our community. [[Contribute](https://opencollective.com/worldbrain/contribute)]

#### Individuals

<a href="https://opencollective.com/worldbrain"><img src="https://opencollective.com/worldbrain/individuals.svg?width=890"></a>

#### Organizations

Support this project with your organization. Your logo will show up here with a link to your website. [[Contribute](https://opencollective.com/worldbrain/contribute)]

<a href="https://opencollective.com/worldbrain/organization/0/website"><img src="https://opencollective.com/worldbrain/organization/0/avatar.svg"></a>

# License

Memex is MIT licensed. View full [License](./License)

# Funders

WorldBrain.io, the company behind Memex, has been funded by a set of courageous investors & grant givers.
See a full & up-to-date list [here](https://www.notion.so/worldbrain/The-Worldbrain-io-Team-9ca5429f6a5c480289386a5cb49f173c#480df7140d124dc68595316dd666fd9a).
