/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.DocumentDescription;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class DocumentDescriptionMarshaller {
    private static final MarshallingInfo<String> SHA1_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Sha1").build();
    private static final MarshallingInfo<String> HASH_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Hash").build();
    private static final MarshallingInfo<String> HASHTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HashType").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> OWNER_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Owner").build();
    private static final MarshallingInfo<Date> CREATEDDATE_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedDate").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> DOCUMENTVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentVersion").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<List> PARAMETERS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").build();
    private static final MarshallingInfo<List> PLATFORMTYPES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlatformTypes").build();
    private static final MarshallingInfo<String> DOCUMENTTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentType").build();
    private static final MarshallingInfo<String> SCHEMAVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SchemaVersion").build();
    private static final MarshallingInfo<String> LATESTVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LatestVersion").build();
    private static final MarshallingInfo<String> DEFAULTVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultVersion").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").build();
    private static final DocumentDescriptionMarshaller instance = new DocumentDescriptionMarshaller();

    public static DocumentDescriptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(DocumentDescription documentDescription, ProtocolMarshaller protocolMarshaller) {
        if (documentDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(documentDescription.getSha1(), SHA1_BINDING);
            protocolMarshaller.marshall(documentDescription.getHash(), HASH_BINDING);
            protocolMarshaller.marshall(documentDescription.getHashType(), HASHTYPE_BINDING);
            protocolMarshaller.marshall(documentDescription.getName(), NAME_BINDING);
            protocolMarshaller.marshall(documentDescription.getOwner(), OWNER_BINDING);
            protocolMarshaller.marshall(documentDescription.getCreatedDate(), CREATEDDATE_BINDING);
            protocolMarshaller.marshall(documentDescription.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(documentDescription.getDocumentVersion(), DOCUMENTVERSION_BINDING);
            protocolMarshaller.marshall(documentDescription.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(documentDescription.getParameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall(documentDescription.getPlatformTypes(), PLATFORMTYPES_BINDING);
            protocolMarshaller.marshall(documentDescription.getDocumentType(), DOCUMENTTYPE_BINDING);
            protocolMarshaller.marshall(documentDescription.getSchemaVersion(), SCHEMAVERSION_BINDING);
            protocolMarshaller.marshall(documentDescription.getLatestVersion(), LATESTVERSION_BINDING);
            protocolMarshaller.marshall(documentDescription.getDefaultVersion(), DEFAULTVERSION_BINDING);
            protocolMarshaller.marshall(documentDescription.getTags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

