/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.logs.AWSLogs;
import com.amazonaws.services.logs.AWSLogsClientBuilder;
import com.amazonaws.services.logs.model.AWSLogsException;
import com.amazonaws.services.logs.model.AssociateKmsKeyRequest;
import com.amazonaws.services.logs.model.AssociateKmsKeyResult;
import com.amazonaws.services.logs.model.CancelExportTaskRequest;
import com.amazonaws.services.logs.model.CancelExportTaskResult;
import com.amazonaws.services.logs.model.CreateExportTaskRequest;
import com.amazonaws.services.logs.model.CreateExportTaskResult;
import com.amazonaws.services.logs.model.CreateLogGroupRequest;
import com.amazonaws.services.logs.model.CreateLogGroupResult;
import com.amazonaws.services.logs.model.CreateLogStreamRequest;
import com.amazonaws.services.logs.model.CreateLogStreamResult;
import com.amazonaws.services.logs.model.DataAlreadyAcceptedException;
import com.amazonaws.services.logs.model.DeleteDestinationRequest;
import com.amazonaws.services.logs.model.DeleteDestinationResult;
import com.amazonaws.services.logs.model.DeleteLogGroupRequest;
import com.amazonaws.services.logs.model.DeleteLogGroupResult;
import com.amazonaws.services.logs.model.DeleteLogStreamRequest;
import com.amazonaws.services.logs.model.DeleteLogStreamResult;
import com.amazonaws.services.logs.model.DeleteMetricFilterRequest;
import com.amazonaws.services.logs.model.DeleteMetricFilterResult;
import com.amazonaws.services.logs.model.DeleteResourcePolicyRequest;
import com.amazonaws.services.logs.model.DeleteResourcePolicyResult;
import com.amazonaws.services.logs.model.DeleteRetentionPolicyRequest;
import com.amazonaws.services.logs.model.DeleteRetentionPolicyResult;
import com.amazonaws.services.logs.model.DeleteSubscriptionFilterRequest;
import com.amazonaws.services.logs.model.DeleteSubscriptionFilterResult;
import com.amazonaws.services.logs.model.DescribeDestinationsRequest;
import com.amazonaws.services.logs.model.DescribeDestinationsResult;
import com.amazonaws.services.logs.model.DescribeExportTasksRequest;
import com.amazonaws.services.logs.model.DescribeExportTasksResult;
import com.amazonaws.services.logs.model.DescribeLogGroupsRequest;
import com.amazonaws.services.logs.model.DescribeLogGroupsResult;
import com.amazonaws.services.logs.model.DescribeLogStreamsRequest;
import com.amazonaws.services.logs.model.DescribeLogStreamsResult;
import com.amazonaws.services.logs.model.DescribeMetricFiltersRequest;
import com.amazonaws.services.logs.model.DescribeMetricFiltersResult;
import com.amazonaws.services.logs.model.DescribeResourcePoliciesRequest;
import com.amazonaws.services.logs.model.DescribeResourcePoliciesResult;
import com.amazonaws.services.logs.model.DescribeSubscriptionFiltersRequest;
import com.amazonaws.services.logs.model.DescribeSubscriptionFiltersResult;
import com.amazonaws.services.logs.model.DisassociateKmsKeyRequest;
import com.amazonaws.services.logs.model.DisassociateKmsKeyResult;
import com.amazonaws.services.logs.model.FilterLogEventsRequest;
import com.amazonaws.services.logs.model.FilterLogEventsResult;
import com.amazonaws.services.logs.model.GetLogEventsRequest;
import com.amazonaws.services.logs.model.GetLogEventsResult;
import com.amazonaws.services.logs.model.InvalidOperationException;
import com.amazonaws.services.logs.model.InvalidParameterException;
import com.amazonaws.services.logs.model.InvalidSequenceTokenException;
import com.amazonaws.services.logs.model.LimitExceededException;
import com.amazonaws.services.logs.model.ListTagsLogGroupRequest;
import com.amazonaws.services.logs.model.ListTagsLogGroupResult;
import com.amazonaws.services.logs.model.OperationAbortedException;
import com.amazonaws.services.logs.model.PutDestinationPolicyRequest;
import com.amazonaws.services.logs.model.PutDestinationPolicyResult;
import com.amazonaws.services.logs.model.PutDestinationRequest;
import com.amazonaws.services.logs.model.PutDestinationResult;
import com.amazonaws.services.logs.model.PutLogEventsRequest;
import com.amazonaws.services.logs.model.PutLogEventsResult;
import com.amazonaws.services.logs.model.PutMetricFilterRequest;
import com.amazonaws.services.logs.model.PutMetricFilterResult;
import com.amazonaws.services.logs.model.PutResourcePolicyRequest;
import com.amazonaws.services.logs.model.PutResourcePolicyResult;
import com.amazonaws.services.logs.model.PutRetentionPolicyRequest;
import com.amazonaws.services.logs.model.PutRetentionPolicyResult;
import com.amazonaws.services.logs.model.PutSubscriptionFilterRequest;
import com.amazonaws.services.logs.model.PutSubscriptionFilterResult;
import com.amazonaws.services.logs.model.ResourceAlreadyExistsException;
import com.amazonaws.services.logs.model.ResourceNotFoundException;
import com.amazonaws.services.logs.model.ServiceUnavailableException;
import com.amazonaws.services.logs.model.TagLogGroupRequest;
import com.amazonaws.services.logs.model.TagLogGroupResult;
import com.amazonaws.services.logs.model.TestMetricFilterRequest;
import com.amazonaws.services.logs.model.TestMetricFilterResult;
import com.amazonaws.services.logs.model.UntagLogGroupRequest;
import com.amazonaws.services.logs.model.UntagLogGroupResult;
import com.amazonaws.services.logs.model.transform.AssociateKmsKeyRequestProtocolMarshaller;
import com.amazonaws.services.logs.model.transform.AssociateKmsKeyResultJsonUnmarshaller;
import com.amazonaws.services.logs.model.transform.CancelExportTaskRequestProtocolMarshaller;
import com.amazonaws.services.logs.model.transform.CancelExportTaskResultJsonUnmarshaller;
import com.amazonaws.services.logs.model.transform.CreateExportTaskRequestProtocolMarshaller;
import com.amazonaws.services.logs.model.transform.CreateExportTaskResultJsonUnmarshaller;
import com.amazonaws.services.logs.model.transform.CreateLogGroupRequestProtocolMarshaller;
import com.amazonaws.services.logs.model.transform.CreateLogGroupResultJsonUnmarshaller;
import com.amazonaws.services.logs.model.transform.CreateLogStreamRequestProtocolMarshaller;
import com.amazonaws.services.logs.model.transform.CreateLogStreamResultJsonUnmarshaller;
import com.amazonaws.services.logs.model.transform.DeleteDestinationRequestProtocolMarshaller;
import com.amazonaws.services.logs.model.transform.DeleteDestinationResultJsonUnmarshaller;
import com.amazonaws.services.logs.model.transform.DeleteLogGroupRequestProtocolMarshaller;
import com.amazonaws.services.logs.model.transform.DeleteLogGroupResultJsonUnmarshaller;
import com.amazonaws.services.logs.model.transform.DeleteLogStreamRequestProtocolMarshaller;
import com.amazonaws.services.logs.model.transform.DeleteLogStreamResultJsonUnmarshaller;
import com.amazonaws.services.logs.model.transform.DeleteMetricFilterRequestProtocolMarshaller;
import com.amazonaws.services.logs.model.transform.DeleteMetricFilterResultJsonUnmarshaller;
import com.amazonaws.services.logs.model.transform.DeleteResourcePolicyRequestProtocolMarshaller;
import com.amazonaws.services.logs.model.transform.DeleteResourcePolicyResultJsonUnmarshaller;
import com.amazonaws.services.logs.model.transform.DeleteRetentionPolicyRequestProtocolMarshaller;
import com.amazonaws.services.logs.model.transform.DeleteRetentionPolicyResultJsonUnmarshaller;
import com.amazonaws.services.logs.model.transform.DeleteSubscriptionFilterRequestProtocolMarshaller;
import com.amazonaws.services.logs.model.transform.DeleteSubscriptionFilterResultJsonUnmarshaller;
import com.amazonaws.services.logs.model.transform.DescribeDestinationsRequestProtocolMarshaller;
import com.amazonaws.services.logs.model.transform.DescribeDestinationsResultJsonUnmarshaller;
import com.amazonaws.services.logs.model.transform.DescribeExportTasksRequestProtocolMarshaller;
import com.amazonaws.services.logs.model.transform.DescribeExportTasksResultJsonUnmarshaller;
import com.amazonaws.services.logs.model.transform.DescribeLogGroupsRequestProtocolMarshaller;
import com.amazonaws.services.logs.model.transform.DescribeLogGroupsResultJsonUnmarshaller;
import com.amazonaws.services.logs.model.transform.DescribeLogStreamsRequestProtocolMarshaller;
import com.amazonaws.services.logs.model.transform.DescribeLogStreamsResultJsonUnmarshaller;
import com.amazonaws.services.logs.model.transform.DescribeMetricFiltersRequestProtocolMarshaller;
import com.amazonaws.services.logs.model.transform.DescribeMetricFiltersResultJsonUnmarshaller;
import com.amazonaws.services.logs.model.transform.DescribeResourcePoliciesRequestProtocolMarshaller;
import com.amazonaws.services.logs.model.transform.DescribeResourcePoliciesResultJsonUnmarshaller;
import com.amazonaws.services.logs.model.transform.DescribeSubscriptionFiltersRequestProtocolMarshaller;
import com.amazonaws.services.logs.model.transform.DescribeSubscriptionFiltersResultJsonUnmarshaller;
import com.amazonaws.services.logs.model.transform.DisassociateKmsKeyRequestProtocolMarshaller;
import com.amazonaws.services.logs.model.transform.DisassociateKmsKeyResultJsonUnmarshaller;
import com.amazonaws.services.logs.model.transform.FilterLogEventsRequestProtocolMarshaller;
import com.amazonaws.services.logs.model.transform.FilterLogEventsResultJsonUnmarshaller;
import com.amazonaws.services.logs.model.transform.GetLogEventsRequestProtocolMarshaller;
import com.amazonaws.services.logs.model.transform.GetLogEventsResultJsonUnmarshaller;
import com.amazonaws.services.logs.model.transform.ListTagsLogGroupRequestProtocolMarshaller;
import com.amazonaws.services.logs.model.transform.ListTagsLogGroupResultJsonUnmarshaller;
import com.amazonaws.services.logs.model.transform.PutDestinationPolicyRequestProtocolMarshaller;
import com.amazonaws.services.logs.model.transform.PutDestinationPolicyResultJsonUnmarshaller;
import com.amazonaws.services.logs.model.transform.PutDestinationRequestProtocolMarshaller;
import com.amazonaws.services.logs.model.transform.PutDestinationResultJsonUnmarshaller;
import com.amazonaws.services.logs.model.transform.PutLogEventsRequestProtocolMarshaller;
import com.amazonaws.services.logs.model.transform.PutLogEventsResultJsonUnmarshaller;
import com.amazonaws.services.logs.model.transform.PutMetricFilterRequestProtocolMarshaller;
import com.amazonaws.services.logs.model.transform.PutMetricFilterResultJsonUnmarshaller;
import com.amazonaws.services.logs.model.transform.PutResourcePolicyRequestProtocolMarshaller;
import com.amazonaws.services.logs.model.transform.PutResourcePolicyResultJsonUnmarshaller;
import com.amazonaws.services.logs.model.transform.PutRetentionPolicyRequestProtocolMarshaller;
import com.amazonaws.services.logs.model.transform.PutRetentionPolicyResultJsonUnmarshaller;
import com.amazonaws.services.logs.model.transform.PutSubscriptionFilterRequestProtocolMarshaller;
import com.amazonaws.services.logs.model.transform.PutSubscriptionFilterResultJsonUnmarshaller;
import com.amazonaws.services.logs.model.transform.TagLogGroupRequestProtocolMarshaller;
import com.amazonaws.services.logs.model.transform.TagLogGroupResultJsonUnmarshaller;
import com.amazonaws.services.logs.model.transform.TestMetricFilterRequestProtocolMarshaller;
import com.amazonaws.services.logs.model.transform.TestMetricFilterResultJsonUnmarshaller;
import com.amazonaws.services.logs.model.transform.UntagLogGroupRequestProtocolMarshaller;
import com.amazonaws.services.logs.model.transform.UntagLogGroupResultJsonUnmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSLogsClient
extends AmazonWebServiceClient
implements AWSLogs {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSLogs.class);
    private static final String DEFAULT_SIGNING_NAME = "logs";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterException").withModeledClass(InvalidParameterException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidOperationException").withModeledClass(InvalidOperationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DataAlreadyAcceptedException").withModeledClass(DataAlreadyAcceptedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidSequenceTokenException").withModeledClass(InvalidSequenceTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailableException").withModeledClass(ServiceUnavailableException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceAlreadyExistsException").withModeledClass(ResourceAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("OperationAbortedException").withModeledClass(OperationAbortedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)).withBaseServiceExceptionClass(AWSLogsException.class));

    @Deprecated
    public AWSLogsClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AWSLogsClient(ClientConfiguration clientConfiguration) {
        this(DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AWSLogsClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AWSLogsClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    @Deprecated
    public AWSLogsClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AWSLogsClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AWSLogsClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    public static AWSLogsClientBuilder builder() {
        return AWSLogsClientBuilder.standard();
    }

    AWSLogsClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("https://logs.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/logs/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/logs/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AssociateKmsKeyResult associateKmsKey(AssociateKmsKeyRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeAssociateKmsKey(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AssociateKmsKeyResult executeAssociateKmsKey(AssociateKmsKeyRequest associateKmsKeyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(associateKmsKeyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AssociateKmsKeyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AssociateKmsKeyRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(associateKmsKeyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new AssociateKmsKeyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AssociateKmsKeyResult associateKmsKeyResult = (AssociateKmsKeyResult)response.getAwsResponse();
            return associateKmsKeyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CancelExportTaskResult cancelExportTask(CancelExportTaskRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCancelExportTask(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CancelExportTaskResult executeCancelExportTask(CancelExportTaskRequest cancelExportTaskRequest) {
        ExecutionContext executionContext = this.createExecutionContext(cancelExportTaskRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CancelExportTaskRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CancelExportTaskRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(cancelExportTaskRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CancelExportTaskResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CancelExportTaskResult cancelExportTaskResult = (CancelExportTaskResult)response.getAwsResponse();
            return cancelExportTaskResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateExportTaskResult createExportTask(CreateExportTaskRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateExportTask(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateExportTaskResult executeCreateExportTask(CreateExportTaskRequest createExportTaskRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createExportTaskRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateExportTaskRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateExportTaskRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(createExportTaskRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateExportTaskResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateExportTaskResult createExportTaskResult = (CreateExportTaskResult)response.getAwsResponse();
            return createExportTaskResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateLogGroupResult createLogGroup(CreateLogGroupRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateLogGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateLogGroupResult executeCreateLogGroup(CreateLogGroupRequest createLogGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createLogGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateLogGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateLogGroupRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(createLogGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateLogGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateLogGroupResult createLogGroupResult = (CreateLogGroupResult)response.getAwsResponse();
            return createLogGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateLogStreamResult createLogStream(CreateLogStreamRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateLogStream(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateLogStreamResult executeCreateLogStream(CreateLogStreamRequest createLogStreamRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createLogStreamRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateLogStreamRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateLogStreamRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(createLogStreamRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateLogStreamResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateLogStreamResult createLogStreamResult = (CreateLogStreamResult)response.getAwsResponse();
            return createLogStreamResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteDestinationResult deleteDestination(DeleteDestinationRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteDestination(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteDestinationResult executeDeleteDestination(DeleteDestinationRequest deleteDestinationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDestinationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDestinationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDestinationRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(deleteDestinationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteDestinationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteDestinationResult deleteDestinationResult = (DeleteDestinationResult)response.getAwsResponse();
            return deleteDestinationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteLogGroupResult deleteLogGroup(DeleteLogGroupRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteLogGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteLogGroupResult executeDeleteLogGroup(DeleteLogGroupRequest deleteLogGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteLogGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteLogGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteLogGroupRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(deleteLogGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteLogGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteLogGroupResult deleteLogGroupResult = (DeleteLogGroupResult)response.getAwsResponse();
            return deleteLogGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteLogStreamResult deleteLogStream(DeleteLogStreamRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteLogStream(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteLogStreamResult executeDeleteLogStream(DeleteLogStreamRequest deleteLogStreamRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteLogStreamRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteLogStreamRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteLogStreamRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(deleteLogStreamRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteLogStreamResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteLogStreamResult deleteLogStreamResult = (DeleteLogStreamResult)response.getAwsResponse();
            return deleteLogStreamResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteMetricFilterResult deleteMetricFilter(DeleteMetricFilterRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteMetricFilter(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteMetricFilterResult executeDeleteMetricFilter(DeleteMetricFilterRequest deleteMetricFilterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteMetricFilterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteMetricFilterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteMetricFilterRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(deleteMetricFilterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteMetricFilterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteMetricFilterResult deleteMetricFilterResult = (DeleteMetricFilterResult)response.getAwsResponse();
            return deleteMetricFilterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteResourcePolicyResult deleteResourcePolicy(DeleteResourcePolicyRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteResourcePolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteResourcePolicyResult executeDeleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteResourcePolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteResourcePolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteResourcePolicyRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(deleteResourcePolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteResourcePolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteResourcePolicyResult deleteResourcePolicyResult = (DeleteResourcePolicyResult)response.getAwsResponse();
            return deleteResourcePolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteRetentionPolicyResult deleteRetentionPolicy(DeleteRetentionPolicyRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteRetentionPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteRetentionPolicyResult executeDeleteRetentionPolicy(DeleteRetentionPolicyRequest deleteRetentionPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteRetentionPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteRetentionPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteRetentionPolicyRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(deleteRetentionPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteRetentionPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteRetentionPolicyResult deleteRetentionPolicyResult = (DeleteRetentionPolicyResult)response.getAwsResponse();
            return deleteRetentionPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteSubscriptionFilterResult deleteSubscriptionFilter(DeleteSubscriptionFilterRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteSubscriptionFilter(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteSubscriptionFilterResult executeDeleteSubscriptionFilter(DeleteSubscriptionFilterRequest deleteSubscriptionFilterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteSubscriptionFilterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteSubscriptionFilterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteSubscriptionFilterRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(deleteSubscriptionFilterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteSubscriptionFilterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteSubscriptionFilterResult deleteSubscriptionFilterResult = (DeleteSubscriptionFilterResult)response.getAwsResponse();
            return deleteSubscriptionFilterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeDestinationsResult describeDestinations(DescribeDestinationsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeDestinations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeDestinationsResult executeDescribeDestinations(DescribeDestinationsRequest describeDestinationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDestinationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDestinationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDestinationsRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeDestinationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeDestinationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeDestinationsResult describeDestinationsResult = (DescribeDestinationsResult)response.getAwsResponse();
            return describeDestinationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeDestinationsResult describeDestinations() {
        return this.describeDestinations(new DescribeDestinationsRequest());
    }

    @Override
    public DescribeExportTasksResult describeExportTasks(DescribeExportTasksRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeExportTasks(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeExportTasksResult executeDescribeExportTasks(DescribeExportTasksRequest describeExportTasksRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeExportTasksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeExportTasksRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeExportTasksRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeExportTasksRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeExportTasksResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeExportTasksResult describeExportTasksResult = (DescribeExportTasksResult)response.getAwsResponse();
            return describeExportTasksResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeLogGroupsResult describeLogGroups(DescribeLogGroupsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeLogGroups(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeLogGroupsResult executeDescribeLogGroups(DescribeLogGroupsRequest describeLogGroupsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeLogGroupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeLogGroupsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeLogGroupsRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeLogGroupsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeLogGroupsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeLogGroupsResult describeLogGroupsResult = (DescribeLogGroupsResult)response.getAwsResponse();
            return describeLogGroupsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeLogGroupsResult describeLogGroups() {
        return this.describeLogGroups(new DescribeLogGroupsRequest());
    }

    @Override
    public DescribeLogStreamsResult describeLogStreams(DescribeLogStreamsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeLogStreams(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeLogStreamsResult executeDescribeLogStreams(DescribeLogStreamsRequest describeLogStreamsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeLogStreamsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeLogStreamsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeLogStreamsRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeLogStreamsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeLogStreamsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeLogStreamsResult describeLogStreamsResult = (DescribeLogStreamsResult)response.getAwsResponse();
            return describeLogStreamsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeMetricFiltersResult describeMetricFilters(DescribeMetricFiltersRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeMetricFilters(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeMetricFiltersResult executeDescribeMetricFilters(DescribeMetricFiltersRequest describeMetricFiltersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeMetricFiltersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeMetricFiltersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeMetricFiltersRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeMetricFiltersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeMetricFiltersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeMetricFiltersResult describeMetricFiltersResult = (DescribeMetricFiltersResult)response.getAwsResponse();
            return describeMetricFiltersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeResourcePoliciesResult describeResourcePolicies(DescribeResourcePoliciesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeResourcePolicies(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeResourcePoliciesResult executeDescribeResourcePolicies(DescribeResourcePoliciesRequest describeResourcePoliciesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeResourcePoliciesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeResourcePoliciesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeResourcePoliciesRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeResourcePoliciesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeResourcePoliciesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeResourcePoliciesResult describeResourcePoliciesResult = (DescribeResourcePoliciesResult)response.getAwsResponse();
            return describeResourcePoliciesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeSubscriptionFiltersResult describeSubscriptionFilters(DescribeSubscriptionFiltersRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeSubscriptionFilters(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeSubscriptionFiltersResult executeDescribeSubscriptionFilters(DescribeSubscriptionFiltersRequest describeSubscriptionFiltersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeSubscriptionFiltersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeSubscriptionFiltersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeSubscriptionFiltersRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeSubscriptionFiltersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeSubscriptionFiltersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeSubscriptionFiltersResult describeSubscriptionFiltersResult = (DescribeSubscriptionFiltersResult)response.getAwsResponse();
            return describeSubscriptionFiltersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisassociateKmsKeyResult disassociateKmsKey(DisassociateKmsKeyRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDisassociateKmsKey(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisassociateKmsKeyResult executeDisassociateKmsKey(DisassociateKmsKeyRequest disassociateKmsKeyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disassociateKmsKeyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisassociateKmsKeyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisassociateKmsKeyRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(disassociateKmsKeyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DisassociateKmsKeyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisassociateKmsKeyResult disassociateKmsKeyResult = (DisassociateKmsKeyResult)response.getAwsResponse();
            return disassociateKmsKeyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public FilterLogEventsResult filterLogEvents(FilterLogEventsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeFilterLogEvents(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final FilterLogEventsResult executeFilterLogEvents(FilterLogEventsRequest filterLogEventsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(filterLogEventsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<FilterLogEventsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new FilterLogEventsRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(filterLogEventsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new FilterLogEventsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            FilterLogEventsResult filterLogEventsResult = (FilterLogEventsResult)response.getAwsResponse();
            return filterLogEventsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetLogEventsResult getLogEvents(GetLogEventsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetLogEvents(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetLogEventsResult executeGetLogEvents(GetLogEventsRequest getLogEventsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getLogEventsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetLogEventsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetLogEventsRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(getLogEventsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetLogEventsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetLogEventsResult getLogEventsResult = (GetLogEventsResult)response.getAwsResponse();
            return getLogEventsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsLogGroupResult listTagsLogGroup(ListTagsLogGroupRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListTagsLogGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsLogGroupResult executeListTagsLogGroup(ListTagsLogGroupRequest listTagsLogGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsLogGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsLogGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsLogGroupRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(listTagsLogGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListTagsLogGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsLogGroupResult listTagsLogGroupResult = (ListTagsLogGroupResult)response.getAwsResponse();
            return listTagsLogGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutDestinationResult putDestination(PutDestinationRequest request) {
        request = this.beforeClientExecution(request);
        return this.executePutDestination(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutDestinationResult executePutDestination(PutDestinationRequest putDestinationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putDestinationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutDestinationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutDestinationRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(putDestinationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new PutDestinationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutDestinationResult putDestinationResult = (PutDestinationResult)response.getAwsResponse();
            return putDestinationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutDestinationPolicyResult putDestinationPolicy(PutDestinationPolicyRequest request) {
        request = this.beforeClientExecution(request);
        return this.executePutDestinationPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutDestinationPolicyResult executePutDestinationPolicy(PutDestinationPolicyRequest putDestinationPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putDestinationPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutDestinationPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutDestinationPolicyRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(putDestinationPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new PutDestinationPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutDestinationPolicyResult putDestinationPolicyResult = (PutDestinationPolicyResult)response.getAwsResponse();
            return putDestinationPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutLogEventsResult putLogEvents(PutLogEventsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executePutLogEvents(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutLogEventsResult executePutLogEvents(PutLogEventsRequest putLogEventsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putLogEventsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutLogEventsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutLogEventsRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(putLogEventsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new PutLogEventsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutLogEventsResult putLogEventsResult = (PutLogEventsResult)response.getAwsResponse();
            return putLogEventsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutMetricFilterResult putMetricFilter(PutMetricFilterRequest request) {
        request = this.beforeClientExecution(request);
        return this.executePutMetricFilter(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutMetricFilterResult executePutMetricFilter(PutMetricFilterRequest putMetricFilterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putMetricFilterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutMetricFilterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutMetricFilterRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(putMetricFilterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new PutMetricFilterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutMetricFilterResult putMetricFilterResult = (PutMetricFilterResult)response.getAwsResponse();
            return putMetricFilterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutResourcePolicyResult putResourcePolicy(PutResourcePolicyRequest request) {
        request = this.beforeClientExecution(request);
        return this.executePutResourcePolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutResourcePolicyResult executePutResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putResourcePolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutResourcePolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutResourcePolicyRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(putResourcePolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new PutResourcePolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutResourcePolicyResult putResourcePolicyResult = (PutResourcePolicyResult)response.getAwsResponse();
            return putResourcePolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutRetentionPolicyResult putRetentionPolicy(PutRetentionPolicyRequest request) {
        request = this.beforeClientExecution(request);
        return this.executePutRetentionPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutRetentionPolicyResult executePutRetentionPolicy(PutRetentionPolicyRequest putRetentionPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putRetentionPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutRetentionPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutRetentionPolicyRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(putRetentionPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new PutRetentionPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutRetentionPolicyResult putRetentionPolicyResult = (PutRetentionPolicyResult)response.getAwsResponse();
            return putRetentionPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutSubscriptionFilterResult putSubscriptionFilter(PutSubscriptionFilterRequest request) {
        request = this.beforeClientExecution(request);
        return this.executePutSubscriptionFilter(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutSubscriptionFilterResult executePutSubscriptionFilter(PutSubscriptionFilterRequest putSubscriptionFilterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putSubscriptionFilterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutSubscriptionFilterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutSubscriptionFilterRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(putSubscriptionFilterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new PutSubscriptionFilterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutSubscriptionFilterResult putSubscriptionFilterResult = (PutSubscriptionFilterResult)response.getAwsResponse();
            return putSubscriptionFilterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagLogGroupResult tagLogGroup(TagLogGroupRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeTagLogGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagLogGroupResult executeTagLogGroup(TagLogGroupRequest tagLogGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagLogGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagLogGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagLogGroupRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(tagLogGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new TagLogGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagLogGroupResult tagLogGroupResult = (TagLogGroupResult)response.getAwsResponse();
            return tagLogGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TestMetricFilterResult testMetricFilter(TestMetricFilterRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeTestMetricFilter(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TestMetricFilterResult executeTestMetricFilter(TestMetricFilterRequest testMetricFilterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(testMetricFilterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TestMetricFilterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TestMetricFilterRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(testMetricFilterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new TestMetricFilterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TestMetricFilterResult testMetricFilterResult = (TestMetricFilterResult)response.getAwsResponse();
            return testMetricFilterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagLogGroupResult untagLogGroup(UntagLogGroupRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUntagLogGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagLogGroupResult executeUntagLogGroup(UntagLogGroupRequest untagLogGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagLogGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagLogGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagLogGroupRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(untagLogGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UntagLogGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagLogGroupResult untagLogGroupResult = (UntagLogGroupResult)response.getAwsResponse();
            return untagLogGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

