# Prima

[Prima](https://www.schulschrift.at/) is a typeface family that has been designed to help in learning to read and write. Its development was initially commissioned by the [Wiener Bildungsserver](https://bildungsserver.wien/) and the first two styles, regular and cursive, were designed from 2021 to 2023 by Titus Nemeth ([Wiener Schriften](https://wienerschriften.at/)) and Martin Tiefenthaler ([typographische gesellschaft austria/tga](https://typographischegesellschaft.at/)). In 2024, the further development of Prima was funded by the [Vienna Business Agency](https://wirtschaftsagentur.at/), a fund of the city of Vienna.

Prima uses the OpenType format and contains a number of features that provide additional, optional functionality. 

The characterset of Prima currently supports 205 languages that are written in the Latin script.

## Design principles

In Prima, unconnected and cursive letterforms are closely related so that learners already know strokes and proportions when they advance from one style to the other.

A central principle of Prima is to allow for variation. It offers multiple proven solutions, rather than a single prescriptive design, to guide pupils in the development of their own hand.

In Prima, connections were designed to allow a maximum of fluidity and evenness. The treatment of joints as separate elements allows for ergonomically sound connections between letters.

In Prima cursive not all connections are compulsory, for nobody who writes swiftly joins every letter. Yet, it offers exemplary connections as a model. The choice whether to use them or not remains with the writer.

## Releases

* [Latest release](../../releases/latest)

## Licensing
Prima is [licensed](https://github.com/WienerSchriften/Prima/blob/main/LICENSE.md) with the open-source license CC BY-NC-SA 4-0, making it freely available for non-commercial use. You may also obtain a license for commercial use directly from the rights-holders. For details please contact the designers of Prima, Titus Nemeth and Martin Tiefenthaler.

## Installation and use
For installation of the fonts please follow the procedure suitable for your operating system. After installation you may have to restart the application in which you want to use Prima. Prima cursive makes use of the 'contextual alternates' OpenType feature for the connecting strokes between letters. Other optional features such as the stylistic sets also rely on support for the OpenType technology (which has been the de-facto industry standard since 2001 and become an official ISO standard in 2007). Although it is widely supported, not all applications support all features and some applications do not support any OpenType features at all. In case of doubt, please contact the developer of your application and request the update of the outdated application.

### Adobe Creative Cloud applications
At the time of writing (28 September 2023), some Adobe Creative Cloud applications feature two different text composition engines that can be selected by the user. By default the older, less capable version is active and users have to choose the newer version for the shaping in Prima Cursive to work. The names may depend on your version and interface language, but tend to reference writing systems beyond Latin, see the screenshots below:

<img width="661" alt="Screenshot 2023-09-28 at 08 12 24" src="https://github.com/WienerSchriften/Prima/assets/122893870/c7950649-208a-4682-aade-4221a2c6715c">
<img width="799" alt="Screenshot 2023-09-28 at 08 12 07" src="https://github.com/WienerSchriften/Prima/assets/122893870/7627b25a-d256-4272-93a8-0aba9ae099e8">
<img width="795" alt="Screenshot 2023-09-28 at 08 11 20" src="https://github.com/WienerSchriften/Prima/assets/122893870/e5cc3547-7d24-4531-8096-a9942b21fc81">

## Getting involved

[Open an issue](https://github.com/wienerschriften/prima/issues) or send a suggestion to the designers of Prima for consideration in future developments.

## Building the fonts from source

There are a number of font editors and tools – both open source and proprietary – that can be used to build the fonts from the .ufo sources. We do not prescribe which tool is used, nor do we currently offer technical support building the fonts.
