# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/0. Download models.ipynb.

# %% auto 0
__all__ = []

# %% ../nbs/0. Download models.ipynb 1
from encodec.model import EncodecModel
from whisperspeech import utils
from fastcore.script import call_parse
import whisperx
import whisper
from speechbrain.pretrained import EncoderClassifier
from os.path import expanduser
import urllib.request

# %% ../nbs/0. Download models.ipynb 3
def load_whisperx(model, lang):
    try:
        whisperx.asr.load_model(model, "cpu", compute_type="float16", language=lang)
    except ValueError as exc:
        print(exc.args[0])
        if exc.args[0] != "Requested float16 compute type, but the target device or backend do not support efficient float16 computation.":
            raise

@call_parse
def main():
    EncodecModel.encodec_model_24khz()
    whisper.load_model('base.en')
    whisper.load_model('small.en')
    whisper.load_model('medium')
    whisperx.vad.load_vad_model('cpu')
    load_whisperx('small.en', 'en')
    load_whisperx('medium.en', 'en')
    load_whisperx('medium', 'en')
    load_whisperx('large-v3', 'en')
    EncoderClassifier.from_hparams(source="speechbrain/spkrec-ecapa-voxceleb",
                                   savedir=expanduser("~/.cache/speechbrain/"))
    urllib.request.urlretrieve('https://github.com/marianne-m/brouhaha-vad/raw/main/models/best/checkpoints/best.ckpt',
                               expanduser('~/.cache/brouhaha.ckpt'))
