<?php
/**
 * Short Description of the file
 *
 * Long Description of the file (if any)...
 *
 * @author Nicola Wilkinson
 *
 * @copyright Loughborough University
 * @license https://www.gnu.org/licenses/gpl-3.0.en.html GPL version 3
 *
 * @link https://github.com/webpa/webpa
 */

namespace WebPA\lang\en\tutors;

class Tutors
{
    public const WELCOME = 'Welcome to WebPA, the easiest way for your students to carry out peer assessment reviews on the web. Using this system, students doing group work activities can mark each other\'s contributions, providing each student with an overall score.';

    public const SECTIONS__INTRO = 'WebPA contains the following sections:';

    public const OPT__FORMS__DESC = 'Create peer assessment forms for your students to complete. You can re-use your forms with many different assessments.';

    public const OPT__GROUPS__DESC = 'Organise your students into groups. You can create new groups from scratch, or use existing groups that have been set up by other staff members.';

    public const OPT__ASSESSMENTS__DESC = 'Create, edit and schedule your peer assessments sessions so they only run how and when you want.';

    public const GETTING__STARTED__TITLE = 'Getting Started';

    public const GETTING__STARTED__DESC = 'The fastest way to get started is for you to choose <a href="forms/">my forms</a> from the left-hand menu, there you can begin creating a peer assessment form that your students will use later to grade each other.';

    public const GROUPS__WELCOME = 'Here you can edit your groups, and organise how students are allocated to the individual groups.';

    public const GROUPS__TITLE = 'Existing Groups';

    public const NO__GROUPS__DESC = 'You have no groups. To add a collection use the <a href="create/">create new groups wizard</a>.';

    public const GROUPS__INSTRUCT__1 = 'These are your groups. To view or edit a collection of groups, click on ';

    public const GROUPS__INSTRUCT__2 = 'in the list below.';

    public const GROUPS__NOTE ='Any changes you make to your groups here will <strong>not</strong> affect any assessments you may have created. If you want to change the groups in use with an assessment, you must edit the assessment and choose the option to select a new set of groups.';

    public const GROUPS__EDIT__DESC =  'Here you can edit your collections of groups, and organise how students are allocated to the individual groups.';

    public const GROUPS__EDIT_TITLE = 'Group Collections';

    public const NO_COLLECTIONS ='You have no collections. To add a collection use the <a href="../create/">create new groups wizard</a>.';

    public const GROUPS__EDIT__INST = 'These are your group collections. To view or edit a collection, click on its name in the list below:';

    public const GROUPS__EDIT_SAVE_ERR ='You must give this group a name.';

    public const COLLECTION__LOCKED ='<p>This group belongs to a collection that has been locked, and cannot be edited. You can still view the details of this group, but not edit its name or members.</p>';

    public const GROUPS__EDIT_INST =  '<p>On this page you can change the name of this group, and add/remove students from it.</p>';

    public const GROUP__SELECTED = '<p>The group you selected could not be loaded for some reason - please go back and try again.</p>';
}
