-- MySQL Script generated by MySQL Workbench
-- Thu Sep 28 18:51:55 2017
-- Model: New Model    Version: 1.0
-- MySQL Workbench Forward Engineering

SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='TRADITIONAL,ALLOW_INVALID_DATES';

-- -----------------------------------------------------
-- Schema athlon_framework
-- -----------------------------------------------------
-- Athlon PHP Framework CMS SQL

-- -----------------------------------------------------
-- Table `cms_userroles`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `cms_userroles` (
  `id` SMALLINT(5) UNSIGNED NOT NULL AUTO_INCREMENT,
  `title` VARCHAR(100) NOT NULL,
  `created_on` DATETIME NOT NULL,
  `updated_on` DATETIME NOT NULL,
  `permissions` TEXT NULL,
  `ownership` TEXT NULL,
  PRIMARY KEY (`id`) )
ENGINE = MyISAM;


-- -----------------------------------------------------
-- Table `cms_users`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `cms_users` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `role_id` SMALLINT(5) UNSIGNED NOT NULL,
  `is_active` TINYINT(1) NOT NULL DEFAULT 1,
  `login_attempts` TINYINT(1) NULL DEFAULT 0,
  `password` VARCHAR(100) NOT NULL,
  `email` VARCHAR(150) NOT NULL,
  `name` VARCHAR(255) NOT NULL,
  `timezone` VARCHAR(50) NOT NULL,
  `created_on` DATETIME NOT NULL,
  `updated_on` DATETIME NOT NULL,
  `login_on` DATETIME NULL,
  PRIMARY KEY (`id`) ,
  UNIQUE INDEX `email` USING BTREE (`email` ASC) ,
  INDEX `role_id` USING BTREE (`role_id` ASC) ,
  INDEX `is_active` (`is_active` ASC) )
ENGINE = MyISAM;


-- -----------------------------------------------------
-- Table `sessions`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `sessions` (
  `session_key` CHAR(32) NOT NULL,
  `last_active` INT UNSIGNED NOT NULL,
  PRIMARY KEY (`session_key`) )
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `session_vars`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `session_vars` (
  `session_key` CHAR(32) NOT NULL,
  `private_key` CHAR(32) NOT NULL,
  `name` VARCHAR(20) NOT NULL,
  `value` TEXT NULL,
  INDEX `session_key_idx` (`session_key` ASC) ,
  UNIQUE INDEX `session_value` (`private_key` ASC, `name` ASC, `session_key` ASC) ,
  CONSTRAINT `session_key`
    FOREIGN KEY (`session_key`)
    REFERENCES `sessions` (`session_key`)
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `cache`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `cache` (
  `cache_key` CHAR(32) NOT NULL,
  `value` TEXT NOT NULL,
  `expire` INT(11) NOT NULL,
  PRIMARY KEY (`cache_key`) )
ENGINE = MyISAM;


-- -----------------------------------------------------
-- Table `cms_help`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `cms_help` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `title` VARCHAR(255) NOT NULL,
  `content` MEDIUMTEXT NULL,
  `created_on` DATETIME NOT NULL,
  `updated_on` DATETIME NOT NULL,
  PRIMARY KEY (`id`) ,
  UNIQUE INDEX `title_UNIQUE` (`title` ASC) )
ENGINE = MyISAM;


-- -----------------------------------------------------
-- Table `cms_ownership`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `cms_ownership` (
  `owner_id` INT UNSIGNED NOT NULL,
  `resource_id` INT UNSIGNED NOT NULL,
  `model` VARCHAR(48) NOT NULL,
  PRIMARY KEY (`owner_id`, `resource_id`, `model`) ,
  INDEX `owner` (`owner_id` ASC) ,
  INDEX `resource` (`resource_id` ASC) )
ENGINE = MyISAM;


SET SQL_MODE=@OLD_SQL_MODE;
SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;

-- -----------------------------------------------------
-- Data for table `cms_userroles`
-- -----------------------------------------------------
START TRANSACTION;
INSERT INTO `cms_userroles` (`id`, `title`, `created_on`, `updated_on`, `permissions`, `ownership`) VALUES (1, 'Administrator', '2012-06-19 00:00:00', '2013-02-12 18:02:18', '{\"account\":[\"credentials\",\"edit\"],\"cmshelp\":[\"show\",\"create\",\"edit\",\"delete\",\"export\",\"index\"],\"cmsuserroles\":[\"show\",\"create\",\"edit\",\"delete\",\"export\",\"index\"],\"cmsusers\":[\"credentials\",\"show\",\"create\",\"edit\",\"delete\",\"export\",\"index\"]}', NULL);

COMMIT;


-- -----------------------------------------------------
-- Data for table `cms_users`
-- -----------------------------------------------------
START TRANSACTION;
INSERT INTO `cms_users` (`id`, `role_id`, `is_active`, `login_attempts`, `password`, `email`, `name`, `timezone`, `created_on`, `updated_on`, `login_on`) VALUES (1, 1, 1, 0, '$2a$12$dth4UtUefld7ZQcs/4tSu.ipr/E2C2fCd7pGzPdJ1PwRf0QeRvtHq', 'demo@silla.io', 'Demo', 'Europe/Sofia', '2012-06-19 11:40:16', '2013-04-01 23:31:52', '2013-04-01 23:31:52');

COMMIT;


-- -----------------------------------------------------
-- Data for table `cms_help`
-- -----------------------------------------------------
START TRANSACTION;
INSERT INTO `cms_help` (`id`, `title`, `content`, `created_on`, `updated_on`) VALUES (1, 'Overview', '{\"formatted\":\"<h1>Overview<\\/h1>\\n<hr \\/>\\n<h3>Silla.IO is a MVC based PHP Application Development Framework<\\/h3>\\n<p>Reusable software environment that provides particular functionality as part of a larger software platform to facilitate development of software applications, products and solutions.<\\/p>\\n<p>The framework comes with a CMS Application to enable building user defined content management systems.<\\/p>\\n<ul>\\n<li>Used to run projects for global brands<\\/li>\\n<li>3 years in active development by a professional team<\\/li>\\n<li>Covers best practices and system architecture<\\/li>\\n<li>Complete development history available<\\/li>\\n<li>Complete code Documentation and available examples of CMS user documentation<\\/li>\\n<li>Penetration tested\\n<ul>\\n<li>The framework has been penetration tested by industry leading experts.<\\/li>\\n<li>Tested against: DoS, CSRF, Persistent and reflected XSS, Exposed download links, ClickJacking, Text injection, Order injection, Insecure HTTP methods as well as issues with password management, authentication and e-mail harvesting<\\/li>\\n<li>To live up to standards of multinational blue chip clients and their data security needs<\\/li>\\n<\\/ul><\\/li>\\n<\\/ul>\\n<p><em>Learn more at <a href=\\\"http:\\/\\/silla.io\\/\\\">Silla.IO<\\/a><\\/em> <\\/p>\",\"raw\":\"# Overview\\r\\n***\\r\\n### Silla.IO is a MVC based PHP Application Development Framework\\r\\n\\r\\nReusable software environment that provides particular functionality as part of a larger software platform to facilitate development of software applications, products and solutions.\\r\\n\\r\\nThe framework comes with a CMS Application to enable building user defined content management systems.\\r\\n* Used to run projects for global brands\\r\\n* 3 years in active development by a professional team\\r\\n* Covers best practices and system architecture\\r\\n* Complete development history available\\r\\n* Complete code Documentation and available examples of CMS user documentation\\r\\n* Penetration tested\\r\\n  * The framework has been penetration tested by industry leading experts.\\r\\n  * Tested against: DoS, CSRF, Persistent and reflected XSS, Exposed download links, ClickJacking, Text injection, Order injection, Insecure HTTP methods as well as issues with password management, authentication and e-mail harvesting\\r\\n  * To live up to standards of multinational blue chip clients and their data security needs\\r\\n\\r\\n*Learn more at [Silla.IO](http:\\/\\/silla.io\\/)*\"}', '2016-03-01 00:00:00', '2016-03-01 00:00:00');

COMMIT;

