import { addStrings } from 'meteor/vulcan:core';

addStrings('en', {
  'accounts.error_incorrect_password': 'Incorrect password',
  'accounts.error_email_required': 'Email required',
  'accounts.error_email_already_exists': 'Email already exists',
  'accounts.error_invalid_email': 'Invalid email',
  'accounts.error_minchar': 'Your password is too short',
  'accounts.error_username_required': 'Username required',
  'accounts.error_accounts_': '',
  'accounts.error_unknown': 'Unknown error',
  'accounts.error_user_not_found': 'User not found',
  'accounts.error_username_already_exists': 'Username already exists',
  'accounts.enter_username_or_email': 'Enter username or email',
  'accounts.error_internal_server_error': 'Internal server error',
  'accounts.error_token_expired': 'Invalid password reset token',
  'accounts.username_or_email': 'Username or email',
  'accounts.enter_username': 'Enter username',
  'accounts.username': 'Username',
  'accounts.enter_email': 'Enter email',
  'accounts.email': 'Email',
  'accounts.enter_password': 'Enter password',
  'accounts.password': 'Password',
  'accounts.choose_password': 'Choose password',
  'accounts.change_password': 'Change password',
  'accounts.reset_your_password': 'Reset your password',
  'accounts.set_password': 'Set password',
  'accounts.enter_new_password': 'Enter new password',
  'accounts.new_password': 'New password',
  'accounts.forgot_password': 'Forgot password',
  'accounts.sign_up': 'Sign up',
  'accounts.sign_in': 'Sign in',
  'accounts.sign_out': 'Sign out',
  'accounts.cancel': 'Cancel',
  'accounts.or_use': 'or use',
  'accounts.info_email_sent': 'Email sent.',
  'accounts.info_password_changed': 'Password changed.',
  'accounts.logging_in': 'Logging in…',
  'accounts.email_verified': 'Your email address has been verified.',

  'forms.submit': 'Submit',
  'forms.cancel': 'Cancel',
  'forms.select_option': '-- select option --',
  'forms.add_nested_field': 'Add a {label}',
  'forms.delete_nested_field': 'Delete this {label}?',
  'forms.delete': 'Delete',
  'forms.delete_field': 'Delete the field?',
  'forms.delete_confirm': 'Delete document?',
  'forms.revert': 'Revert',
  'forms.confirm_discard': 'Discard changes?',
  'forms.day': 'Day',
  'forms.month': 'Month',
  'forms.year': 'Year',
  'forms.start_adornment_url_icon': 'Web icon',
  'forms.start_adornment_email_icon': 'Email icon',
  'forms.start_adornment_social_icon': 'Social icon',
  'forms.clear_field': 'Clear field value',

  'users.profile': 'Profile',
  'users.complete_profile': 'Complete your Profile',
  'users.profile_completed': 'Profile completed.',
  'users.edit_account': 'Edit Account',
  'users.edit_success': 'User “{name}” edited',
  'users.log_in': 'Log In',
  'users.sign_up': 'Sign Up',
  'users.sign_up_log_in': 'Sign Up/Log In',
  'users.log_out': 'Log Out',
  'users.bio': 'Bio',
  'users.displayName': 'Display Name',
  'users.email': 'Email',
  'users.twitterUsername': 'Twitter Username',
  'users.website': 'Website',
  'users.groups': 'Groups',
  'users.avatar': 'Avatar',
  'users.notifications': 'Notifications',
  'users.notifications_users': 'New Users Notifications',
  'users.notifications_posts': 'New Posts Notifications',
  'users.newsletter_subscribeToNewsletter': 'Subscribe to newsletter',
  'users.users_admin': 'Admin',
  'users.admin': 'Admin',
  'users.host': 'Team member',
  'users.isAdmin': 'Admin',
  'users.posts': 'Posts',
  'users.upvoted_posts': 'Upvoted Posts',
  'users.please_log_in': 'Please log in',
  'users.please_sign_up_log_in': 'Please sign up or log in',
  'users.cannot_post': 'Sorry, you do not have permission to post at this time',
  'users.cannot_comment': 'Sorry, you do not have permission to comment at this time',
  'users.subscribe': "Subscribe to this user's posts",
  'users.unsubscribe': "Unsubscribe to this user's posts",
  'users.subscribed': 'You have subscribed to “{name}” posts.',
  'users.unsubscribed': 'You have unsubscribed from “{name}” posts.',
  'users.subscribers': 'Subscribers',
  'users.delete': 'Delete user',
  'users.delete_confirm': 'Delete this user?',
  'users.email_already_taken': 'This email is already taken: {value}',

  settings: 'Settings',
  'settings.json_message': 'Note: settings already provided in your <code>settings.json</code> file will be disabled.',
  'settings.edit': 'Edit Settings',
  'settings.edited': 'Settings edited (please reload).',
  'settings.title': 'Title',
  'settings.siteUrl': 'Site URL',
  'settings.tagline': 'Tagline',
  'settings.description': 'Description',
  'settings.siteImage': 'Site Image',
  'settings.defaultEmail': 'Default Email',
  'settings.mailUrl': 'Mail URL',
  'settings.scoreUpdate': 'Score Update',
  'settings.postInterval': 'Post Interval',
  'settings.RSSLinksPointTo': 'RSS Links Point To',
  'settings.commentInterval': 'Comment Interval',
  'settings.maxPostsPerDay': 'Max Posts Per Day',
  'settings.startInvitesCount': 'Start Invites Count',
  'settings.postsPerPage': 'Posts Per Page',
  'settings.logoUrl': 'Logo URL',
  'settings.logoHeight': 'Logo Height',
  'settings.logoWidth': 'Logo Width',
  'settings.faviconUrl': 'Favicon URL',
  'settings.twitterAccount': 'Twitter Account',
  'settings.facebookPage': 'Facebook Page',
  'settings.googleAnalyticsId': 'Google Analytics ID',
  'settings.locale': 'Locale',
  'settings.requireViewInvite': 'Require View Invite',
  'settings.requirePostInvite': 'Require Post Invite',
  'settings.requirePostsApproval': 'Require Posts Approval',
  'settings.scoreUpdateInterval': 'Score Update Interval',

  'app.loading': 'Loading…',
  'app.404': "Sorry, we couldn't find what you were looking for.",
  'app.empty_input': 'Single resolver cannot receive an empty input object.',
  'app.missing_document': "Sorry, we couldn't find the document you were looking for.",
  'app.powered_by': 'Built with Vulcan.js',
  'app.or': 'Or',
  'app.noPermission': 'Sorry, you do not have the permission to do this at this time.',
  'app.operation_not_allowed': 'Sorry, you don\'t have the rights to perform the operation "{operationName}"',
  'app.document_not_found': 'Document not found (id: {value})',
  'app.no_permissions_defined': 'No permissions defined for operation [{operationName}]',
  'app.disallowed_property_detected': 'Disallowed property detected: {value}',
  'app.something_bad_happened': 'Something bad happened...',
  'app.embedly_not_authorized':
    'Invalid Embedly API key provided in the settings file. To find your key, log into https://app.embed.ly -> API',
  'app.defaultError': '{defaultMessage}',
  'app.please_sign_up_log_in': 'Please sign up or log in',
  'app.no_access_permissions': 'Sorry, you are not allowed to access this page.',

  'cards.edit': 'Edit',
  'datatable.new': 'New',
  'datatable.edit': 'Edit',
  'datatable.search': 'Search',
  'datatable.submit': 'Submit',

  admin: 'Admin',
  notifications: 'Notifications',

  'errors.expectedType': 'Expected type {dataType} for field “{label}”, received “{value}” instead.',
  'errors.required': 'Field “{label}” is required.',
  'errors.minString': 'Field “{label}” needs to have at least {min} characters',
  'errors.maxString': 'Field “{label}” is limited to {max} characters.',
  'errors.generic': 'Sorry, something went wrong: <code>{errorMessage}</code>.',
  'errors.generic_report': 'Sorry, something went wrong:  <code>{errorMessage}</code>. <br/>An error report has been generated.',
  'errors.minNumber': 'Field “{label}” must be higher than {min}. ',
  'errors.maxNumber': 'Field “{label}” must be lower than {max}. ',
  'errors.minCount': 'There needs to be at least {count} in field “{label}”.',
  'errors.maxCount': 'Field “{label}” is only allowed {count}.',
  'errors.regEx': 'Field “{label}”: wrong formatting',
  'errors.badDate': 'Field “{label}” is not a date.',
  'errors.notAllowed': 'The value for field “{label}” is not allowed.',
  'errors.noDecimal': 'The value for field “{label}” must not be a decimal number.',
  //TODO other simple schema errors
  'errors.minNumberExclusive': '',
  'errors.maxNumberExclusive': '',
  'errors.keyNotInSchema': '',
});
