<p align="center">
    <a href="https://vuetube.app/">
    <picture>
      <source 
        srcset="https://raw.githubusercontent.com/VueTubeApp/.github/main/readme_assets/dark/VueTube.svg"
        media="(prefers-color-scheme: dark)"
      />
      <img 
        src="https://raw.githubusercontent.com/VueTubeApp/.github/main/readme_assets/light/VueTube.svg" 
        alt="VueTube icon"
        width="500"
       />
    </picture>
  </a>
  </br>
  <details>
  <summary>Show Readme credits</summary>

<sub>VueTube Logo by <a href="https://github.com/afnzmn">@afnzmn</a></sub> </br>
<sub>English Readme contributors: <a href="https://github.com/404-Program-not-found">@404-Program-not-found</a>
, <a href="https://github.com/Frontesque">@Frontesque</a>, <a href="https://github.com/gayolGate">@gayolGate</a>
, <a href="https://github.com/ThatOneCalculator">@ThatOneCalculator</a>, <a href="https://github.com/afnzmn">@afnzmn</a>
, <a href="https://github.com/tired6488">@tired6488</a>, <a href="https://github.com/DARKDRAGON532">@DARKDRAGON532</a>
, <a href="https://github.com/PickleNik">@PickleNik</a> and <a href="https://github.com/Zyborg777">@Zyborg777</a></sub>

</details>

  <p align="center">
  <strong>Простой клиент потокового видео, нацеленный на воссоздание ВСЕХ функций из других популярных приложений (и многое другое!)</strong>
  </br>
  Произносится как View Tube (<code>/ˈvjuːˌtjuːb/</code>)
</p>

<p align="center">
  <a href="https://github.com/VueTubeApp/VueTube/blob/main/LICENSE" alt="License"><img src="https://img.shields.io/github/license/VueTubeApp/VueTube"></img></a>
  <a href="https://github.com/VueTubeApp/VueTube/actions/workflows/ci.yml" alt="CI"><img src="https://github.com/VueTubeApp/VueTube/actions/workflows/ci.yml/badge.svg"></img></a>
  <a href="https://reddit.com/r/vuetube" alt="Reddit"><img src="https://img.shields.io/reddit/subreddit-subscribers/vuetube?label=r%2FVuetube&logo=reddit&logoColor=white"></img></a>
  <a href="https://t.me/VueTube" alt="Telegram"><img src="https://img.shields.io/endpoint?label=VueTube&url=https://tg.sumanjay.workers.dev/VueTube"></img></a>
  <a href="https://discord.gg/7P8KJrdd5W" alt="Discord"><img src="https://img.shields.io/discord/946587366242533377?label=Discord&style=flat&logo=discord&logoColor=white"></img></a>
  <a href="https://twitter.com/VueTubeApp" alt="Twitter"><img src="https://img.shields.io/twitter/follow/VueTubeApp?label=Follow&style=flat&logo=twitter"></img></a>
</p>

**Доступные языки**: [English,](readme.md) [Español,](/readme/readme.es.md) [简体中文,](/readme/readme.zh-hans.md) [繁體中文,](/readme/readme.zh-hant.md) [日本語,](/readme/readme.ja.md) [עִברִית,](/readme/readme.he.md) [Nederlands,](/readme/readme.nl.md) [தமிழ்,](/readme/readme.ta.md) [Bahasa Melayu,](/readme/readme.ms.md) [Македонски,](/readme/readme.mk.md) [Français,](/readme/readme.fr.md) [Português Brasileiro,](/readme/readme.pt-br.md) [Bahasa Indonesia,](/readme/readme.id.md) [Polski,](/readme/readme.pl.md) [Български,](/readme/readme.bg.md) [Italiano,](/readme/readme.it.md) [Magyar,](/readme/readme.hu.md) [한국어,](/readme/readme.kr.md) [Tiếng Việt,](/readme/readme.vi.md) [Română,](/readme/readme.ro.md) [Українська](/readme/readme.ua.md), [Türkçe,](/readme/readme.tr.md/) [Русский](/readme/readme.ru.md)

<h2 align="left">
<sub>
<img  src="../resources/readme_icon_features.png"
      height="30"
      width="30">
</sub>
Особенности
</h2>

<img src="../resources/readme-ru/Features.ru.svg" alt="VueTube icon" height="100"/>

- 🎨 **Темы:** Светлая, темная, OLED и все цвета радуги! Настраивайте главные цвета и цвет заднего фона в соответствии с вашими предпочтениями.
- 🖌️ **Настройка UI:** Настраивайте кнопки, углы и отключайте части интерфейса, которые вы не используете, для комфортного использования.
- ⬆️ **Автообновления:** Будьте в курсе новых обновлений, скачивайте их прямиком в приложении или же откатывайтесь к более ранней версии, если они вам не понравились!
- 👁️ **Защита от телеметрии:** Никаких данных телеметрии не отправляется с вашего устройства и мы не используем внешние API. Конфиденциальность - главный приоритет!
- 📺 **Собственный видеоплеер:** Встроенный видеоплеер со всем необходимым, включая 16х скорость.
- 🌍 **Языки:** Приложение доступно на более чем 25 языках! Язык по умолчанию определяется настройками вашего телефона.
- 👎 **Возвращение дизлайков** - Сделайте счетчик видимым снова. [_Подробнее_](https://returnyoutubedislike.com)
- 💰 **SponsorBlock** - Автоматически пропускайте рекламные и раздражающие сегменты в видео. [_Подробнее_](https://sponsor.ajay.app)

<h2 align="left">
<sub>
<img  src="../resources/readme_icon_install.png"
      height="30"
      width="30">
</sub>
Установка
</h2>

<img src="../resources/readme-ru/Install.ru.svg" alt="VueTube icon" height="100"/>

Для установки перейдите на [vuetube.app/install](https://www.vuetube.app/install) или просмотрите ниже список доступных версий:

<details>
  <summary>🖱️ Нажмите, чтобы показать доступные версии </summary>
<br />

<h3 align="left">
<sub>
<img  src="../resources/readme_icon_android.png"
      height="20"
      width="20">
</sub>
Android
</h3>

| <a href=https://nightly.link/VueTubeApp/VueTube/workflows/ci/main/android.zip><img id="im" width="200" src=../resources/getunstable.png></a> | <a href=https://github.com/VueTubeApp/VueTube/releases/tag/0.5><img id="im" width="200" src=../resources/getcanary.png></a> | <a href=https://vuetube.app/install><img id="im" width="200" src=../resources/getstable.png></a> |
| ------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------- |
| Нестабильная, но имеет ранний доступ к новым возможностям.                                                                                  | Меньше ошибок, чем в Unstable, но больше возможностей чем в Stable.                                                              | Пока не доступна.                                                                              |

<h3 align="left">
<sub>
<img  src="../resources/readme_icon_ios.png"
      height="20"
      width="20">
</sub>
iOS
</h3>

| <a href=https://nightly.link/VueTubeApp/VueTube/workflows/ci/main/iOS.zip><img id="im" width="200" src=../resources/getunstable.png></a> | <a href=https://github.com/VueTubeApp/VueTube/releases/tag/0.3><img id="im" width="200" src=../resources/getcanary.png></a> | <a href=https://vuetube.app/install><img id="im" width="200" src=../resources/getstable.png></a> |
| --------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ----------------------------------------------------------------------------------------------- |
| Нестабильная, но имеет ранний доступ к новым возможностям.                                                                              | Меньше ошибок, чем в Unstable, но больше возможностей чем в Stable.                                                                                                            | Пока не доступна.                                                                             |

(Apple официально не поддерживает sideloading, т.е. установку приложения с файла без загрузки их в официальный магазин приложений компании. Необходимо использовать продвинутые методы установки VueTube на iPhone / iPad устройствах)

</details>

<h2 align="left">
<sub>
<img  src="../resources/readme_icon_plans.png"
      height="30"
      width="30">
</sub>
Планы
</h2>

<img src="../resources/readme-ru/Plans.ru.svg" alt="VueTube icon" height="100"/>

- 🔍 **Продвинутый поиск:** Сортируйте результаты по дате, длительности, лайках или по любому другому параметру.
- 🗞️ **Локальная история просмотров:** Получите доступ к истории просмотров без необходимости авторизации в аккаунт.
- ✂️ **YouTube Shorts:** Небольшие вертикальные ролики с длительностью от 15 до 60 секунд.
- 🧑 **Вход с вашим аккаунтом Google**: Войдите, чтобы получить возможности комментировать, оценивать видео и подписываться на каналы.
- 🖼️ **Режим Picture-in-Picture (PiP):** Смотрите видео в плавающем окне, пока пользуетесь другими приложениями.
- 🧩 **Плагины:** Устанавливайте пользовательские плагины, созданные сообществом, с полезными функциями!
- И многое другое!

Вы можете поделиться своими предложениями, открывая issue в этом репозитории.

<h2 align="left">
<sub>
<img  src="../resources/readme_icon_screenshots.png"
      height="30"
      width="30">
</sub>
Скриншоты
</h2>

[Смотрите их на нашем вебсайте](https://www.vuetube.app/info/screenshots) или нажмите ниже, чтобы показать их.

<details>
  <summary> 🖱️ Нажмите, чтобы показать скриншоты </summary>
<br />

<img src="https://vuetube.app/wtch.png" width="400">
<img src="https://vuetube.app/stng.png" width="400">
<img src="https://vuetube.app/srch.png" width="400">

</details>

<h2 align="left">
<sub>
<img  src="../resources/readme_icon_community.png"
      height="30"
      width="30">
</sub>
Сообщество
</h2>

Мы используем несколько разных платформ для связи с нашим сообществом. Вы можете активно принять участие в разработке
VueTube или просто быть в курсе всех новостей, присоединившись к этим группам:

- Discord сервер (https://vuetube.app/discord)
- Группа в Telegram (https://t.me/vuetube)
- Страница на Reddit (https://www.reddit.com/r/vuetube)

<h2 align="left">
<sub>
<img  src="../resources/readme_icon_progress.png"
      height="30"
      width="30">
</sub>
Прогресс разработки
</h2>

<details>
  <summary> 🖱️ Нажмите, чтобы показать карту </summary>

 <br>

|                   **Общие**                    |              **Проигрыватель**               | [**Extractor**](https://github.com/VueTubeApp/VueTube-Extractor) |
| :----------------------------------------------: | :-----------------------------------: | :--------------------------------------------------------------: |
|             🟢 Комментарии (100%)                |        🟢 Возобновить / Пауза (100%)   |                🟢 Автозаполнение поиска (100%)                   |
|              🟢 Описание (100%)               | 🟢 Показать / спрятать эл. управления (100%) |                       🟢 Начальная страница (100%)                        |
|               🟢 Начальная страница (100%)                |      🟠 Seekbar / Scrubber (80%)      |                         🟢 Поиск (100%)                         |
|            🟢 Интеграция с RYD (100%)             |          🟠 Полноэкранный режим (80%)          |                    🟠 Информация о видео (60%)                    |
|                 🟢 Темы (100%)                 |      🟠 Выбор разрешения (50%)       |                         🔴 Каналы (0%)                         |
|               🟢 Страница просмотра (100%)               |          🔴 Мини проигрыватель (0%)           |                         🔴 Комментарии (0%)                         |
|        🟠 Интеграция Sponsorblock (95%)         |        🔴 Фоновое воспроиведение (0%)        |                        🔴 Live чат (0%)                         |
|               🟠 Автообновления (50%)               |      🔴 Picture in Picture (0%)       |                     🔴 Видео в тренде (0%)                     |
|              🟠 Страница канала (50%)               |           🔴 Субтитры (0%)            |                       🔴 Взаимодействия (0%)                       |
|             🟠 Страница сообщества (10%)             |             🔴 Cards (0%)             |                       🔴 Плейлисты (0%)                         |
|         🟠 Настраиваемый UI Shorts (10%)          |                                       |                      🔴 Уведомления (0%)                       |
|        🟠 Настраиваемый UI YT Music (10%)         |                                       |                          🔴 Аккаунт (0%)                           |
|             🟠 Настраиваемый UI (30%)             |                                       |                                                                  |
|             🟠 Страница библиотеки (10%)              |                                       |                                                                  |
|                 🟠 Ответы (50%)                 |                                       |                                                                  |
|           🟠 Сторонние плагины (40%)           |                                       |                                                                  |
|  🟠 Проигрыватель VueTube (См. центральную колонку)   |                                       |                                                                  |
| 🟠 VueTube Extractor (См. правую колонку) |                                       |                                                                  |
|           🔴 Локальная история просмотров (0%)            |                                       |                                                                  |
|            🔴 Страница подписок (0%)            |                                       |                                                                  |
|          🔴 Поддержка других платформ (0%)          |                                       |                                                                  |

</details>

### Используемые технологии

<a href="https://capacitorjs.com/solution/vue"><img src="https://cdn.discordapp.com/attachments/953538236716814356/955694368742834176/Capacitator-Dark.svg" height=40/></a> <a href="https://vuetifyjs.com/"><img src="https://cdn.discordapp.com/attachments/810799100940255260/973719873467342908/Vuetify-Dark.svg" height=40/></a> <a href="https://nuxtjs.org/"><img src="https://github.com/tandpfun/skill-icons/raw/main/icons/NuxtJS-Dark.svg" height=40/></a> <a href="https://vuejs.org/"><img src="https://github.com/tandpfun/skill-icons/raw/main/icons/VueJS-Dark.svg" height=40/></a> <a href="https://javascript.com/"><img src="https://github.com/tandpfun/skill-icons/raw/main/icons/JavaScript.svg" height=40/></a> <a href="https://java.com/"><img src="https://github.com/tandpfun/skill-icons/raw/main/icons/Java-Dark.svg" height=40/></a> <a href="https://gradle.com/"><img src="https://cdn.discordapp.com/attachments/810799100940255260/955691550560636958/Gradle.svg" height=40/></a> <a href="https://developer.apple.com/swift/"><img src="https://github.com/tandpfun/skill-icons/raw/main/icons/Swift.svg" height=40/></a>

### В чем цель проекта?

VueTube был создан с целью предоставить бесплатную кроссплатформенную open source альтернативу приложениям крупных компаний с богатыми возможностями тонкой настройки и работы с аккаунтом. Проект рос, привлекая тысячи пользователей и участников со всего мира. Вы можете присоединиться и поддержать проект любыми способами...

### Хотите помочь развитию проекта?

Спасибо за проявленный интерес! Пожалуйста, посетите наш сайт с информацией о том, как это сделать: [vuetube.app/contributing](https://www.vuetube.app/contributing).

Если вы хотите помочь с переводом, [нажмите тут](/NUXT/plugins/languages) и прочтите инструкцию. Если GitHub сложен и неудобен для вас, вы так же можете поделиться переведенными полями в текстовом файле в нашем [Discord](https://vuetube.app/discord) и мы их добавим.

<h2 align="left">
<sub>
<img  src="../resources/readme_icon_github.png"
      height="30"
      width="30">
</sub>
Участники проекта
</h2>

<a href="https://github.com/VueTubeApp/VueTube/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=VueTubeApp/VueTube" />
</a>

<sub>Панель создана автоматически с помощью [contrib.rocks](https://contrib.rocks). </sub>

<h2 align="left">
<sub>
<img  src="../resources/readme_icon_acknowledgements.png"
      height="30"
      width="30">
</sub>
Благодарность
</h2>

- Emojis от [Twemoji team](https://twemoji.twitter.com/) по лицензии [CC-BY 4.0](https://creativecommons.org/licenses/by/4.0/).
- VueTube Лого от [@afnzmn](https://github.com/afnzmn).
- Публичные данные о дизлайках на YouTube предоставлены [Return Youtube Dislike](https://returnyoutubedislike.com).
- Ajay & Community за [Sponsorblock API](https://sponsor.ajay.app), доступный по лицензии [CC BY-NC-SA 4.0](https://creativecommons.org/licenses/by-nc-sa/4.0/).

<h2 align="left">
<sub>
<img  src="../resources/readme_icon_donate.png"
      height="30"
      width="30">
</sub>
Пожертвования
</h2>

VueTube всегда будет бесплатным проектом с открытым исходным кодом, но вы можете помочь материально, что позволит дальше улучшать проект и разрабатывать новые функции. Приветствуется любая помощь! Ниже доступные варианты пожертвований:

[Поддержите нас на Ko-Fi.com](https://ko-fi.com/vuetube) (Официальный)

[Поддержите PickleNik на GitHub](https://github.com/sponsors/PickleNik) (Глава проекта)

<h2 align="left">
<sub>
<img  src="../resources/readme_icon_disclaimer.png"
      height="30"
      width="30">
</sub>
Дисклеймер
</h2>

Проект VueTube и его содержимое не связаны, не финансируются, не санкционированы, не одобрены или каким-либо образом связаны с YouTube, Google LLC или любыми их филиалами и дочерними компаниями. Официальный веб-сайт YouTube можно найти по адресу [www.youtube.com](https://www.youtube.com).

Любые товарные знаки, знаки обслуживания, коммерческие названия или другие права интеллектуальной собственности, используемые в проекте VueTube, принадлежат соответствующим владельцам.

<h2 align="left">
<sub>
<img  src="../resources/readme_icon_otherrepos.png"
      height="30"
      width="30">
</sub>
Другие репозитории VueTube
</h2>

<details>
  <summary> 🖱️ Нажмите, чтобы показать репозитории </summary>

<br>

<a href="https://github.com/VueTubeApp/VueTube-Extractor">
    <picture>
      <source 
        srcset="https://github-readme-stats.vercel.app/api/pin/?username=VueTubeApp&repo=VueTube-Extractor&theme=dark"
        media="(prefers-color-scheme: dark)"
      />
      <source 
        srcset="https://github-readme-stats.vercel.app/api/pin/?username=VueTubeApp&repo=VueTube-Extractor&theme=highcontrast"
        media="(prefers-color-scheme: dark_colorblind)"
      />
      <img 
        src="https://github-readme-stats.vercel.app/api/pin/?username=VueTubeApp&repo=VueTube-Extractor" 
        alt="VueTube Extractor"
       />
    </picture>
</a>

**VueTube Extractor** - библиотека для получения данных со стриминговых сервисов, разработанный специально для VueTube App.

<a href="https://github.com/VueTubeApp/VueTube-Translator">
    <picture>
      <source 
        srcset="https://github-readme-stats.vercel.app/api/pin/?username=VueTubeApp&repo=VueTube-Translator&theme=dark"
        media="(prefers-color-scheme: dark)"
      />
      <source 
        srcset="https://github-readme-stats.vercel.app/api/pin/?username=VueTubeApp&repo=VueTube-Translator&theme=highcontrast"
        media="(prefers-color-scheme: dark_colorblind)"
      />
      <img 
        src="https://github-readme-stats.vercel.app/api/pin/?username=VueTubeApp&repo=VueTube-Translator" 
        alt="VueTube Extractor"
       />
    </picture>
</a>

**VueTube Translator** - это инструмент для перевода полей файлов JSON или JS на GitHub и их экспорта в нужном формате. Он создан, чтобы помочь переводчикам VueTube, но он может быть использован для других целей.

<a href="https://github.com/VueTubeApp/vuetube-http">
    <picture>
      <source 
        srcset="https://github-readme-stats.vercel.app/api/pin/?username=VueTubeApp&repo=vuetube-http&theme=dark"
        media="(prefers-color-scheme: dark)"
      />
      <source 
        srcset="https://github-readme-stats.vercel.app/api/pin/?username=VueTubeApp&repo=vuetube-http&theme=highcontrast"
        media="(prefers-color-scheme: dark_colorblind)"
      />
      <img 
        src="https://github-readme-stats.vercel.app/api/pin/?username=VueTubeApp&repo=vuetube-http" 
        alt="VueTube Extractor"
       />
    </picture>
</a>

**VueTube HTTP** - плагин для нативных запросов HTTP, скачивания/загрузки файлов и работы с куки. Это форк 
[оригинального HTTP проекта](https://github.com/capacitor-community/http) от сообщества Capacitor с доработками от команды VueTube.

</details>

<hr>

<p align="center">
<img src="../resources/bottom_banner_readme.png" width="800">
</p>
