<p align="center">
    <a href="https://vuetube.app/">
    <picture>
      <source 
        srcset="https://raw.githubusercontent.com/VueTubeApp/.github/main/readme_assets/dark/VueTube.svg"
        media="(prefers-color-scheme: dark)"
      />
      <img 
        src="https://raw.githubusercontent.com/VueTubeApp/.github/main/readme_assets/light/VueTube.svg" 
        alt="Logo VueTube"
        width="500"
       />
    </picture>
  </a>
  </br>
  <details>
  <summary>Pokaż autorów Readme</summary>

<sub>Logo autorstwa <a href="https://github.com/afnzmn">@afnzmn</a></sub> <br/>
<sub>Polskie tłumaczenie: <a href="https://github.com/Spiryt7">@Spiryt7</a>, <a href="https://github.com/Desovsky">@Desovsky</a></sub>

</details>

<p align="center">
<strong>Prosty, otwartoźródłowy klient do strumieniowego odtwarzania wideo, którego celem jest odtworzenie WSZYSTKICH funkcji z odpowiednich aplikacji (i więcej!)</strong>
</br>
Wymawia się: View Tube (<code>/ˈvjuːˌtjuːb/</code>)
</p>

<p align="center">
  <a href="https://github.com/VueTubeApp/VueTube/blob/main/LICENSE" alt="License"><img src="https://img.shields.io/github/license/VueTubeApp/VueTube"></img></a>
  <a href="https://github.com/VueTubeApp/VueTube/actions/workflows/ci.yml" alt="CI"><img src="https://github.com/VueTubeApp/VueTube/actions/workflows/ci.yml/badge.svg"></img></a>
  <a href="https://reddit.com/r/vuetube" alt="Reddit"><img src="https://img.shields.io/reddit/subreddit-subscribers/vuetube?label=r%2FVuetube&logo=reddit&logoColor=white"></img></a>
  <a href="https://t.me/VueTube" alt="Telegram"><img src="https://img.shields.io/endpoint?label=VueTube&url=https%3A%2F%2Ftelegram-badge-4mbpu8e0fit4.runkit.sh%2F%3Furl%3Dhttps%3A%2F%2Ft.me%2FVuetube"></img></a>
  <a href="https://discord.gg/7P8KJrdd5W" alt="Discord"><img src="https://img.shields.io/discord/946587366242533377?label=Discord&style=flat&logo=discord&logoColor=white"></img></a>
  <a href="https://twitter.com/VueTubeApp" alt="Twitter"><img src="https://img.shields.io/twitter/follow/VueTubeApp?label=Follow&style=flat&logo=twitter"></img></a>
</p>

**Przeczytaj tą stronę w innych językach**: [English,](../readme.md) [Español,](/readme/readme.es.md) [简体中文,](/readme/readme.zh-hans.md) [繁體中文,](/readme/readme.zh-hant.md) [日本語,](/readme/readme.ja.md) [עִברִית,](/readme/readme.he.md) [Nederlands,](/readme/readme.nl.md) [தமிழ்,](/readme/readme.ta.md) [Bahasa Melayu,](/readme/readme.ms.md) [Македонски,](/readme/readme.mk.md) [Français,](/readme/readme.fr.md) [Português Brasileiro,](/readme/readme.pt-br.md) [Bahasa Indonesia,](/readme/readme.id.md) [Polski,](/readme/readme.pl.md) [Български,](/readme/readme.bg.md) [Italiano,](/readme/readme.it.md) [Magyar,](/readme/readme.hu.md) [한국어,](/readme/readme.kr.md) [Tiếng Việt,](/readme/readme.vi.md) [Română,](/readme/readme.ro.md) [Українська,](/readme/readme.ua.md) [Türkçe,](/readme/readme.tr.md/) [Русский](/readme/readme.ru.md)

<h2 align="left">
<sub>
<img  src="../resources/readme_icon_features.png"
      height="30"
      width="30">
</sub>
Funkcje
</h2>

<img src="../resources/readme-pl/Features.pl.svg" alt="Logo VueTube" height="100"/>

- 🎨 **Motywy** - Jasny, Ciemny, OLED i wszystkie kolory tęczy! Ustaw kolor akcentu i tła według swoich upodobań.
- 🖌️ **Personalizacja interfejsu** - Możesz dostosować przyciski, krawędzie, a nawet wyłączyć elementy interfejsu, których nie używasz, przez co uzyskasz interfejs najlepiej dostosowany do Ciebie.
- ⬆️ **Automatyczne aktualizacje** - Otrzymuj powiadomienia o dostępności aktualizacji, pobieraj przez aplikację i cofaj aktualizacje, jeśli coś ci się nie spodoba!
- 👁️ **Ochrona przed śledzeniem** - Domyślnie aplikacja nie wysyła żadnych danych telemetrycznych z twojego urządzenia, a także nie korzysta z zewnętrznych API. Prywatność jest ważna!
- 📺 **Własny odtwarzacz wideo** - Aplikacja oferuje odtwarzacz z wieloma przydatnymi funkcjami, jak 16-krotne przyśpieszenie wideo.
- 🌍 **Tłumaczenia** - Aplikacja jest dostępna w ponad 25 językach! Domyślny język jest ustawiany na podstawie ustawień twojego urządzenia.
- 👎 **Return YouTube Dislike** - Popularne rozszerzenie przywracające łapki w dół. [_Więcej informacji tutaj_](https://returnyoutubedislike.com)
- 💰 **SponsorBlock** - Rozszerzenie automatycznie pomijające bloki sponsorskie i irytujące fragmenty w filmach. [_Więcej informacji tutaj_](https://sponsor.ajay.app)

<h2 align="left">
<sub>
<img  src="../resources/readme_icon_install.png"
      height="30"
      width="30">
</sub>
Instalacja
</h2>

<img src="../resources/readme-pl/Install.pl.svg" alt="Logo VueTube" height="100"/>

Aby zainstalować aplikację, odwiedź www.vuetube.app/install lub sprawdź poniżej wszystkie dostępne wersje:

<details>
  <summary>🖱️ Kliknij, aby wyświetlić wersje</summary>
<br />

<h3 align="left">
<sub>
<img  src="../resources/readme_icon_android.png"
      height="20"
      width="20">
</sub>
Android
</h3>

| <a href=https://nightly.link/VueTubeApp/VueTube/workflows/ci/main/android.zip><img id="im" width="200" src=../resources/getunstable.png></a> | <a href=https://github.com/VueTubeApp/VueTube/releases/download/0.2/VueTube-Canary-June-15-2022.apk><img id="im" width="200" src=../resources/getcanary.png></a> | <a href=https://vuetube.app/install><img id="im" width="200" src=../resources/getstable.png></a> |
| -------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------ |
| Niestabilna, ale masz wczesny dostęp do nowych funkcji.                                                                                  | Mniej błędów niż w wersji niestabilnej, nieco więcej funkcji niż w wersji stabilnej.                                                              | Jeszcze niedostępna.                                                                              |

<h3 align="left">
<sub>
<img  src="../resources/readme_icon_ios.png"
      height="20"
      width="20">
</sub>
iOS
</h3>

| <a href=https://nightly.link/VueTubeApp/VueTube/workflows/ci/main/iOS.zip><img id="im" width="200" src=../resources/getunstable.png></a> | <a href=https://cdn.discordapp.com/attachments/949908267855921163/972164558930198528/VueTube-Canary-May-6-2022.ipa><img id="im" width="200" src=../resources/getcanary.png></a> | <a href=https://vuetube.app/install><img id="im" width="200" src=../resources/getstable.png></a> |
| -------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------ |
| Niestabilna, ale masz wczesny dostęp do nowych funkcji.                                                                                  | Mniej błędów niż w wersji niestabilnej, nieco więcej funkcji niż w wersji stabilnej.                                                              | Jeszcze niedostępna.                                                                              |

(Apple nie wspiera sideloadingu, tj. instalacji aplikacji z pliku bez umieszczania jej w oficjalnym sklepie AppStore. Z tego powodu instalacja VueTube na urządzeniach iPhone / iPad wymaga bardziej zaawansowanych i trudniejszych metod instalacji.)

</details>

<h2 align="left">
<sub>
<img  src="../resources/readme_icon_plans.png"
      height="30"
      width="30">
</sub>
Plany
</h2>

<img src="../resources/readme-pl/Plans.pl.svg" alt="VueTube icon" height="100"/>

- 🔍 **Zaawansowane wyszukiwanie:** Sortowanie po dacie dodania, czasie trwania, polubieniach i innych wartościach.
- 🗞️ **Lokalna historia:** Wyświetlaj ostatnio oglądanie filmy bez logowania.
- ✂️ **YouTube Shorts:** Krótkie pionowe filmy trwające od 15 do 60 sekund.
- 🧑 **Logowanie kontem Google**: Zaloguj się, aby móc lajkować i komentować filmy, subskrybować kanały i więcej.
- 🖼️ **Funkcja *obraz w obrazie* (PiP):** Pozwala ci oglądać filmy w pływającym okienku podczas używania innych aplikacji.
- 🧩 **Wtyczki:** Instaluj wtyczki tworzone przez społeczność i dodawaj przydatne funkcje.
- I więcej!

Możesz zasugerować własne funkcje otwierając "feature request issue" w tym repozytorium. (*Issues* -> *New issue* -> *⭐ Feature request*)

<h2 align="left">
<sub>
<img  src="../resources/readme_icon_screenshots.png"
      height="30"
      width="30">
</sub>
Zrzuty ekranu
</h2>

[Zobacz je na naszej stronie internetowej (w języku angielskim)](https://www.vuetube.app/info/screenshots) lub kliknij poniżej, aby je wyświetlić.

<details>
  <summary> 🖱️ Kliknij, aby wyświetlić zrzuty ekranu </summary>
<br />

<img src="https://vuetube.app/wtch.png" width="400">
<img src="https://vuetube.app/stng.png" width="400">
<img src="https://vuetube.app/srch.png" width="400">

</details>

<h2 align="left">
<sub>
<img  src="../resources/readme_icon_community.png"
      height="30"
      width="30">
</sub>
Społeczność
</h2>

Używamy rożnych platform do kontaktu ze społecznością. Możesz uczestniczyć w rozwoju VueTube albo po prostu śledzić najnowsze wiadomości poprzez odwiedzenie:

- Serwera Discord (https://vuetube.app/discord)
- Grupy na Telegramie (https://t.me/vuetube)
- Subreddita (https://www.reddit.com/r/vuetube)

<h2 align="left">
<sub>
<img  src="../resources/readme_icon_progress.png"
      height="30"
      width="30">
</sub>
Postępy
</h2>

<details>
  <summary> 🖱️ Kliknij, aby wyświetlić postępy </summary>

 <br>

| **Ogólne**                            | **Player**                                       | [**Extractor**](https://github.com/VueTubeApp/VueTube-Extractor) |
|:-------------------------------------:|:------------------------------------------------:|:----------------------------------------------------------------:|
| 🟢 Komentarze (100%)                  | 🟢 Odtwarzaj / Zatrzymaj (100%)                  | 🟢 Autouzupełnianie wyszukiwania (100%)                          |
| 🟢 Opisy (100%)                       | 🟢 Kliknij by pokazać / schować przyciski (100%) | 🟢 Strona główna (100%)                                          |
| 🟢 Strona główna (100%)               | 🟠 Pasek postępu (80%)                           | 🟢 Wyszukiwanie (100%)                                           |
| 🟢 Integracja RYD (100%)              | 🟠 Pełny ekran (80%)                             | 🟠 Informacje o wideo (60%)                                      |
| 🟢 Motywy (100%)                      | 🟠 Panel wyboru rozdzielczości (50%)             | 🔴 Kanały (0%)                                                   |
| 🟢 Watch Page (100%)                  | 🔴 Miniodtwarzacz (0%)                           | 🔴 Komentarze (0%)                                               |
| 🟠 Integracja Sponsorblock (95%)      | 🔴 Odtwarzanie w tle (0%)                        | 🔴 Live Chat (0%)                                                |
| 🟠 Automatyczne aktualizacje (50%)    | 🔴 Obraz w obrazie (0%)                          | 🔴 Trendy (0%)                                                   |
| 🟠 Strona kanału (50%)                | 🔴 Napisy (0%)                                   | 🔴 Interakcje (0%)                                               |
| 🟠 Posty społeczności (10%)           | 🔴 Karty informacyjne (0%)                       | 🔴 Playlisty (0%)                                                |
| 🟠 Modyfikowalne UI YT Shorts (10%)   |                                                  | 🔴 Powiadomienia (0%)                                            |
| 🟠 Modyfikowalne UI YT Music UI (10%) |                                                  | 🔴 Logowanie (0%)                                                |
| 🟠 Modyfikowalne UI (30%)             |                                                  |                                                                  |
| 🟠 Biblioteka (10%)                   |                                                  |                                                                  |
| 🟠 Odpowiedzi (50%)                   |                                                  |                                                                  |
| 🟠 Wtyczki społeczności (40%)         |                                                  |                                                                  |
| 🟠 VueTube Player (Patrz obok)        |                                                  |                                                                  |
| 🟠 VueTube Extractor (Patrz obok)     |                                                  |                                                                  |
| 🔴 Lokalna historia (0%)              |                                                  |                                                                  |
| 🔴 Strona subskrypcji (0%)            |                                                  |                                                                  |
| 🔴 Wsparcie innych platform (0%)      |                                                  |                                                                  |


</details>

### Użyte technologie

<a href="https://capacitorjs.com/solution/vue"><img src="https://cdn.discordapp.com/attachments/953538236716814356/955694368742834176/Capacitator-Dark.svg" height=40/></a> <a href="https://vuetifyjs.com/"><img src="https://cdn.discordapp.com/attachments/810799100940255260/973719873467342908/Vuetify-Dark.svg" height=40/></a> <a href="https://nuxtjs.org/"><img src="https://github.com/tandpfun/skill-icons/raw/main/icons/NuxtJS-Dark.svg" height=40/></a> <a href="https://vuejs.org/"><img src="https://github.com/tandpfun/skill-icons/raw/main/icons/VueJS-Dark.svg" height=40/></a> <a href="https://javascript.com/"><img src="https://github.com/tandpfun/skill-icons/raw/main/icons/JavaScript.svg" height=40/></a> <a href="https://java.com/"><img src="https://github.com/tandpfun/skill-icons/raw/main/icons/Java-Dark.svg" height=40/></a> <a href="https://gradle.com/"><img src="https://cdn.discordapp.com/attachments/810799100940255260/955691550560636958/Gradle.svg" height=40/></a> <a href="https://developer.apple.com/swift/"><img src="https://github.com/tandpfun/skill-icons/raw/main/icons/Swift.svg" height=40/></a>

### Dlaczego to robimy?

VueTube powstał jako darmowa, otwartoźródłowa i cross-platformowa alternatywa dla [Big Tech](https://pl.wikipedia.org/wiki/GAFAM), z możliwością dostosowania ustawień dla siebie. Projekt przyciąga tysiące użytkowników i współtwórców z całego świata. Możesz do nas dołączyć i przyczynić się do rozwoju na różne sposoby...

### Chcesz pomóc?

Cieszymy się, że jesteś zainteresowany wsparciem. Zapoznaj się z naszą stroną internetową, aby dowiedzieć się, jak to zrobić: [vuetube.app/contributing](https://www.vuetube.app/contributing).

Jeśli chcesz pomóc przy tłumaczeniu aplikacji, [kliknij tutaj](/NUXT/plugins/languages) i przeczytaj instrukcje. Jeśli GitHub jest dla ciebie niewygodny i nieznany, możesz też przesłać przetłumaczone pola w pliku tekstowym na naszym [Discordzie](https://vuetube.app/discord), a my je zaimplementujemy.

<h2 align="left">
<sub>
<img  src="../resources/readme_icon_github.png"
      height="30"
      width="30">
</sub>
Współtwórcy z GitHuba
</h2>

<a href="https://github.com/VueTubeApp/VueTube/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=VueTubeApp/VueTube" />
</a>

<sub>Wygenerowane automatycznie przy użyciu [contrib.rocks](https://contrib.rocks). </sub>

<h2 align="left">
<sub>
<img  src="../resources/readme_icon_acknowledgements.png"
      height="30"
      width="30">
</sub>
Podziękowania
</h2>

- Emotikony [Twemoji team](https://twemoji.twitter.com/), Licencjonowane w ramach [CC-BY 4.0](https://creativecommons.org/licenses/by/4.0/).
- Logo VueTube autorstwa [@afnzmn](https://github.com/afnzmn).
- Publiczne dane o liczbie łapek w dół dostarczane przez [Return YouTube Dislike](https://returnyoutubedislike.com).
- Ajay & Społeczność za dostarczenie [Sponsorblock API](https://sponsor.ajay.app), Licencjonowane w ramach [CC BY-NC-SA 4.0](https://creativecommons.org/licenses/by-nc-sa/4.0/).

<h2 align="left">
<sub>
<img  src="../resources/readme_icon_donate.png"
      height="30"
      width="30">
</sub>
Wesprzyj nas
</h2>

VueTube jest i zawsze będzie darmowe i otwartoźródłowe, ale możesz wesprzeć naszych deweloperów, wpłacając pewną kwotę, która pomoże nam utrzymać ten projekt i rozwijać nowe funkcje. Każda pomoc jest mile widziana! Dostępne są takie formy donacji:

[Wesprzyj na Ko-Fi.com](https://ko-fi.com/vuetube) (Official)

[Wesprzyj PickleNik na GitHubie](https://github.com/sponsors/PickleNik) (Maintainer)

<h2 align="left">
<sub>
<img  src="../resources/readme_icon_disclaimer.png"
      height="30"
      width="30">
</sub>
Uwaga
</h2>

Projekt VueTube oraz jego zawartość nie są związane, finansowane, autoryzowane, popierane ani w żaden sposób związane z YouTube, Google LLC ani żadną z jej spółek zależnych. Oficjalna strona YouTube znajduje się pod adresem [www.youtube.com](https://www.youtube.com).

Wszelkie znaki towarowe, znaki usługowe, nazwy handlowe oraz inne prawa własności intelektualnej wykorzystane w projekcie VueTube należą do ich odpowiednich właścicieli.

<h2 align="left">
<sub>
<img  src="../resources/readme_icon_otherrepos.png"
      height="30"
      width="30">
</sub>
Inne repozytoria VueTube
</h2>

<details>
  <summary> 🖱️ Kliknij, aby wyświetlić repozytoria </summary>

<br>

<a href="https://github.com/VueTubeApp/VueTube-Extractor">
    <picture>
      <source 
        srcset="https://github-readme-stats.vercel.app/api/pin/?username=VueTubeApp&repo=VueTube-Extractor&theme=dark"
        media="(prefers-color-scheme: dark)"
      />
      <source 
        srcset="https://github-readme-stats.vercel.app/api/pin/?username=VueTubeApp&repo=VueTube-Extractor&theme=highcontrast"
        media="(prefers-color-scheme: dark_colorblind)"
      />
      <img 
        src="https://github-readme-stats.vercel.app/api/pin/?username=VueTubeApp&repo=VueTube-Extractor" 
        alt="VueTube Extractor"
       />
    </picture>
</a>

**VueTube Extractor** to biblioteka umożliwiająca ekstrakcję danych z usług streamingowych, zaprojektowana do użytku w aplikacji VueTube.

<a href="https://github.com/VueTubeApp/VueTube-Translator">
    <picture>
      <source 
        srcset="https://github-readme-stats.vercel.app/api/pin/?username=VueTubeApp&repo=VueTube-Translator&theme=dark"
        media="(prefers-color-scheme: dark)"
      />
      <source 
        srcset="https://github-readme-stats.vercel.app/api/pin/?username=VueTubeApp&repo=VueTube-Translator&theme=highcontrast"
        media="(prefers-color-scheme: dark_colorblind)"
      />
      <img 
        src="https://github-readme-stats.vercel.app/api/pin/?username=VueTubeApp&repo=VueTube-Translator" 
        alt="VueTube Translator"
       />
    </picture>
</a>

**VueTube Translator** to narzędzie do tłumaczenia pól w plikacj GitHub, takich jak JSON lub JS i eksportu wyników w odpowiedniej strukturze. Zostało stworzone, aby pomóc tłumaczom VueTube, ale może być używane w innych celach.

<a href="https://github.com/VueTubeApp/vuetube-http">
    <picture>
      <source 
        srcset="https://github-readme-stats.vercel.app/api/pin/?username=VueTubeApp&repo=vuetube-http&theme=dark"
        media="(prefers-color-scheme: dark)"
      />
      <source 
        srcset="https://github-readme-stats.vercel.app/api/pin/?username=VueTubeApp&repo=vuetube-http&theme=highcontrast"
        media="(prefers-color-scheme: dark_colorblind)"
      />
      <img 
        src="https://github-readme-stats.vercel.app/api/pin/?username=VueTubeApp&repo=vuetube-http" 
        alt="VueTube HTTP"
       />
    </picture>
</a>

**VueTube HTTP** to wtyczka do obsługi natywnych żądań HTTP, pobierania/wgrywania plików i obsługi plików cookie. Jest to fork [orginalnego projektu HTTP](https://github.com/capacitor-community/http) od Capacitor Community z dodatkami zespołu VueTube.

</details>

<hr>

<p align="center">
<img src="../resources/bottom_banner_readme.png" width="800">
</p>
