# Guide for translating the documentation

If you want to translate the app instead, check the [guide for translating the app](/NUXT/plugins/languages/readme.md).
Additionally, please refer to the [offical translator's guide for VueTube](https://vuetube.app/contributing/translation.html) for more information

## ⛔️ Rules and advices

- **Please do not use Internet translators**

Translations made automatically are not allowed in VueTube. You need to know and understand both English and the language you're translating to guarantee a good result. Please do not contribute using Google Translator or similars.

_Example: "Return Youtube Dislike is integrated in VueTube" should be translated to Spanish as "Return YouTube Dislike está integrado en VueTube", but an automatic translation could be "Devolver los No me gusta de YouTube está de conjunto en VueTube", and that doesn't sound natural._

- **Consider leaving some words in English**

Some words might sound better in English. For example, depending of the grade of English casual words in your language, you can consider not translating "Plugins", "Dislike", etc.

_Example: Instead of translating "Shorts UI" to French as "Interface courts", you can use "Interface Shorts"._

## 🟢 How to do the translation

We ask you to first familiarize yourself with the Markdown syntax (opens new window) before translating README files.

There are two ways to translate README files: using the GitHub web interface or using a text editor. If you are not familiar with Git, we recommend using the GitHub web interface.

- **Using the GitHub web interface**

To translate a README file using the GitHub web interface, follow these steps:

Go to the repository of the README file you want to translate. <br>
Press the "Fork" button in the top right corner of the page. <br>
Press the "Add file" button in the top right corner of the page. <br>
Press the "Create new file" button. <br>
Type the name of the README file you want to translate in the "Name your file..." field. For example, if you want to translate the README file in the docs directory, type docs/README-YOUR-LANGUAGE-HERE.md where YOUR-LANGUAGE-HERE is the ISO 639-1 (opens new window)code of the language you are translating to. <br>
Copy the contents of the README file you want to translate from the original repository and paste it into the "Edit new file" field. <br>
Translate the contents of the README file. <br>
Update links to other README files in the translated README file to include the new translation. <br>
Save and submit the changes upstream by pressing the "Propose new file" button and then the "Create pull request" button. <br>

-  **Using a text editor**

The use of a text editor is recommended for more advanced users. We recommend using Visual Studio Code (opens new window). This method assumes you have Git installed and configured on your computer.

To translate a README file using a text editor, follow these steps:

Fork the repository of the README file you want to translate. <br>
Clone the repository to your computer. <br>
Type the name of the README file you want to translate in the "Name your file..." field. For example, if you want to translate the README file in the docs directory, type docs/README-YOUR-LANGUAGE-HERE.md where YOUR-LANGUAGE-HERE is the ISO 639-1 (opens new window)code of the language you are translating to. <br>
Copy the contents of the README file you want to translate from the original repository and paste it into the "Edit new file" field. <br>
Translate the contents of the README file. <br>
Commit and push the changes to your fork, then submit a pull request upstream. <br>

<p align="center"> Thank you for being interested on contributing! </p>

<br>
<br>

**Note:** We rely on your good faith. As a community project, many of our maintainers are not native speakers of the languages that the community has provided. We will do our best to review your translations, but we are heavily dependent on the community to provide us with quality translations. In cases where disagreements arise between translators, we may be forced to mediate and make a decision regardless of our team's proficiency in the language. As such, we ask that disagreements between translators be solved in a civil manner without the need for moderation.
