<p align="center">
  <a href="https://vuetube.app/">
    <picture>
      <source 
        srcset="https://raw.githubusercontent.com/VueTubeApp/.github/main/readme_assets/dark/VueTube.ja.svg"
        media="(prefers-color-scheme: dark)"
      />
      <img 
        src="https://raw.githubusercontent.com/VueTubeApp/.github/main/readme_assets/light/VueTube.ja.svg" 
        alt="VueTube icon"
        width="500"
       />
    </picture>
  </a>
  </br>
  <sub><a href="https://github.com/afnzmn">@afnzmn</a>・ロゴ</sub>
  </br>
  </br>
<strong>各アプリの全機能の再現と改良を目指す、シンプルなオープンソースの動画ストリーミング用クライアント</strong>
</br>
</p>

<p align="center">
  <a href="https://github.com/VueTubeApp/VueTube/blob/main/LICENSE" alt="License"><img src="https://img.shields.io/github/license/VueTubeApp/VueTube"></img></a>
  <a href="https://github.com/VueTubeApp/VueTube/actions/workflows/ci.yml" alt="CI"><img src="https://github.com/VueTubeApp/VueTube/actions/workflows/ci.yml/badge.svg"></img></a>
  <a href="https://reddit.com/r/vuetube" alt="Reddit"><img src="https://img.shields.io/reddit/subreddit-subscribers/vuetube?label=r%2FVuetube&logo=reddit&logoColor=white"></img></a>
  <a href="https://t.me/VueTube" alt="Telegram"><img src="https://img.shields.io/endpoint?label=VueTube&url=https%3A%2F%2Ftelegram-badge-4mbpu8e0fit4.runkit.sh%2F%3Furl%3Dhttps%3A%2F%2Ft.me%2FVuetube"></img></a>
  <a href="https://discord.gg/7P8KJrdd5W" alt="Discord"><img src="https://img.shields.io/discord/946587366242533377?label=Discord&style=flat&logo=discord&logoColor=white"></img></a>
  <a href="https://twitter.com/VueTubeApp" alt="Twitter"><img src="https://img.shields.io/twitter/follow/VueTubeApp?label=Follow&style=flat&logo=twitter"></img></a>
</p>

他の言語で読む：[English,](../readme.md) [Español,](/readme/readme.es.md) [简体中文](/readme/readme.zh-hans.md), [繁體中文](/readme/readme.zh-hant.md), [日本語](/readme/readme.ja.md), [עִברִית](/readme/readme.he.md), [Nederlands](/readme/readme.nl.md), [தமிழ்](/readme/readme.ta.md), [Bahasa Melayu](/readme/readme.ms.md), [Македонски](/readme/readme.mk.md), [Français](/readme/readme.fr.md), [Português Brasileiro](/readme/readme.pt-br.md), [Bahasa Indonesia](/readme/readme.id.md), [Polski](/readme/readme.pl.md), [Български](/readme/readme.bg.md), [Italiano](/readme/readme.it.md), [Magyar](/readme/readme.hu.md), [한국어](/readme/readme.kr.md), [Tiếng Việt](/readme/readme.vi.md), [Română](/readme/readme.ro.md), [Українська](/readme/readme.ua.md), [Türkçe](/readme/readme.tr.md/), [Русский](/readme/readme.ru.md)

## 機能

<img src="../resources/readme-ja/Features.ja.svg" alt="VueTube icon" height="100"/>

- 🎨 **テーマ**：ライト、ダーク、OLED、または虹のすべての色！アクセントカラーと背景色をお好みで調整してください。
- 🖌️ **UIのカスタマイズ**：ボタンや角の丸みを設定し、使わないUIを非表示にして自分好みに最適化しよう。
- ⬆️ **自動更新**：最新版があれば通知しアプリからダウンロード、気に入らなければダウングレードもできます！
- 👁️ **追跡防止**: 初期設定では使用端末から測定データは送信されませし、外部APIも使いません。個人情報を気にしないで！
- 📺 **カスタムビデオプレーヤー**: アプリに統合されたプレイヤーは、 16倍速などあなたが満足するすべての機能を備えます。
- 🌍 **翻訳**: 25以上の言語に翻訳されており、端末の設定から初期設定されます。
- 👎 **Return YouTube Dislike** - YouTubeの低評価の数を復活させます。[詳細](https://www.returnyoutubedislike.com/)
- 💰 **SponsorBlock** - 広告や不要なシーンをスキップ。[詳細](https://sponsorbock.ajay.app/)

## インストール

<img src="../resources/readme-ja/Install.ja.svg" alt="VueTube icon" height="100"/>

インストールはこちらからどうぞ: https://vuetube.app/install

<details>
  <summary>またはここをクリックし、すべてのバージョンを表示</summary>
<br />

### Android

| <a href=https://nightly.link/VueTubeApp/VueTube/workflows/ci/main/android.zip><img id="im" width="200" src=../resources/getunstable.png></a> | <a href=https://github.com/VueTubeApp/VueTube/releases/download/0.2/VueTube-Canary-June-15-2022.apk><img id="im" width="200" src=../resources/getcanary.png></a> | <a href=https://vuetube.app/install><img id="im" width="200" src=../resources/getstable.png></a> |
| -------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------ |
| バグが発生しやすいが新機能をいち早く試せます。                                                                             | Unstable よりバグが少なく、Stable よりも少し機能が多い。                                                                                                 | VueTube は開発段階なのでまだありません。                                 |

### iOS

| <a href=https://nightly.link/VueTubeApp/VueTube/workflows/ci/main/iOS.zip><img id="im" width="200" src=../resources/getunstable.png></a> | <a href=https://cdn.discordapp.com/attachments/949908267855921163/972164558930198528/VueTube-Canary-May-6-2022.ipa><img id="im" width="200" src=../resources/getcanary.png></a> | <a href=https://vuetube.app/install><img id="im" width="200" src=../resources/getstable.png></a> |
| ---------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------ |
| バグが発生しやすいが新機能をいち早く試せます。                                                                             | Unstable よりバグが少なく、Stable よりも少し機能が多い。                                                                                                                    | VueTube は開発段階なのでまだありません。                                 |

</details>

## 計画

<img src="../resources/readme-ja/Plans.ja.svg" alt="VueTube icon" height="100"/>

- 🔍 **詳細検索**: 日時、長さ、高評価などで並び替え。
- 🗞️ **端末内に視聴履歴**: ログインなしで最近視聴した動画を表示。
- ✂️ **ショート**: 60秒までの縦長動画。
- 🧑 **Google アカウントにログイン**: ログインし、動画に投票やコメントを残したり、チャンネル登録など完全な機能を使用。
- 🖼️ **ピクチャーインピクチャー (PiP)**: 他のアプリを使用中でも、小さなグウィンドウで動画を視聴できます。
- 🧩 **プラグイン**: コミュニティによって作られた第三者製の役立つプラグインをインストール！
- ほかにも！

このリポジトリで Issue を開いて機能要望することもできます。

## スクリーンショット

サイトで見る: www.vuetube.app/info/screenshots

<details>
  <summary> またはここをクリックし、スクリーンショットを表示</summary>
<br />
  
<img src="https://vuetube.app/wtch.png" width="400">
<img src="https://vuetube.app/stng.png" width="400">
<img src="https://vuetube.app/srch.png" width="400">
     
</details>

## コミュニティ

いくつかのプラットフォームでコミュニティとやり取りしています。開発に参加することも、または単に情報を得ることもできます:

- Discord (https://vuetube.app/discord)
- Telegram (https://t.me/vuetube)
- Reddit (https://www.reddit.com/r/vuetube)

## 使用技術

<a href="https://capacitorjs.com/solution/vue"><img src="https://cdn.discordapp.com/attachments/953538236716814356/955694368742834176/Capacitator-Dark.svg" height=40/></a> <a href="https://vuetifyjs.com/"><img src="https://cdn.discordapp.com/attachments/810799100940255260/973719873467342908/Vuetify-Dark.svg" height=40/></a> <a href="https://nuxtjs.org/"><img src="https://github.com/tandpfun/skill-icons/raw/main/icons/NuxtJS-Dark.svg" height=40/></a> <a href="https://vuejs.org/"><img src="https://github.com/tandpfun/skill-icons/raw/main/icons/VueJS-Dark.svg" height=40/></a> <a href="https://javascript.com/"><img src="https://github.com/tandpfun/skill-icons/raw/main/icons/JavaScript.svg" height=40/></a> <a href="https://java.com/"><img src="https://github.com/tandpfun/skill-icons/raw/main/icons/Java-Dark.svg" height=40/></a> <a href="https://gradle.com/"><img src="https://cdn.discordapp.com/attachments/810799100940255260/955691550560636958/Gradle.svg" height=40/></a> <a href="https://developer.apple.com/swift/"><img src="https://github.com/tandpfun/skill-icons/raw/main/icons/Swift.svg" height=40/></a>

### 貢献方法

貢献に興味があればこちらをお読みください: www.vuetube.app/contributing

## 貢献者

<a href="https://github.com/VueTubeApp/VueTube/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=VueTubeApp/VueTube" />
</a>

<sub>[contrib.rocks](https://contrib.rocks)で作成</sub>

## 謝辞

- 絵文字は[Twemoji](https://twemoji.twitter.com/)作です。ライセンスは[CC-BY 4.0](https://creativecommons.org/licenses/by/4.0/)です。
- VueTube のロゴは[@afnzmn](https://github.com/afnzmn)作です。
- 低評価数は[Return Youtube Dislike](https://returnyoutubedislike.com)の提供です。
- Ajay と Sponsorblock コミュニティは Sponsorblock API の提供元です。ライセンスは[CC BY-NC-SA 4.0](https://creativecommons.org/licenses/by-nc-sa/4.0/)です。
