<p align="center">
    <a href="https://vuetube.app/">
    <picture>
      <source 
        srcset="https://raw.githubusercontent.com/VueTubeApp/.github/main/readme_assets/dark/VueTube.svg"
        media="(prefers-color-scheme: dark)"
      />
      <img 
        src="https://raw.githubusercontent.com/VueTubeApp/.github/main/readme_assets/light/VueTube.svg" 
        alt="VueTube icon"
        width="500"
       />
    </picture>
  </a>
  </br>
  <details>
  <summary>Show Readme credits</summary>

<sub>VueTube Logo by <a href="https://github.com/afnzmn">@afnzmn</a></sub> </br>
<sub>English Readme contributors: <a href="https://github.com/404-Program-not-found">@404-Program-not-found</a>
, <a href="https://github.com/Frontesque">@Frontesque</a>, <a href="https://github.com/gayolGate">@gayolGate</a>
, <a href="https://github.com/ThatOneCalculator">@ThatOneCalculator</a>, <a href="https://github.com/afnzmn">@afnzmn</a>
, <a href="https://github.com/tired6488">@tired6488</a>, <a href="https://github.com/DARKDRAGON532">@DARKDRAGON532</a>
, <a href="https://github.com/PickleNik">@PickleNik</a> and <a href="https://github.com/Zyborg777">@Zyborg777</a></sub>

</details>

  <p align="center">
  <strong>A simple and open source video streaming client aimed to recreate ALL the features from their respective apps (and more!)</strong>
  </br>
  Pronounced View Tube (<code>/ˈvjuːˌtjuːb/</code>)
</p>

<p align="center">
  <a href="https://github.com/VueTubeApp/VueTube/blob/main/LICENSE" alt="License"><img src="https://img.shields.io/github/license/VueTubeApp/VueTube"></img></a>
  <a href="https://github.com/VueTubeApp/VueTube/actions/workflows/ci.yml" alt="CI"><img src="https://github.com/VueTubeApp/VueTube/actions/workflows/ci.yml/badge.svg"></img></a>
  <a href="https://reddit.com/r/vuetube" alt="Reddit"><img src="https://img.shields.io/reddit/subreddit-subscribers/vuetube?label=r%2FVuetube&logo=reddit&logoColor=white"></img></a>
  <a href="https://t.me/VueTube" alt="Telegram"><img src="https://img.shields.io/endpoint?label=VueTube&url=https://tg.sumanjay.workers.dev/VueTube"></img></a>
  <a href="https://discord.gg/7P8KJrdd5W" alt="Discord"><img src="https://img.shields.io/discord/946587366242533377?label=Discord&style=flat&logo=discord&logoColor=white"></img></a>
  <a href="https://twitter.com/VueTubeApp" alt="Twitter"><img src="https://img.shields.io/twitter/follow/VueTubeApp?label=Follow&style=flat&logo=twitter"></img></a>
</p>

**Read this page in other languages**: [English,](readme.md) [Español,](/readme/readme.es.md) [简体中文,](/readme/readme.zh-hans.md) [繁體中文,](/readme/readme.zh-hant.md) [日本語,](/readme/readme.ja.md) [עִברִית,](/readme/readme.he.md) [Nederlands,](/readme/readme.nl.md) [தமிழ்,](/readme/readme.ta.md) [Bahasa Melayu,](/readme/readme.ms.md) [Македонски,](/readme/readme.mk.md) [Français,](/readme/readme.fr.md) [Português Brasileiro,](/readme/readme.pt-br.md) [Bahasa Indonesia,](/readme/readme.id.md) [Polski,](/readme/readme.pl.md) [Български,](/readme/readme.bg.md) [Italiano,](/readme/readme.it.md) [Magyar,](/readme/readme.hu.md) [한국어,](/readme/readme.kr.md) [Tiếng Việt,](/readme/readme.vi.md) [Română,](/readme/readme.ro.md) [Українська](/readme/readme.ua.md), [Türkçe,](/readme/readme.tr.md/) [Русский](/readme/readme.ru.md)

<h2 align="left">
<sub>
<img  src="resources/readme_icon_features.png"
      height="30"
      width="30">
</sub>
Features
</h2>

<img src="./resources/Features.svg" alt="VueTube icon" height="100"/>

- 🎨 **Themes:** Light, dark, OLED and all the colors of the rainbow! Set the accent and background color according to
  your preferences.
- 🖌️ **Customizable UI:** Customize buttons, corners and disable parts of the UI that you don't use to get an optimal
  experience.
- ⬆️ **Auto updates:** Be notified when an update is available, download through the app and downgrade if you don't like
  it!
- 👁️ **Tracking protection:** No telemetry data is sent from your device by default and we don't use external APIs.
  Privacy is neccesary!
- 📺 **Custom video player:** There is a player integrated in the application with everything you need to be happy, such
  as 16x speed.
- 🌍 **Translations:** App is available in more than 25 languages! Default language is determined according to your
  device configuration.
- 👎 **Return YouTube Dislike** - Enable dislike counters in videos again. [_More
  info_](https://returnyoutubedislike.com)
- 💰 **SponsorBlock** - Skip automatically sponsors and annoying segments in videos. [_More
  info_](https://sponsor.ajay.app)

<h2 align="left">
<sub>
<img  src="resources/readme_icon_install.png"
      height="30"
      width="30">
</sub>
Install
</h2>

<img src="./resources/Install.svg" alt="VueTube icon" height="100"/>

To install the app, please visit [vuetube.app/install](https://www.vuetube.app/install) or check below all versions
available:

<details>
  <summary>🖱️ Click to display versions </summary>
<br />

<h3 align="left">
<sub>
<img  src="resources/readme_icon_android.png"
      height="20"
      width="20">
</sub>
Android
</h3>

| <a href=https://nightly.link/VueTubeApp/VueTube/workflows/ci/main/android.zip><img id="im" width="200" src=./resources/getunstable.png></a> | <a href=https://github.com/VueTubeApp/VueTube/releases/tag/0.5><img id="im" width="200" src=./resources/getcanary.png></a> | <a href=https://vuetube.app/install><img id="im" width="200" src=./resources/getstable.png></a> |
| ------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------- |
| Pretty unstable, but you get early access to new features.                                                                                  | Less bugs than unstable while having more features than stable.                                                              | Not available yet.                                                                              |

<h3 align="left">
<sub>
<img  src="resources/readme_icon_ios.png"
      height="20"
      width="20">
</sub>
iOS
</h3>

| <a href=https://nightly.link/VueTubeApp/VueTube/workflows/ci/main/iOS.zip><img id="im" width="200" src=./resources/getunstable.png></a> | <a href=https://github.com/VueTubeApp/VueTube/releases/tag/0.3><img id="im" width="200" src=./resources/getcanary.png></a> | <a href=https://vuetube.app/install><img id="im" width="200" src=./resources/getstable.png></a> |
| --------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ----------------------------------------------------------------------------------------------- |
| Pretty unstable, but you get early access to new features.                                                                              | Less bugs than unstable while having more features than stable.                                                                                                                | Not available yet.                                                                              |

(Apple does not officially support sideloading, i.e. the installation of applications with just the file without them being uploaded to the company's official shop. It is necessary to use advanced methods to install VueTube on iPhone / iPad devices)

</details>

<h2 align="left">
<sub>
<img  src="resources/readme_icon_plans.png"
      height="30"
      width="30">
</sub>
Plans
</h2>

<img src="./resources/Plans.svg" alt="VueTube icon" height="100"/>

- 🔍 **Advanced search:** Sort results by date, duration, likes or any other factor.
- 🗞️ **Local watch history:** Get your last viewed videos without logging in.
- ✂️ **YouTube Shorts:** Small vertical videos that last anywhere from 15 to 60 seconds.
- 🧑 **Signing in with your Google account**: Login to have a full experience by voting and commenting on videos and
  subscribing to channels.
- 🖼️ **Picture-in-Picture mode (PiP):** Allows you to watch videos in a floating window when using another app.
- 🧩 **Plugins:** Install third party plugins made by community with useful features!
- And more!

You can suggest your own feature by opening a feature request issue in this repository.

<h2 align="left">
<sub>
<img  src="resources/readme_icon_screenshots.png"
      height="30"
      width="30">
</sub>
Screenshots
</h2>

[View them on our website](https://www.vuetube.app/info/screenshots) or click below to display them.

<details>
  <summary> 🖱️ Click to display screenshots </summary>
<br />

<img src="https://vuetube.app/wtch.png" width="400">
<img src="https://vuetube.app/stng.png" width="400">
<img src="https://vuetube.app/srch.png" width="400">

</details>

<h2 align="left">
<sub>
<img  src="resources/readme_icon_community.png"
      height="30"
      width="30">
</sub>
Community
</h2>

We use several different platforms to connect with our community. You can actively participate in the development of
VueTube or simply keep up to date with all the news joining these groups:

- Discord server (https://vuetube.app/discord)
- Telegram group (https://t.me/vuetube)
- Reddit page (https://www.reddit.com/r/vuetube)

<h2 align="left">
<sub>
<img  src="resources/readme_icon_progress.png"
      height="30"
      width="30">
</sub>
Progress
</h2>

<details>
  <summary> 🖱️ Click to display progress </summary>

 <br>

|                   **General**                    |              **Player**               | [**Extractor**](https://github.com/VueTubeApp/VueTube-Extractor) |
| :----------------------------------------------: | :-----------------------------------: | :--------------------------------------------------------------: |
|                🟢 Comments (100%)                |        🟢 Play / Pause (100%)         |                  🟢 Search Autocomplete (100%)                   |
|              🟢 Description (100%)               | 🟢 Tap to show / hide controls (100%) |                       🟢 Home page (100%)                        |
|               🟢 Home Page (100%)                |      🟠 Seekbar / Scrubber (80%)      |                         🟢 Search (100%)                         |
|            🟢 RYD Integration (100%)             |          🟠 Fullscreen (80%)          |                    🟠 Video Information (60%)                    |
|                 🟢 Themes (100%)                 |      🟠 Resolution Picker (50%)       |                         🔴 Channels (0%)                         |
|               🟢 Watch Page (100%)               |          🔴 Miniplayer (0%)           |                         🔴 Comments (0%)                         |
|        🟠 Sponsorblock Integration (95%)         |        🔴 Background Play (0%)        |                        🔴 Live Chat (0%)                         |
|               🟠 Auto Update (50%)               |      🔴 Picture in Picture (0%)       |                     🔴 Trending content (0%)                     |
|              🟠 Channel Page (50%)               |           🔴 Captions (0%)            |                       🔴 Interactions (0%)                       |
|             🟠 Community Posts (10%)             |             🔴 Cards (0%)             |                        🔴 Playlists (0%)                         |
|         🟠 Customizable Shorts UI (10%)          |                                       |                      🔴 Notifications (0%)                       |
|        🟠 Customizable YT Music UI (10%)         |                                       |                          🔴 Login (0%)                           |
|             🟠 Customizable UI (30%)             |                                       |                                                                  |
|             🟠 Libraries Page (10%)              |                                       |                                                                  |
|                 🟠 Replies (50%)                 |                                       |                                                                  |
|           🟠 Third Party Plugins (40%)           |                                       |                                                                  |
|  🟠 VueTube Player (See progress to the right)   |                                       |                                                                  |
| 🟠 VueTube Extractor (See progress to the right) |                                       |                                                                  |
|           🔴 Local Watch History (0%)            |                                       |                                                                  |
|            🔴 Subscriptions Page (0%)            |                                       |                                                                  |
|          🔴 Other Platform Support (0%)          |                                       |                                                                  |

</details>

### Technologies used

<a href="https://capacitorjs.com/solution/vue"><img src="https://cdn.discordapp.com/attachments/953538236716814356/955694368742834176/Capacitator-Dark.svg" height=40/></a> <a href="https://vuetifyjs.com/"><img src="https://cdn.discordapp.com/attachments/810799100940255260/973719873467342908/Vuetify-Dark.svg" height=40/></a> <a href="https://nuxtjs.org/"><img src="https://github.com/tandpfun/skill-icons/raw/main/icons/NuxtJS-Dark.svg" height=40/></a> <a href="https://vuejs.org/"><img src="https://github.com/tandpfun/skill-icons/raw/main/icons/VueJS-Dark.svg" height=40/></a> <a href="https://javascript.com/"><img src="https://github.com/tandpfun/skill-icons/raw/main/icons/JavaScript.svg" height=40/></a> <a href="https://java.com/"><img src="https://github.com/tandpfun/skill-icons/raw/main/icons/Java-Dark.svg" height=40/></a> <a href="https://gradle.com/"><img src="https://cdn.discordapp.com/attachments/810799100940255260/955691550560636958/Gradle.svg" height=40/></a> <a href="https://developer.apple.com/swift/"><img src="https://github.com/tandpfun/skill-icons/raw/main/icons/Swift.svg" height=40/></a>

### Why are we doing this?

VueTube was made with the aim of providing to the Internet a free, open source and complete cross-platform alternative
to Big Tech, with highly customizable options and login available. The project was growing, attracting thousands of
users and contributors all around the world. You can join us and contribute to this project in any kind of way...

### Want to contribute?

Thank you for being interested on contributing! Please read our website on how to do
so: [vuetube.app/contributing](https://www.vuetube.app/contributing).

If you want to translate the app, [click here](/NUXT/plugins/languages) and read the instructions. If GitHub is hard or
uncomfortable to you, you can also send the fields translated in a text file on
our [Discord](https://vuetube.app/discord) and we will implement them. Don't worry!

<h2 align="left">
<sub>
<img  src="resources/readme_icon_github.png"
      height="30"
      width="30">
</sub>
GitHub contributors
</h2>

<a href="https://github.com/VueTubeApp/VueTube/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=VueTubeApp/VueTube" />
</a>

<sub>Dashboard made automatically with [contrib.rocks](https://contrib.rocks). </sub>

<h2 align="left">
<sub>
<img  src="resources/readme_icon_acknowledgements.png"
      height="30"
      width="30">
</sub>
Acknowledgements
</h2>

- Emojis by the [Twemoji team](https://twemoji.twitter.com/), Licensed
  under [CC-BY 4.0](https://creativecommons.org/licenses/by/4.0/).
- VueTube Logo by [@afnzmn](https://github.com/afnzmn).
- Public YouTube dislike data provided by [Return Youtube Dislike](https://returnyoutubedislike.com).
- Ajay & Community for providing the [Sponsorblock API](https://sponsor.ajay.app), Licensed
  under [CC BY-NC-SA 4.0](https://creativecommons.org/licenses/by-nc-sa/4.0/).

<h2 align="left">
<sub>
<img  src="resources/readme_icon_donate.png"
      height="30"
      width="30">
</sub>
Donate
</h2>

VueTube is and always will be free and open source, but you can support our devs with a donation that will help to
maintain the project and develop new features. Every kind of help is welcome! These are the donating options available:

[Donate on Ko-Fi.com](https://ko-fi.com/vuetube) (Official)

[Donate to PickleNik on GitHub](https://github.com/sponsors/PickleNik) (Maintainer)

<h2 align="left">
<sub>
<img  src="resources/readme_icon_disclaimer.png"
      height="30"
      width="30">
</sub>
Disclaimer
</h2>

The VueTube project and its contents are not affiliated with, funded, authorized, endorsed by, or in any way associated
with YouTube, Google LLC or any of its affiliates and subsidiaries. The official YouTube website can be found
at [www.youtube.com](https://www.youtube.com).

Any trademark, service mark, trade name, or other intellectual property rights used in the VueTube project are owned by
the respective owners.

<h2 align="left">
<sub>
<img  src="resources/readme_icon_otherrepos.png"
      height="30"
      width="30">
</sub>
Other VueTube repos
</h2>

<details>
  <summary> 🖱️ Click to display repos </summary>

<br>

<a href="https://github.com/VueTubeApp/VueTube-Extractor">
    <picture>
      <source 
        srcset="https://github-readme-stats.vercel.app/api/pin/?username=VueTubeApp&repo=VueTube-Extractor&theme=dark"
        media="(prefers-color-scheme: dark)"
      />
      <source 
        srcset="https://github-readme-stats.vercel.app/api/pin/?username=VueTubeApp&repo=VueTube-Extractor&theme=highcontrast"
        media="(prefers-color-scheme: dark_colorblind)"
      />
      <img 
        src="https://github-readme-stats.vercel.app/api/pin/?username=VueTubeApp&repo=VueTube-Extractor" 
        alt="VueTube Extractor"
       />
    </picture>
</a>

**VueTube Extractor** is a library designed to extract data from streaming services, designed for use in VueTube App.

<a href="https://github.com/VueTubeApp/VueTube-Translator">
    <picture>
      <source 
        srcset="https://github-readme-stats.vercel.app/api/pin/?username=VueTubeApp&repo=VueTube-Translator&theme=dark"
        media="(prefers-color-scheme: dark)"
      />
      <source 
        srcset="https://github-readme-stats.vercel.app/api/pin/?username=VueTubeApp&repo=VueTube-Translator&theme=highcontrast"
        media="(prefers-color-scheme: dark_colorblind)"
      />
      <img 
        src="https://github-readme-stats.vercel.app/api/pin/?username=VueTubeApp&repo=VueTube-Translator" 
        alt="VueTube Extractor"
       />
    </picture>
</a>

**VueTube Translator** is a tool for translating fields of GitHub files like JSON or JS and export the result with the
correct structure. It was created to help VueTube translators, but it can be used for any other purpose.

<a href="https://github.com/VueTubeApp/vuetube-http">
    <picture>
      <source 
        srcset="https://github-readme-stats.vercel.app/api/pin/?username=VueTubeApp&repo=vuetube-http&theme=dark"
        media="(prefers-color-scheme: dark)"
      />
      <source 
        srcset="https://github-readme-stats.vercel.app/api/pin/?username=VueTubeApp&repo=vuetube-http&theme=highcontrast"
        media="(prefers-color-scheme: dark_colorblind)"
      />
      <img 
        src="https://github-readme-stats.vercel.app/api/pin/?username=VueTubeApp&repo=vuetube-http" 
        alt="VueTube Extractor"
       />
    </picture>
</a>

**VueTube HTTP** is a plugin for native HTTP requests, file download/uploads, and cookie management. It's a fork of
the [original HTTP project](https://github.com/capacitor-community/http) from Capacitor Community, with additions by the
VueTube Team.

</details>

<hr>

<p align="center">
<img src="resources/bottom_banner_readme.png" width="800">
</p>
