// AUTOGENERATED COPYRIGHT HEADER START
// Copyright (C) 2017-2023 Michael Fabian 'Xaymar' Dirks <info@xaymar.com>
// Copyright (C) 2022 lainon <GermanAizek@yandex.ru>
// AUTOGENERATED COPYRIGHT HEADER END

#include "utility.hpp"
#include "common.hpp"
#include "plugin.hpp"

#include "warning-disable.hpp"
#include <sstream>
#include <stdexcept>
#include <unordered_map>
#include "warning-enable.hpp"

obs_property_t* streamfx::util::obs_properties_add_tristate(obs_properties_t* props, const char* name, const char* desc)
{
	obs_property_t* p = obs_properties_add_list(props, name, desc, OBS_COMBO_TYPE_LIST, OBS_COMBO_FORMAT_INT);
	obs_property_list_add_int(p, D_TRANSLATE(S_STATE_DEFAULT), -1);
	obs_property_list_add_int(p, D_TRANSLATE(S_STATE_DISABLED), 0);
	obs_property_list_add_int(p, D_TRANSLATE(S_STATE_ENABLED), 1);
	return p;
}

std::pair<int64_t, int64_t> streamfx::util::size_from_string(std::string_view text, bool allowSquare)
{
	int64_t width, height;

	const auto* begin = text.data();
	const auto* end   = text.data() + text.size() + 1;
	char*       here  = const_cast<char*>(end);

	long long res = strtoll(begin, &here, 0);
	if (errno == ERANGE) {
		return {0, 0};
	}
	width = res;

	while (here != end) {
		if (isdigit(*here) || (*here == '-') || (*here == '+')) {
			break;
		}
		here++;
	}
	if (here == end) {
		// Are we allowed to return a square?
		if (allowSquare) {
			// Yes: Return width,width.
			return {width, width};
		} else {
			// No: Return width,0.
			return {width, 0};
		}
	}

	res = strtoll(here, nullptr, 0);
	if (errno == ERANGE) {
		return {width, 0};
	}
	height = res;

	return {width, height};
}

void* streamfx::util::memory::malloc_aligned(std::size_t align, std::size_t size)
{
#ifdef USE_MSC_ALLOC
	return _aligned_malloc(size, align);
#elif defined(USE_STD_ALLOC)
	return aligned_alloc(size, align);
#else
	// Ensure that we have space for the pointer and the data.
	std::size_t asize = aligned_offset(align, size + (sizeof(void*) * 2));

	// Allocate memory and store integer representation of pointer.
	void* ptr = malloc(asize);

	// Calculate actual aligned position
	intptr_t ptr_off = static_cast<intptr_t>(aligned_offset(align, reinterpret_cast<size_t>(ptr) + sizeof(void*)));

	// Store actual pointer at ptr_off - sizeof(void*).
	*reinterpret_cast<intptr_t*>(ptr_off - sizeof(void*)) = reinterpret_cast<intptr_t>(ptr);

	// Return aligned pointer
	return reinterpret_cast<void*>(ptr_off);
#endif
}

void streamfx::util::memory::free_aligned(void* mem)
{
#ifdef USE_MSC_ALLOC
	_aligned_free(mem);
#elif defined(USE_STD_ALLOC_FREE)
	free(mem);
#else
	if (mem == nullptr)
		return;
	void* ptr = reinterpret_cast<void*>(*reinterpret_cast<intptr_t*>(static_cast<char*>(mem) - sizeof(void*)));
	free(ptr);
#endif
}
