// AUTOGENERATED COPYRIGHT HEADER START
// Copyright (C) 2021-2023 Michael Fabian 'Xaymar' Dirks <info@xaymar.com>
// AUTOGENERATED COPYRIGHT HEADER END

#pragma once
#include "warning-disable.hpp"
#include <filesystem>
#include <string>
#include "warning-enable.hpp"

namespace streamfx::util::platform {
#ifdef WIN32
	std::string           native_to_utf8(std::wstring const& v);
	std::filesystem::path native_to_utf8(std::filesystem::path const& v);

	std::wstring          utf8_to_native(std::string const& v);
	std::filesystem::path utf8_to_native(std::filesystem::path const& v);
#else
	inline std::string native_to_utf8(std::string const& v)
	{
		return std::string(v);
	};
	inline std::filesystem::path native_to_utf8(std::filesystem::path const& v)
	{
		return std::filesystem::path(v);
	};

	inline std::string utf8_to_native(std::string const& v)
	{
		return std::string(v);
	};
	inline std::filesystem::path utf8_to_native(std::filesystem::path const& v)
	{
		return std::filesystem::path(v);
	};
#endif
} // namespace streamfx::util::platform
