// AUTOGENERATED COPYRIGHT HEADER START
// Copyright (C) 2021-2023 Michael Fabian 'Xaymar' Dirks <info@xaymar.com>
// AUTOGENERATED COPYRIGHT HEADER END

#include "util-platform.hpp"
#include "util-logging.hpp"

#ifdef _DEBUG
#define ST_PREFIX "<%s> "
#define D_LOG_ERROR(x, ...) P_LOG_ERROR(ST_PREFIX##x, __FUNCTION_SIG__, __VA_ARGS__)
#define D_LOG_WARNING(x, ...) P_LOG_WARN(ST_PREFIX##x, __FUNCTION_SIG__, __VA_ARGS__)
#define D_LOG_INFO(x, ...) P_LOG_INFO(ST_PREFIX##x, __FUNCTION_SIG__, __VA_ARGS__)
#define D_LOG_DEBUG(x, ...) P_LOG_DEBUG(ST_PREFIX##x, __FUNCTION_SIG__, __VA_ARGS__)
#else
#define ST_PREFIX "<util::platform> "
#define D_LOG_ERROR(...) P_LOG_ERROR(ST_PREFIX __VA_ARGS__)
#define D_LOG_WARNING(...) P_LOG_WARN(ST_PREFIX __VA_ARGS__)
#define D_LOG_INFO(...) P_LOG_INFO(ST_PREFIX __VA_ARGS__)
#define D_LOG_DEBUG(...) P_LOG_DEBUG(ST_PREFIX __VA_ARGS__)
#endif

#ifdef WIN32
#include "warning-disable.hpp"
#include <Windows.h>
#include "warning-enable.hpp"

std::string streamfx::util::platform::native_to_utf8(std::wstring const& v)
{
	std::vector<char> buffer((v.length() + 1) * 4, 0);

	int res = WideCharToMultiByte(CP_UTF8, 0, v.c_str(), static_cast<int>(v.length()), buffer.data(), static_cast<int>(buffer.size()), nullptr, nullptr);
	if (res == 0) {
		D_LOG_WARNING("Failed to convert '%ls' to UTF-8 format.", v.c_str());
		throw std::runtime_error("Failed to convert Windows-native to UTF-8.");
	}

	return {buffer.data()};
}

std::filesystem::path streamfx::util::platform::native_to_utf8(std::filesystem::path const& v)
{
	auto wide   = v.wstring();
	auto narrow = native_to_utf8(wide);
	return std::filesystem::u8path(narrow);
}

std::wstring streamfx::util::platform::utf8_to_native(std::string const& v)
{
	std::vector<wchar_t> buffer(v.length() + 1, 0);

	int res = MultiByteToWideChar(CP_UTF8, 0, v.c_str(), static_cast<int>(v.length()), buffer.data(), static_cast<int>(buffer.size()));
	if (res == 0) {
		D_LOG_WARNING("Failed to convert '%s' to native format.", v.c_str());
		throw std::runtime_error("Failed to convert UTF-8 to Windows-native.");
	}

	return {buffer.data()};
}

std::filesystem::path streamfx::util::platform::utf8_to_native(std::filesystem::path const& v)
{
	auto narrow = v.string();
	auto wide   = utf8_to_native(narrow);
	return std::filesystem::path(wide);
}

#endif
