// AUTOGENERATED COPYRIGHT HEADER START
// Copyright (C) 2017-2023 Michael Fabian 'Xaymar' Dirks <info@xaymar.com>
// Copyright (C) 2021 William Pettersson <william@ewpettersson.se>
// AUTOGENERATED COPYRIGHT HEADER END

#include "util-logging.hpp"
#include "common.hpp"

#include "warning-disable.hpp"
#include <stdarg.h>
#include "warning-enable.hpp"

void streamfx::util::logging::log(level lvl, const char* format, ...)
{
	const static std::map<level, int32_t> level_map = {
		{level::LEVEL_DEBUG, LOG_DEBUG},
		{level::LEVEL_INFO, LOG_INFO},
		{level::LEVEL_WARN, LOG_WARNING},
		{level::LEVEL_ERROR, LOG_ERROR},
	};
	thread_local static std::vector<char> buffer;

	va_list vargs;
	va_start(vargs, format);

	va_list vargs_copy;
	va_copy(vargs_copy, vargs);
	int32_t ret = vsnprintf(buffer.data(), buffer.size(), format, vargs);
	buffer.resize(static_cast<size_t>(ret) + 1);
	ret = vsnprintf(buffer.data(), buffer.size(), format, vargs_copy);

	va_end(vargs);
	va_end(vargs_copy);

	blog(level_map.at(lvl), "[StreamFX] %s", buffer.data());
}
