// AUTOGENERATED COPYRIGHT HEADER START
// Copyright (C) 2022-2023 Michael Fabian 'Xaymar' Dirks <info@xaymar.com>
// AUTOGENERATED COPYRIGHT HEADER END

#pragma once
#include "common.hpp"
#include "obs-source.hpp"
#include "obs-tools.hpp"
#include "obs-weak-source.hpp"

namespace streamfx::obs {
	class source_active_child {
		::streamfx::obs::weak_source _parent;
		::streamfx::obs::weak_source _child;

		public:
		~source_active_child()
		{
			auto parent = _parent.lock();
			auto child  = _child.lock();
			if (parent && child) {
				obs_source_remove_active_child(parent, child);
			}
		}
		source_active_child(::streamfx::obs::source const& parent, ::streamfx::obs::source const& child) : _parent(parent), _child(child)
		{
			if (::streamfx::obs::tools::source_find_source(child, parent)) {
				throw std::runtime_error("Child contains Parent");
			} else if (!obs_source_add_active_child(parent, child)) {
				throw std::runtime_error("Child contains Parent");
			}
		}
	};
} // namespace streamfx::obs
