// AUTOGENERATED COPYRIGHT HEADER START
// Copyright (C) 2020-2023 Michael Fabian 'Xaymar' Dirks <info@xaymar.com>
// Copyright (C) 2022 lainon <GermanAizek@yandex.ru>
// AUTOGENERATED COPYRIGHT HEADER END

#pragma once
#include "common.hpp"
#include "obs/obs-source.hpp"
#include "util/util-event.hpp"

namespace streamfx::obs {
	template<typename T>
	class signal_handler_base {
		protected:
		std::string _signal;

		public:
		streamfx::util::event<T, calldata*> event;
	};

	template<typename T>
	class signal_handler : public signal_handler_base<T> {
		public:
		signal_handler(std::string_view signal, T keepalive) {}
		virtual ~signal_handler() = default;
	};

	template<>
	class signal_handler<std::shared_ptr<obs_source_t>> : public signal_handler_base<std::shared_ptr<obs_source_t>> {
		std::shared_ptr<obs_source_t> _keepalive;

		static void handle_signal(void* ptr, calldata* cd) noexcept
		{
			try {
				auto p = reinterpret_cast<signal_handler<std::shared_ptr<obs_source_t>>*>(ptr);
				p->event(p->_keepalive, cd);
			} catch (...) {
			}
		}

		public:
		signal_handler(std::string_view signal, std::shared_ptr<obs_source_t> keepalive) : _keepalive(keepalive)
		{
			_signal              = signal;
			signal_handler_t* sh = obs_source_get_signal_handler(_keepalive.get());
			signal_handler_connect(sh, _signal.c_str(), handle_signal, this);
		}
		virtual ~signal_handler()
		{
			event.clear();
			signal_handler_t* sh = obs_source_get_signal_handler(_keepalive.get());
			signal_handler_disconnect(sh, _signal.c_str(), handle_signal, this);
		}
	};

	typedef signal_handler<std::shared_ptr<obs_source_t>> source_signal_handler;

	// Audio Capture is also here, as it could be considered a signal.
	class audio_signal_handler {
		::streamfx::obs::source _keepalive;

		static void handle_audio(void* ptr, obs_source_t*, const struct audio_data* audio_data, bool muted) noexcept
		{
			try {
				auto p = reinterpret_cast<audio_signal_handler*>(ptr);
				p->event(p->_keepalive, audio_data, muted);
			} catch (...) {
			}
		}

		public:
		audio_signal_handler(::streamfx::obs::source const& keepalive) : _keepalive(keepalive), event()
		{
			obs_source_add_audio_capture_callback(_keepalive, handle_audio, this);
		}
		virtual ~audio_signal_handler()
		{
			event.clear();
			obs_source_remove_audio_capture_callback(_keepalive, handle_audio, this);
		}

		streamfx::util::event<::streamfx::obs::source, const struct audio_data*, bool> event;
	};

} // namespace streamfx::obs
