// AUTOGENERATED COPYRIGHT HEADER START
// Copyright (C) 2017-2023 Michael Fabian 'Xaymar' Dirks <info@xaymar.com>
// AUTOGENERATED COPYRIGHT HEADER END

#include "gs-vertex.hpp"

#include "warning-disable.hpp"
#include <stdexcept>
#include "warning-enable.hpp"

streamfx::obs::gs::vertex::vertex() : position(nullptr), normal(nullptr), tangent(nullptr), color(nullptr), _has_store(true), _store(nullptr)
{
	_store = streamfx::util::memory::malloc_aligned(16, sizeof(vec3) * 3 + sizeof(uint32_t) + sizeof(vec4) * MAXIMUM_UVW_LAYERS);

	std::size_t offset = 0;

	position = reinterpret_cast<vec3*>(reinterpret_cast<char*>(_store) + offset);
	offset += sizeof(vec3);

	normal = reinterpret_cast<vec3*>(reinterpret_cast<char*>(_store) + offset);
	offset += sizeof(vec3);

	tangent = reinterpret_cast<vec3*>(reinterpret_cast<char*>(_store) + offset);
	offset += sizeof(vec3);

	color = reinterpret_cast<uint32_t*>(reinterpret_cast<char*>(_store) + offset);
	offset += sizeof(uint32_t);

	for (std::size_t n = 0; n < MAXIMUM_UVW_LAYERS; n++) {
		uv[n] = reinterpret_cast<vec4*>(reinterpret_cast<char*>(_store) + offset);
		offset += sizeof(vec4);
	}
}

streamfx::obs::gs::vertex::~vertex()
{
	if (_has_store) {
		streamfx::util::memory::free_aligned(_store);
	}
}

streamfx::obs::gs::vertex::vertex(vec3* p, vec3* n, vec3* t, uint32_t* col, vec4* uvs[MAXIMUM_UVW_LAYERS]) : position(p), normal(n), tangent(t), color(col), _has_store(false)
{
	if (uvs != nullptr) {
		for (std::size_t idx = 0; idx < MAXIMUM_UVW_LAYERS; idx++) {
			this->uv[idx] = uvs[idx];
		}
	}
}
