// AUTOGENERATED COPYRIGHT HEADER START
// Copyright (C) 2017-2023 Michael Fabian 'Xaymar' Dirks <info@xaymar.com>
// AUTOGENERATED COPYRIGHT HEADER END

#pragma once
#include "common.hpp"

namespace streamfx::obs::gs {
	class texture {
		public:
		enum class type : uint8_t { Normal, Volume, Cube };

		enum class flags : uint8_t {
			None,
			Dynamic,
			BuildMipMaps,
			Shared,
			GlobalShared,
		};

		protected:
		gs_texture_t* _texture;
		bool          _is_owner = true;
		type          _type     = type::Normal;

		public:
		~texture();

		/*!
		 * \brief Create a 2D Texture
		 *
		 * \param width Width of the 2D Texture
		 * \param height Height of the 2D Texture
		 * \param format Color Format to use
		 * \param mip_levels Number of Mip Levels available
		 * \param mip_data Texture data including mipmaps
		 * \param texture_flags Texture Flags
		 */
		texture(uint32_t width, uint32_t height, gs_color_format format, uint32_t mip_levels, const uint8_t** mip_data, streamfx::obs::gs::texture::flags texture_flags);

		/*!
		 * \brief Create a 3D Texture
		 *
		 * \param width Width of the 3D Texture
		 * \param height Height of the 3D Texture
		 * \param depth Depth of the 3D Texture
		 * \param format Color Format to use
		 * \param mip_levels Number of Mip Levels available
		 * \param mip_data Texture data including mipmaps
		 * \param texture_flags Texture Flags
		 */
		texture(uint32_t width, uint32_t height, uint32_t depth, gs_color_format format, uint32_t mip_levels, const uint8_t** mip_data, streamfx::obs::gs::texture::flags texture_flags);

		/*!
		 * \brief Create a Cube Texture
		 *
		 * \param size Size of each Cube Maps face
		 * \param format Color Format to use
		 * \param mip_levels Number of Mip Levels available
		 * \param mip_data Texture data including mipmaps
		 * \param texture_flags Texture Flags
		 */
		texture(uint32_t size, gs_color_format format, uint32_t mip_levels, const uint8_t** mip_data, streamfx::obs::gs::texture::flags texture_flags);

		/*!
		* \brief Load a texture from a file
		*
		* Creates a new #GS::Texture from a file located on disk. If the
		* file can not be found, accessed or read, a #Plugin::file_not_found_error
		* will be thrown. If there is an error reading the file, a
		* #Plugin::io_error will be thrown.
		*
		* \param file File to create the texture from.
		*/
		texture(std::string file);

		/*!
		* \brief Create a texture from an existing gs_texture_t object.
		*/
		texture(gs_texture_t* tex, bool takeOwnership = false) : _texture(tex), _is_owner(takeOwnership) {}

		void load(int32_t unit);

		gs_texture_t* get_object();

		uint32_t get_width();

		uint32_t get_height();

		uint32_t get_depth();

		streamfx::obs::gs::texture::type get_type();

		gs_color_format get_color_format();
	};
} // namespace streamfx::obs::gs

P_ENABLE_BITMASK_OPERATORS(streamfx::obs::gs::texture::flags)
