// AUTOGENERATED COPYRIGHT HEADER START
// Copyright (C) 2017-2023 Michael Fabian 'Xaymar' Dirks <info@xaymar.com>
// Copyright (C) 2022 lainon <GermanAizek@yandex.ru>
// AUTOGENERATED COPYRIGHT HEADER END

#pragma once
#include "common.hpp"
#include "gs-texture.hpp"

namespace streamfx::obs::gs {
	class rendertarget_op;

	class rendertarget {
		friend class rendertarget_op;

		protected:
		gs_texrender_t* _render_target;
		bool            _is_being_rendered;

		gs_color_format    _color_format;
		gs_zstencil_format _zstencil_format;

		public:
		~rendertarget();

		rendertarget(gs_color_format colorFormat, gs_zstencil_format zsFormat);

		gs_texture_t* get_object();

		std::shared_ptr<streamfx::obs::gs::texture> get_texture();

		void get_texture(streamfx::obs::gs::texture& tex);

		void get_texture(std::shared_ptr<streamfx::obs::gs::texture>& tex);

		void get_texture(std::unique_ptr<streamfx::obs::gs::texture>& tex);

		gs_color_format get_color_format();

		gs_zstencil_format get_zstencil_format();

		streamfx::obs::gs::rendertarget_op render(uint32_t width, uint32_t height);

		streamfx::obs::gs::rendertarget_op render(uint32_t width, uint32_t height, gs_color_space cs);
	};

	class rendertarget_op {
		streamfx::obs::gs::rendertarget* parent;

		public:
		~rendertarget_op();

		rendertarget_op(streamfx::obs::gs::rendertarget* rt, uint32_t width, uint32_t height);

		rendertarget_op(streamfx::obs::gs::rendertarget* rt, uint32_t width, uint32_t height, gs_color_space cs);

		// Move Constructor
		rendertarget_op(streamfx::obs::gs::rendertarget_op&&) noexcept;

		// Copy Constructor
		rendertarget_op(const streamfx::obs::gs::rendertarget_op&) = delete;

		rendertarget_op& operator=(const streamfx::obs::gs::rendertarget_op& r) = delete;
	};
} // namespace streamfx::obs::gs
