// AUTOGENERATED COPYRIGHT HEADER START
// Copyright (C) 2023 Michael Fabian 'Xaymar' Dirks <info@xaymar.com>
// AUTOGENERATED COPYRIGHT HEADER END

#pragma once
#include "warning-disable.hpp"
#include <QObject>
#include <QString>
#include <QWidget>

#include <functional>
#include <string>

#include <util/util.hpp>
#include "warning-enable.hpp"

namespace streamfx::obs {
	struct QCefCookieManager {
		virtual ~QCefCookieManager() {}

		virtual bool DeleteCookies(const std::string& url, const std::string& name)                        = 0;
		virtual bool SetStoragePath(const std::string& storage_path, bool persist_session_cookies = false) = 0;
		virtual bool FlushStore()                                                                          = 0;

		typedef std::function<void(bool)> cookie_exists_cb;

		virtual void CheckForCookie(const std::string& site, const std::string& cookie, cookie_exists_cb callback) = 0;
	};

	class QCefWidget : public QWidget {
		Q_OBJECT

		protected:
		inline QCefWidget(QWidget* parent) : QWidget(parent) {}

		public:
		virtual void setURL(const std::string& url)              = 0;
		virtual void setStartupScript(const std::string& script) = 0;
		virtual void allowAllPopups(bool allow)                  = 0;
		virtual void closeBrowser()                              = 0;
		virtual void reloadPage()                                = 0;

		signals:
		void titleChanged(const QString& title);
		void urlChanged(const QString& url);
	};

	struct QCef {
		virtual ~QCef() {}

		virtual bool init_browser(void)          = 0;
		virtual bool initialized(void)           = 0;
		virtual bool wait_for_browser_init(void) = 0;

		virtual QCefWidget* create_widget(QWidget* parent, const std::string& url, QCefCookieManager* cookie_manager = nullptr) = 0;

		virtual QCefCookieManager* create_cookie_manager(const std::string& storage_path, bool persist_session_cookies = false) = 0;

		virtual BPtr<char> get_cookie_path(const std::string& storage_path) = 0;

		virtual void add_popup_whitelist_url(const std::string& url, QObject* obj) = 0;
		virtual void add_force_popup_url(const std::string& url, QObject* obj)     = 0;
	};
} // namespace streamfx::obs
