// AUTOGENERATED COPYRIGHT HEADER START
// Copyright (C) 2021-2023 Michael Fabian 'Xaymar' Dirks <info@xaymar.com>
// Copyright (C) 2022 lainon <GermanAizek@yandex.ru>
// AUTOGENERATED COPYRIGHT HEADER END

#include "gfx-util.hpp"
#include "graphics/matrix4.h"
#include "obs/gs/gs-helper.hpp"
#include "plugin.hpp"
#include "util/util-logging.hpp"

#include "warning-disable.hpp"
#include <mutex>
#include "warning-enable.hpp"

#ifdef _DEBUG
#define ST_PREFIX "<%s> "
#define D_LOG_ERROR(x, ...) P_LOG_ERROR(ST_PREFIX##x, __FUNCTION_SIG__, __VA_ARGS__)
#define D_LOG_WARNING(x, ...) P_LOG_WARN(ST_PREFIX##x, __FUNCTION_SIG__, __VA_ARGS__)
#define D_LOG_INFO(x, ...) P_LOG_INFO(ST_PREFIX##x, __FUNCTION_SIG__, __VA_ARGS__)
#define D_LOG_DEBUG(x, ...) P_LOG_DEBUG(ST_PREFIX##x, __FUNCTION_SIG__, __VA_ARGS__)
#else
#define ST_PREFIX "<gfx::debug> "
#define D_LOG_ERROR(...) P_LOG_ERROR(ST_PREFIX __VA_ARGS__)
#define D_LOG_WARNING(...) P_LOG_WARN(ST_PREFIX __VA_ARGS__)
#define D_LOG_INFO(...) P_LOG_INFO(ST_PREFIX __VA_ARGS__)
#define D_LOG_DEBUG(...) P_LOG_DEBUG(ST_PREFIX __VA_ARGS__)
#endif

std::shared_ptr<streamfx::gfx::util> streamfx::gfx::util::get()
{
	static std::weak_ptr<streamfx::gfx::util> instance;
	static std::mutex                         lock;

	std::unique_lock<std::mutex> ul(lock);
	if (instance.expired()) {
		auto hard_instance = std::shared_ptr<streamfx::gfx::util>(new streamfx::gfx::util());
		instance           = hard_instance;
		return hard_instance;
	}
	return instance.lock();
}

streamfx::gfx::util::util()
{
	{
		std::filesystem::path file = ::streamfx::data_file_path("effects/standard.effect");
		try {
			_effect = std::make_shared<::streamfx::obs::gs::effect>(file);
		} catch (...) {
			D_LOG_ERROR("Failed to load '%s'.", file.generic_u8string().c_str());
		}
	}
}

streamfx::gfx::util::~util()
{
	obs::gs::context gctx{};

	_point_vb.reset();
	_line_vb.reset();
	_arrow_vb.reset();
	_quad_vb.reset();
}

void streamfx::gfx::util::draw_point(float x, float y, uint32_t color)
{
	obs::gs::context gctx{};

	if (!_point_vb) {
		_point_vb = std::make_shared<obs::gs::vertex_buffer>(uint32_t{1}, uint8_t{1});
	}

	{
		auto vtx = _point_vb->at(0);
		vec3_set(vtx.position, x, y, 0.);
		*vtx.color = color;
	}

	gs_load_indexbuffer(nullptr);
	gs_load_vertexbuffer(_point_vb->update(true));
	while (gs_effect_loop(_effect->get_object(), "Color")) {
		gs_draw(GS_POINTS, 0, 1);
	}
	gs_load_vertexbuffer(nullptr);
}

void streamfx::gfx::util::draw_line(float x, float y, float x2, float y2, uint32_t color /*= 0xFFFFFFFF*/)
{
	obs::gs::context gctx{};

	if (!_line_vb) {
		_line_vb = std::make_shared<obs::gs::vertex_buffer>(uint32_t{2}, uint8_t{1});
	}

	{
		auto vtx = _line_vb->at(0);
		vec3_set(vtx.position, x, y, 0.);
		*vtx.color = color;
	}
	{
		auto vtx = _line_vb->at(1);
		vec3_set(vtx.position, x2, y2, 0.);
		*vtx.color = color;
	}

	gs_load_indexbuffer(nullptr);
	gs_load_vertexbuffer(_line_vb->update(true));
	while (gs_effect_loop(_effect->get_object(), "Color")) {
		gs_draw(GS_LINES, 0, 2);
	}
	gs_load_vertexbuffer(nullptr);
}

void streamfx::gfx::util::draw_arrow(float x, float y, float x2, float y2, float w /*= 0.*/, uint32_t color /*= 0xFFFFFFFF*/)
{
	obs::gs::context gctx{};

	if (!_arrow_vb) {
		_arrow_vb = std::make_shared<obs::gs::vertex_buffer>(uint32_t{5}, uint8_t{1});
	}

	float dx  = x2 - x;
	float dy  = y2 - y;
	float ang = atan2(-dx, dy);
	float len = sqrt(dx * dx + dy * dy);

	if (abs(w) <= 1) {
		w = len / 3.f;
	}

	matrix4 rotator;
	matrix4_identity(&rotator);
	matrix4_rotate_aa4f(&rotator, &rotator, 0, 0, 1, ang);
	vec3 offset;
	vec3_set(&offset, x, y, 0.);

	{
		auto vtx = _arrow_vb->at(0);
		vec3_set(vtx.position, 0, 0, 0.);
		vec3_transform(vtx.position, vtx.position, &rotator);
		vec3_add(vtx.position, vtx.position, &offset);
		*vtx.color = color;
	}
	{
		auto vtx = _arrow_vb->at(1);
		vec3_set(vtx.position, 0, len, 0.);
		vec3_transform(vtx.position, vtx.position, &rotator);
		vec3_add(vtx.position, vtx.position, &offset);
		*vtx.color = color;
	}
	{
		auto vtx = _arrow_vb->at(2);
		vec3_set(vtx.position, -w, len - w, 0.);
		vec3_transform(vtx.position, vtx.position, &rotator);
		vec3_add(vtx.position, vtx.position, &offset);
		*vtx.color = color;
	}
	{
		auto vtx = _arrow_vb->at(3);
		vec3_set(vtx.position, w, len - w, 0.);
		vec3_transform(vtx.position, vtx.position, &rotator);
		vec3_add(vtx.position, vtx.position, &offset);
		*vtx.color = color;
	}
	{
		auto vtx = _arrow_vb->at(4);
		vec3_set(vtx.position, 0, len, 0.);
		vec3_transform(vtx.position, vtx.position, &rotator);
		vec3_add(vtx.position, vtx.position, &offset);
		*vtx.color = color;
	}

	gs_load_indexbuffer(nullptr);
	gs_load_vertexbuffer(_arrow_vb->update(true));
	while (gs_effect_loop(_effect->get_object(), "Color")) {
		gs_draw(GS_LINESTRIP, 0, 5);
	}
	gs_load_vertexbuffer(nullptr);
}

void streamfx::gfx::util::draw_rectangle(float x, float y, float w, float h, bool frame, uint32_t color /*= 0xFFFFFFFF*/)
{
	obs::gs::context gctx{};

	if (!_quad_vb) {
		_quad_vb = std::make_shared<obs::gs::vertex_buffer>(uint32_t{5}, uint8_t{1});
	}

	if (frame) {
		{
			auto vtx = _quad_vb->at(0);
			vec3_set(vtx.position, x, y, 0.);
			*vtx.color = color;
		}
		{
			auto vtx = _quad_vb->at(1);
			vec3_set(vtx.position, x + w, y, 0.);
			*vtx.color = color;
		}
		{
			auto vtx = _quad_vb->at(2);
			vec3_set(vtx.position, x + w, y + h, 0.);
			*vtx.color = color;
		}
		{
			auto vtx = _quad_vb->at(3);
			vec3_set(vtx.position, x, y + h, 0.);
			*vtx.color = color;
		}
		{
			auto vtx = _quad_vb->at(4);
			vec3_set(vtx.position, x, y, 0.);
			*vtx.color = color;
		}

		gs_load_indexbuffer(nullptr);
		gs_load_vertexbuffer(_quad_vb->update(true));
		while (gs_effect_loop(_effect->get_object(), "Color")) {
			gs_draw(GS_LINESTRIP, 0, 5);
		}
		gs_load_vertexbuffer(nullptr);
	} else {
		{
			auto vtx = _quad_vb->at(0);
			vec3_set(vtx.position, x, y, 0.);
			*vtx.color = color;
		}
		{
			auto vtx = _quad_vb->at(1);
			vec3_set(vtx.position, x + w, y, 0.);
			*vtx.color = color;
		}
		{
			auto vtx = _quad_vb->at(2);
			vec3_set(vtx.position, x, y + h, 0.);
			*vtx.color = color;
		}
		{
			auto vtx = _quad_vb->at(3);
			vec3_set(vtx.position, x + w, y + h, 0.);
			*vtx.color = color;
		}

		gs_load_indexbuffer(nullptr);
		gs_load_vertexbuffer(_quad_vb->update(true));
		while (gs_effect_loop(_effect->get_object(), "Color")) {
			gs_draw(GS_TRISTRIP, 0, 4);
		}
		gs_load_vertexbuffer(nullptr);
	}
}

void streamfx::gfx::util::draw_fullscreen_triangle()
{
	if (!_fstri_vb) {
		_fstri_vb = std::make_shared<streamfx::obs::gs::vertex_buffer>(uint32_t(3), uint8_t(1));
		{
			auto vtx = _fstri_vb->at(0);
			vec3_set(vtx.position, 0, 0, 0);
			vec4_set(vtx.uv[0], 0, 0, 0, 0);
		}
		{
			auto vtx = _fstri_vb->at(1);
			vec3_set(vtx.position, 2, 0, 0);
			vec4_set(vtx.uv[0], 2, 0, 0, 0);
		}
		{
			auto vtx = _fstri_vb->at(2);
			vec3_set(vtx.position, 0, 2, 0);
			vec4_set(vtx.uv[0], 0, 2, 0, 0);
		}
		_fstri_vb->update();
	}

	gs_load_indexbuffer(nullptr);
	gs_load_vertexbuffer(_fstri_vb->update(false));
	gs_draw(GS_TRIS, 0, 3); //_gs_fstri_vb->size());
	gs_load_vertexbuffer(nullptr);
}
