// AUTOGENERATED COPYRIGHT HEADER START
// Copyright (C) 2017-2023 Michael Fabian 'Xaymar' Dirks <info@xaymar.com>
// AUTOGENERATED COPYRIGHT HEADER END

#pragma once
#include "common.hpp"

#include "warning-disable.hpp"
#include <filesystem>
#include <memory>
#include <new>
#include "warning-enable.hpp"

namespace streamfx {
	class configuration {
		std::filesystem::path _config_path;

		std::shared_ptr<obs_data_t> _data;

#if __cpp_lib_hardware_interference_size >= 201603
		alignas(std::hardware_destructive_interference_size)
#endif
			std::mutex _task_lock;

		std::shared_ptr<streamfx::util::threadpool::task> _save_task;

		public:
		~configuration();

		private:
		configuration();

		public:
		void save();

		public:
		std::shared_ptr<obs_data_t> get();

		uint64_t version();

		bool is_different_version();

		public /* Singleton */:
		static std::shared_ptr<streamfx::configuration> instance();
	};
} // namespace streamfx
