// AUTOGENERATED COPYRIGHT HEADER START
// Copyright (C) 2017-2023 Michael Fabian 'Xaymar' Dirks <info@xaymar.com>
// AUTOGENERATED COPYRIGHT HEADER END

#pragma once

#include "warning-disable.hpp"

// Common C includes
#include <cfloat>
#include <cinttypes>
#include <climits>
#include <clocale>
#include <cmath>
#include <cstddef>
#include <cstdint>
#include <cstring>
#include <ctime>

// Common C++ includes
#include <algorithm>
#include <array>
#include <limits>
#include <map>
#include <memory>
#include <set>
#include <stdexcept>
#include <string>
#include <string_view>
#include <type_traits>
#include <utility>
#include <vector>

#include "warning-enable.hpp"

// Common Plugin includes
#include "config.hpp"
#include "strings.hpp"
#include "version.hpp"
#include "util/util-bitmask.hpp"
#include "util/util-library.hpp"
#include "util/util-profiler.hpp"
#include "util/util-threadpool.hpp"
#include "util/utility.hpp"

// Common OBS includes
#include "warning-disable.hpp"
extern "C" {
#include <obs.h>

#include <obs-config.h>
#include <obs-data.h>
#include <obs-encoder.h>
#include <obs-module.h>
#include <obs-properties.h>
#include <obs-source.h>

#include <graphics/graphics.h>

#include <graphics/effect.h>
#include <graphics/matrix4.h>
#include <graphics/vec2.h>
#include <graphics/vec3.h>
#include <graphics/vec4.h>

#include <util/platform.h>

// Fix libOBS's global defines
#undef strtoll
}
#include "warning-enable.hpp"

// Common Global defines
/// Logging
#define DLOG_(level, ...) blog(level, "[" S_PLUGIN_NAME "] " __VA_ARGS__)
#define DLOG_ERROR(...) DLOG_(LOG_ERROR, __VA_ARGS__)
#define DLOG_WARNING(...) DLOG_(LOG_WARNING, __VA_ARGS__)
#define DLOG_INFO(...) DLOG_(LOG_INFO, __VA_ARGS__)
#define DLOG_DEBUG(...) DLOG_(LOG_DEBUG, __VA_ARGS__)
/// Currrent function name (as const char*)
#ifdef _MSC_VER
// Microsoft Visual Studio
#define __FUNCTION_SIG__ __FUNCSIG__
#define __FUNCTION_NAME__ __func__
#elif defined(__GNUC__) || defined(__MINGW32__)
// GCC and MinGW
#define __FUNCTION_SIG__ __PRETTY_FUNCTION__
#define __FUNCTION_NAME__ __func__
#else
// Any other compiler
#define __FUNCTION_SIG__ __func__
#define __FUNCTION_NAME__ __func__
#endif
/// Forceful inlining
#ifndef FORCE_INLINE
#ifdef _MSC_VER
#define FORCE_INLINE __force_inline
#elif defined(__GNUC__) || defined(__MINGW32__)
#define FORCE_INLINE __attribute__((always_inline))
#else
#define FORCE_INLINE inline
#endif
#endif
