// AUTOGENERATED COPYRIGHT HEADER START
// Copyright (C) 2017-2023 Michael Fabian 'Xaymar' Dirks <info@xaymar.com>
// AUTOGENERATED COPYRIGHT HEADER END

#pragma once
#include "common.hpp"
#include "gfx/gfx-mipmapper.hpp"
#include "gfx/gfx-util.hpp"
#include "obs/gs/gs-rendertarget.hpp"
#include "obs/gs/gs-texture.hpp"
#include "obs/gs/gs-vertexbuffer.hpp"
#include "obs/obs-source-factory.hpp"

#include "warning-disable.hpp"
#include <vector>
#include "warning-enable.hpp"

namespace streamfx::filter::transform {
	enum class transform_mode {
		ORTHOGRAPHIC = 0,
		PERSPECTIVE  = 1,
		CORNER_PIN   = 2,
	};

	class transform_instance : public obs::source_instance {
		std::shared_ptr<streamfx::gfx::util> _gfx_util;

		// Settings
		transform_mode _camera_mode;
		float          _camera_fov;
		struct {
			vec3     position;
			vec3     rotation;
			uint32_t rotation_order;
			vec3     scale;
			vec3     shear;
		} _params;
		struct {
			vec2 tl;
			vec2 tr;
			vec2 bl;
			vec2 br;
		} _corners;

		// Data
		streamfx::obs::gs::effect  _standard_effect;
		streamfx::obs::gs::effect  _transform_effect;
		streamfx::obs::gs::sampler _sampler;

		// Cache
		bool                                             _cache_rendered;
		std::shared_ptr<streamfx::obs::gs::rendertarget> _cache_rt;
		std::shared_ptr<streamfx::obs::gs::texture>      _cache_texture;

		// Mip-mapping
		bool                                        _mipmap_enabled;
		bool                                        _mipmap_rendered;
		streamfx::gfx::mipmapper                    _mipmapper;
		std::shared_ptr<streamfx::obs::gs::texture> _mipmap_texture;

		// Input
		bool                                             _source_rendered;
		std::pair<uint32_t, uint32_t>                    _source_size;
		std::shared_ptr<streamfx::obs::gs::rendertarget> _source_rt;
		std::shared_ptr<streamfx::obs::gs::texture>      _source_texture;

		// Mesh
		bool                                              _update_mesh;
		std::shared_ptr<streamfx::obs::gs::vertex_buffer> _vertex_buffer;

		public:
		transform_instance(obs_data_t*, obs_source_t*);
		virtual ~transform_instance() override;

		virtual void load(obs_data_t* settings) override;
		virtual void migrate(obs_data_t* data, uint64_t version) override;
		virtual void update(obs_data_t*) override;

		virtual void video_tick(float) override;
		virtual void video_render(gs_effect_t*) override;
	};

	class transform_factory : public obs::source_factory<filter::transform::transform_factory, filter::transform::transform_instance> {
		public:
		transform_factory();
		virtual ~transform_factory() override;

		virtual const char* get_name() override;

		virtual void get_defaults2(obs_data_t* data) override;

		virtual obs_properties_t* get_properties2(filter::transform::transform_instance* data) override;

		static bool on_manual_open(obs_properties_t* props, obs_property_t* property, void* data);

		public: // Singleton
		static std::shared_ptr<transform_factory> instance();
	};
} // namespace streamfx::filter::transform
